/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver.impl;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileBaseImpl;
import org.apache.hadoop.hdfs.server.federation.store.records.BaseRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateStoreFileSystemImpl
extends StateStoreFileBaseImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StateStoreFileSystemImpl.class);
    public static final String FEDERATION_STORE_FS_PATH = "dfs.federation.router.store.driver.fs.path";
    private FileSystem fs;
    private String workPath;

    @Override
    protected boolean exists(String path) {
        try {
            return this.fs.exists(new Path(path));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected boolean mkdir(String path) {
        try {
            return this.fs.mkdirs(new Path(path));
        }
        catch (IOException e) {
            return false;
        }
    }

    @Override
    protected boolean rename(String src, String dst) {
        try {
            if (this.fs instanceof DistributedFileSystem) {
                DistributedFileSystem dfs = (DistributedFileSystem)this.fs;
                dfs.rename(new Path(src), new Path(dst), new Options.Rename[]{Options.Rename.OVERWRITE});
                return true;
            }
            if (this.fs.exists(new Path(dst))) {
                this.fs.delete(new Path(dst), true);
            }
            return this.fs.rename(new Path(src), new Path(dst));
        }
        catch (Exception e) {
            LOG.error("Cannot rename {} to {}", new Object[]{src, dst, e});
            return false;
        }
    }

    @Override
    protected boolean remove(String path) {
        try {
            return this.fs.delete(new Path(path), true);
        }
        catch (Exception e) {
            LOG.error("Cannot remove {}", (Object)path, (Object)e);
            return false;
        }
    }

    @Override
    protected String getRootDir() {
        if (this.workPath == null) {
            String rootPath = this.getConf().get(FEDERATION_STORE_FS_PATH);
            try {
                URI workUri = new URI(rootPath);
                this.fs = FileSystem.get((URI)workUri, (Configuration)this.getConf());
            }
            catch (Exception ex) {
                return null;
            }
            this.workPath = rootPath;
        }
        return this.workPath;
    }

    @Override
    public void close() throws Exception {
        if (this.fs != null) {
            this.fs.close();
        }
    }

    @Override
    protected <T extends BaseRecord> BufferedReader getReader(String pathName) {
        BufferedReader reader = null;
        Path path = new Path(pathName);
        try {
            FSDataInputStream fdis = this.fs.open(path);
            InputStreamReader isr = new InputStreamReader((InputStream)fdis, StandardCharsets.UTF_8);
            reader = new BufferedReader(isr);
        }
        catch (IOException ex) {
            LOG.error("Cannot open read stream for {}", (Object)path);
        }
        return reader;
    }

    @Override
    protected <T extends BaseRecord> BufferedWriter getWriter(String pathName) {
        BufferedWriter writer = null;
        Path path = new Path(pathName);
        try {
            FSDataOutputStream fdos = this.fs.create(path, true);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fdos, StandardCharsets.UTF_8);
            writer = new BufferedWriter(osw);
        }
        catch (IOException ex) {
            LOG.error("Cannot open write stream for {}", (Object)path);
        }
        return writer;
    }

    @Override
    protected List<String> getChildren(String pathName) {
        LinkedList<String> ret = new LinkedList<String>();
        Path path = new Path(this.workPath, pathName);
        try {
            FileStatus[] files;
            for (FileStatus file : files = this.fs.listStatus(path)) {
                Path filePath = file.getPath();
                String fileName = filePath.getName();
                ret.add(fileName);
            }
        }
        catch (Exception e) {
            LOG.error("Cannot get children for {}", (Object)pathName, (Object)e);
        }
        return ret;
    }
}

