/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.resolver;

import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.server.federation.resolver.FederationNamenodeServiceState;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;

public class NamenodeStatusReport {
    private String nameserviceId = "";
    private String namenodeId = "";
    private String clusterId = "";
    private String blockPoolId = "";
    private String rpcAddress = "";
    private String serviceAddress = "";
    private String lifelineAddress = "";
    private String webAddress = "";
    private HAServiceProtocol.HAServiceState status = HAServiceProtocol.HAServiceState.STANDBY;
    private boolean safeMode = false;
    private int liveDatanodes = -1;
    private int deadDatanodes = -1;
    private int decomDatanodes = -1;
    private int liveDecomDatanodes = -1;
    private int deadDecomDatanodes = -1;
    private long availableSpace = -1L;
    private long numOfFiles = -1L;
    private long numOfBlocks = -1L;
    private long numOfBlocksMissing = -1L;
    private long numOfBlocksPendingReplication = -1L;
    private long numOfBlocksUnderReplicated = -1L;
    private long numOfBlocksPendingDeletion = -1L;
    private long totalSpace = -1L;
    private boolean registrationValid = false;
    private boolean statsValid = false;
    private boolean haStateValid = false;

    public NamenodeStatusReport(String ns, String nn, String rpc, String service, String lifeline, String web) {
        this.nameserviceId = ns;
        this.namenodeId = nn;
        this.rpcAddress = rpc;
        this.serviceAddress = service;
        this.lifelineAddress = lifeline;
        this.webAddress = web;
    }

    public boolean statsValid() {
        return this.statsValid;
    }

    public boolean registrationValid() {
        return this.registrationValid;
    }

    public boolean haStateValid() {
        return this.haStateValid;
    }

    public FederationNamenodeServiceState getState() {
        if (!this.registrationValid) {
            return FederationNamenodeServiceState.UNAVAILABLE;
        }
        if (this.haStateValid) {
            return FederationNamenodeServiceState.getState(this.status);
        }
        return FederationNamenodeServiceState.ACTIVE;
    }

    public String getNameserviceId() {
        return this.nameserviceId;
    }

    public String getNamenodeId() {
        return this.namenodeId;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getBlockPoolId() {
        return this.blockPoolId;
    }

    public String getRpcAddress() {
        return this.rpcAddress;
    }

    public String getServiceAddress() {
        return this.serviceAddress;
    }

    public String getLifelineAddress() {
        return this.lifelineAddress;
    }

    public String getWebAddress() {
        return this.webAddress;
    }

    public void setHAServiceState(HAServiceProtocol.HAServiceState state) {
        this.status = state;
        this.haStateValid = true;
    }

    public void setNamespaceInfo(NamespaceInfo info) {
        this.clusterId = info.getClusterID();
        this.blockPoolId = info.getBlockPoolID();
        this.registrationValid = true;
    }

    public void setSafeMode(boolean safemode) {
        this.safeMode = safemode;
    }

    public boolean getSafemode() {
        return this.safeMode;
    }

    public void setDatanodeInfo(int numLive, int numDead, int numDecom, int numLiveDecom, int numDeadDecom) {
        this.liveDatanodes = numLive;
        this.deadDatanodes = numDead;
        this.decomDatanodes = numDecom;
        this.liveDecomDatanodes = numLiveDecom;
        this.deadDecomDatanodes = numDeadDecom;
        this.statsValid = true;
    }

    public int getNumLiveDatanodes() {
        return this.liveDatanodes;
    }

    public int getNumDeadDatanodes() {
        return this.deadDatanodes;
    }

    public int getNumDecommissioningDatanodes() {
        return this.decomDatanodes;
    }

    public int getNumDecomLiveDatanodes() {
        return this.liveDecomDatanodes;
    }

    public int getNumDecomDeadDatanodes() {
        return this.deadDecomDatanodes;
    }

    public void setNamesystemInfo(long available, long total, long numFiles, long numBlocks, long numBlocksMissing, long numBlocksPendingReplication, long numBlocksUnderReplicated, long numBlocksPendingDeletion) {
        this.totalSpace = total;
        this.availableSpace = available;
        this.numOfBlocks = numBlocks;
        this.numOfBlocksMissing = numBlocksMissing;
        this.numOfBlocksPendingReplication = numBlocksPendingReplication;
        this.numOfBlocksUnderReplicated = numBlocksUnderReplicated;
        this.numOfBlocksPendingDeletion = numBlocksPendingDeletion;
        this.numOfFiles = numFiles;
        this.statsValid = true;
    }

    public long getNumBlocks() {
        return this.numOfBlocks;
    }

    public long getNumFiles() {
        return this.numOfFiles;
    }

    public long getTotalSpace() {
        return this.totalSpace;
    }

    public long getAvailableSpace() {
        return this.availableSpace;
    }

    public long getNumBlocksMissing() {
        return this.numOfBlocksMissing;
    }

    public long getNumOfBlocksPendingReplication() {
        return this.numOfBlocksPendingReplication;
    }

    public long getNumOfBlocksUnderReplicated() {
        return this.numOfBlocksUnderReplicated;
    }

    public long getNumOfBlocksPendingDeletion() {
        return this.numOfBlocksPendingDeletion;
    }

    public void setRegistrationValid(boolean isValid) {
        this.registrationValid = isValid;
    }

    public String toString() {
        return String.format("%s-%s:%s", this.nameserviceId, this.namenodeId, this.serviceAddress);
    }
}

