/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.proto.ClientAMProtocol;
import org.apache.hadoop.yarn.service.ServiceContext;
import org.apache.hadoop.yarn.service.api.records.ComponentContainers;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.component.instance.ComponentInstance;

public class FilterUtils {
    public static List<ComponentContainers> filterInstances(ServiceContext context, ClientAMProtocol.GetCompInstancesRequestProto filterReq) {
        HashMap containersByComp = new HashMap();
        Map<ContainerId, ComponentInstance> instances = context.scheduler.getLiveInstances();
        instances.forEach((containerId, instance) -> {
            String instanceServiceVersion;
            boolean include = true;
            if (filterReq.getComponentNamesList() != null && !filterReq.getComponentNamesList().isEmpty() && !filterReq.getComponentNamesList().contains((Object)instance.getComponent().getName())) {
                include = false;
            }
            if (!(filterReq.getVersion() == null || filterReq.getVersion().isEmpty() || (instanceServiceVersion = instance.getServiceVersion()) != null && instanceServiceVersion.equals(filterReq.getVersion()))) {
                include = false;
            }
            if (filterReq.getContainerStatesList() != null && !filterReq.getContainerStatesList().isEmpty() && !filterReq.getContainerStatesList().contains((Object)instance.getContainerState().toString())) {
                include = false;
            }
            if (include) {
                ComponentContainers compContainers = containersByComp.computeIfAbsent(instance.getCompName(), k -> {
                    ComponentContainers result = new ComponentContainers();
                    result.setContainers(new ArrayList<Container>());
                    result.setComponentName(instance.getCompName());
                    return result;
                });
                compContainers.addContainer(instance.getContainerSpec());
            }
        });
        ArrayList<ComponentContainers> result = new ArrayList<ComponentContainers>();
        result.addAll(containersByComp.values());
        return result;
    }
}

