/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.oncrpc;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioDatagramChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.apache.hadoop.oncrpc.RpcUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleUdpServer {
    public static final Logger LOG = LoggerFactory.getLogger(SimpleUdpServer.class);
    private final int SEND_BUFFER_SIZE = 65536;
    private final int RECEIVE_BUFFER_SIZE = 65536;
    protected final int port;
    protected final ChannelInboundHandlerAdapter rpcProgram;
    protected final int workerCount;
    protected int boundPort = -1;
    private Bootstrap server;
    private Channel ch;
    private EventLoopGroup workerGroup;

    public SimpleUdpServer(int port, ChannelInboundHandlerAdapter program, int workerCount) {
        this.port = port;
        this.rpcProgram = program;
        this.workerCount = workerCount;
    }

    public void run() throws InterruptedException {
        this.workerGroup = new NioEventLoopGroup(this.workerCount, (Executor)Executors.newCachedThreadPool());
        this.server = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.server.group(this.workerGroup)).channel(NioDatagramChannel.class)).option(ChannelOption.SO_BROADCAST, (Object)true)).option(ChannelOption.SO_SNDBUF, (Object)65536)).option(ChannelOption.SO_RCVBUF, (Object)65536)).option(ChannelOption.SO_REUSEADDR, (Object)true)).handler((ChannelHandler)new ChannelInitializer<NioDatagramChannel>(){

            protected void initChannel(NioDatagramChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new ChannelHandler[]{RpcUtil.STAGE_RPC_MESSAGE_PARSER, SimpleUdpServer.this.rpcProgram, RpcUtil.STAGE_RPC_UDP_RESPONSE});
            }
        });
        ChannelFuture f = this.server.bind((SocketAddress)new InetSocketAddress(this.port)).sync();
        this.ch = f.channel();
        InetSocketAddress socketAddr = (InetSocketAddress)this.ch.localAddress();
        this.boundPort = socketAddr.getPort();
        LOG.info("Started listening to UDP requests at port " + this.boundPort + " for " + this.rpcProgram + " with workerCount " + this.workerCount);
    }

    public int getBoundPort() {
        return this.boundPort;
    }

    public void shutdown() {
        if (this.ch != null) {
            this.ch.close().awaitUninterruptibly();
            this.ch = null;
        }
        if (this.workerGroup != null) {
            this.workerGroup.shutdownGracefully();
            this.workerGroup = null;
        }
    }
}

