/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.compress.bzip2;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.io.compress.bzip2.BZip2TextFileWriter;
import org.apache.hadoop.io.compress.bzip2.BZip2Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public final class TestBZip2TextFileWriter {
    private static final byte[] DELIMITER = new byte[]{0};
    private ByteArrayOutputStream rawOut;
    private BZip2TextFileWriter writer;

    @Before
    public void setUp() throws Exception {
        this.rawOut = new ByteArrayOutputStream();
        this.writer = new BZip2TextFileWriter(this.rawOut);
    }

    @After
    public void tearDown() throws Exception {
        this.rawOut = null;
        this.writer.close();
    }

    @Test
    public void writingSingleBlockSizeOfData() throws Exception {
        this.writer.writeRecord(BZip2TextFileWriter.BLOCK_SIZE, DELIMITER);
        this.writer.close();
        List<Long> nextBlocks = this.getNextBlockMarkerOffsets();
        Assert.assertEquals((long)0L, (long)nextBlocks.size());
    }

    @Test
    public void justExceedingBeyondBlockSize() throws Exception {
        this.writer.writeRecord(BZip2TextFileWriter.BLOCK_SIZE + 1, DELIMITER);
        this.writer.close();
        List<Long> nextBlocks = this.getNextBlockMarkerOffsets();
        Assert.assertEquals((long)1L, (long)nextBlocks.size());
    }

    @Test
    public void writingTwoBlockSizesOfData() throws Exception {
        this.writer.writeRecord(2 * BZip2TextFileWriter.BLOCK_SIZE, DELIMITER);
        this.writer.close();
        List<Long> nextBlocks = this.getNextBlockMarkerOffsets();
        Assert.assertEquals((long)1L, (long)nextBlocks.size());
    }

    @Test
    public void justExceedingBeyondTwoBlocks() throws Exception {
        this.writer.writeRecord(2 * BZip2TextFileWriter.BLOCK_SIZE + 1, DELIMITER);
        this.writer.close();
        List<Long> nextBlocks = this.getNextBlockMarkerOffsets();
        Assert.assertEquals((long)2L, (long)nextBlocks.size());
    }

    private List<Long> getNextBlockMarkerOffsets() throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(this.rawOut.toByteArray());
        return BZip2Utils.getNextBlockMarkerOffsets(in);
    }
}

