/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule;

import java.util.List;
import org.apache.hadoop.yarn.server.resourcemanager.placement.csmappingrule.MappingRuleConditionalVariable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerQueueManager;

public class MappingRuleConditionalVariables {
    private MappingRuleConditionalVariables() {
    }

    public static class SecondaryGroupVariable
    implements MappingRuleConditionalVariable {
        public static final String VARIABLE_NAME = "%secondary_group";
        private CapacitySchedulerQueueManager queueManager;
        private List<String> potentialGroups;

        public SecondaryGroupVariable(CapacitySchedulerQueueManager qm, List<String> groups) {
            this.queueManager = qm;
            this.potentialGroups = groups;
        }

        @Override
        public String evaluateInPath(String[] parts, int currentIndex) {
            StringBuilder parentBuilder = new StringBuilder();
            for (int i = 0; i < currentIndex; ++i) {
                parentBuilder.append(parts[i]);
                parentBuilder.append(".");
            }
            String lookupPrefix = parentBuilder.toString();
            for (String group : this.potentialGroups) {
                String path = lookupPrefix + group;
                if (this.queueManager.getQueue(path) == null) continue;
                return group;
            }
            return "";
        }

        public String toString() {
            return "SecondaryGroupVariable{variableName='%secondary_group',groups=" + this.potentialGroups + "}";
        }
    }
}

