/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.amrmproxy;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.shaded.org.eclipse.jetty.util.ConcurrentHashSet;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.yarn.api.ApplicationClientProtocol;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetContainersResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RegisterApplicationMasterRequestPBImpl;
import org.apache.hadoop.yarn.api.protocolrecords.impl.pb.RegisterApplicationMasterResponsePBImpl;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.PreemptionContract;
import org.apache.hadoop.yarn.api.records.PreemptionMessage;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.StrictPreemptionContract;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.client.AMRMClientUtils;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.InvalidApplicationMasterRequestException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factories.RecordFactory;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.proto.YarnServiceProtos;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.server.AMHeartbeatRequestHandler;
import org.apache.hadoop.yarn.server.AMRMClientRelayer;
import org.apache.hadoop.yarn.server.federation.failover.FederationProxyProviderUtil;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.retry.FederationActionRetry;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationRegistryClient;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AMRMProxyApplicationContext;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.AbstractRequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.RequestInterceptor;
import org.apache.hadoop.yarn.server.nodemanager.amrmproxy.TokenAndRegisterResponse;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.uam.UnmanagedAMPoolManager;
import org.apache.hadoop.yarn.util.AsyncCallback;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationInterceptor
extends AbstractRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(FederationInterceptor.class);
    public static final String NMSS_CLASS_PREFIX = "FederationInterceptor/";
    public static final String NMSS_REG_REQUEST_KEY = "FederationInterceptor/registerRequest";
    public static final String NMSS_REG_RESPONSE_KEY = "FederationInterceptor/registerResponse";
    public static final String NMSS_SECONDARY_SC_PREFIX = "FederationInterceptor/secondarySC/";
    public static final String STRING_TO_BYTE_FORMAT = "UTF-8";
    private static final RecordFactory RECORD_FACTORY = RecordFactoryProvider.getRecordFactory(null);
    private AllocateResponse lastAllocateResponse;
    private final Object lastAllocateResponseLock = new Object();
    private ApplicationAttemptId attemptId;
    private AMRMClientRelayer homeRMRelayer;
    private SubClusterId homeSubClusterId;
    private AMHeartbeatRequestHandler homeHeartbeatHandler;
    private final UnmanagedAMPoolManager uamPool;
    private final Map<String, AMRMClientRelayer> secondaryRelayers;
    private final Map<SubClusterId, List<AllocateResponse>> asyncResponseSink;
    private final Map<SubClusterId, AllocateResponse> lastSCResponse;
    private final Map<SubClusterId, RegisterApplicationMasterResponse> uamRegistrations;
    private final Map<SubClusterId, Future<?>> uamRegisterFutures;
    private ExecutorService threadpool;
    private volatile boolean justRecovered = false;
    private volatile boolean finishAMCalled = false;
    private final Map<ContainerId, SubClusterId> containerIdToSubClusterIdMap;
    private RegisterApplicationMasterRequest amRegistrationRequest = null;
    private RegisterApplicationMasterResponse amRegistrationResponse = null;
    private FederationStateStoreFacade federationFacade;
    private SubClusterResolver subClusterResolver;
    private Map<SubClusterId, Long> lastSCResponseTime;
    private long subClusterTimeOut;
    private long lastAMHeartbeatTime;
    private FederationAMRMProxyPolicy policyInterpreter;
    private FederationRegistryClient registryClient;
    private long heartbeatMaxWaitTimeMs;
    private int registerUamRetryNum;
    private long registerUamRetryInterval;
    private boolean waitUamRegisterDone;
    private final MonotonicClock clock = new MonotonicClock();
    private Set<NMToken> nmTokenMapFromRegisterSecondaryCluster;

    public FederationInterceptor() {
        this.containerIdToSubClusterIdMap = new ConcurrentHashMap<ContainerId, SubClusterId>();
        this.asyncResponseSink = new ConcurrentHashMap<SubClusterId, List<AllocateResponse>>();
        this.lastSCResponse = new ConcurrentHashMap<SubClusterId, AllocateResponse>();
        this.uamRegistrations = new ConcurrentHashMap<SubClusterId, RegisterApplicationMasterResponse>();
        this.uamRegisterFutures = new ConcurrentHashMap();
        this.threadpool = Executors.newCachedThreadPool();
        this.uamPool = this.createUnmanagedAMPoolManager(this.threadpool);
        this.secondaryRelayers = new ConcurrentHashMap<String, AMRMClientRelayer>();
        this.lastSCResponseTime = new ConcurrentHashMap<SubClusterId, Long>();
        this.lastAMHeartbeatTime = this.clock.getTime();
        this.nmTokenMapFromRegisterSecondaryCluster = new ConcurrentHashSet();
    }

    @Override
    public void init(AMRMProxyApplicationContext appContext) {
        UserGroupInformation appOwner;
        super.init(appContext);
        LOG.info("Initializing Federation Interceptor");
        Configuration conf = appContext.getConf();
        if (conf == null) {
            conf = this.getConf();
        } else {
            this.setConf(conf);
        }
        try {
            appOwner = UserGroupInformation.createProxyUser((String)appContext.getUser(), (UserGroupInformation)UserGroupInformation.getCurrentUser());
        }
        catch (Exception ex) {
            throw new YarnRuntimeException((Throwable)ex);
        }
        if (appContext.getRegistryClient() != null) {
            this.registryClient = new FederationRegistryClient(conf, appContext.getRegistryClient(), appOwner);
            if (appContext.getCredentials() != null) {
                appOwner.addCredentials(appContext.getCredentials());
            }
        }
        this.attemptId = appContext.getApplicationAttemptId();
        ApplicationId appId = this.attemptId.getApplicationId();
        this.homeSubClusterId = SubClusterId.newInstance(YarnConfiguration.getClusterId((Configuration)conf));
        this.homeRMRelayer = new AMRMClientRelayer(this.createHomeRMProxy(appContext, ApplicationMasterProtocol.class, appOwner), appId, this.homeSubClusterId.toString(), conf);
        this.homeHeartbeatHandler = this.createHomeHeartbeatHandler(conf, appId, this.homeRMRelayer);
        this.homeHeartbeatHandler.setUGI(appOwner);
        this.homeHeartbeatHandler.setDaemon(true);
        this.homeHeartbeatHandler.start();
        this.lastAllocateResponse = (AllocateResponse)RECORD_FACTORY.newRecordInstance(AllocateResponse.class);
        this.lastAllocateResponse.setResponseId(-1);
        this.federationFacade = FederationStateStoreFacade.getInstance(conf);
        this.subClusterResolver = this.federationFacade.getSubClusterResolver();
        this.policyInterpreter = null;
        this.uamPool.init(conf);
        this.uamPool.start();
        this.heartbeatMaxWaitTimeMs = conf.getLong("yarn.federation.amrmproxy.hb.maximum.wait.ms", 5000L);
        this.subClusterTimeOut = conf.getLong("yarn.federation.amrmproxy.subcluster.timeout.ms", 60000L);
        if (this.subClusterTimeOut <= 0L) {
            LOG.info("{} configured to be {}, should be positive. Using default of {}.", new Object[]{"yarn.federation.amrmproxy.subcluster.timeout.ms", this.subClusterTimeOut, 60000L});
            this.subClusterTimeOut = 60000L;
        }
        this.registerUamRetryNum = conf.getInt("yarn.federation.amrmproxy.register.uam.retry-count", 3);
        if (this.registerUamRetryNum <= 0) {
            LOG.info("{} configured to be {}, should be positive. Using default of {}.", new Object[]{"yarn.federation.amrmproxy.register.uam.retry-count", this.subClusterTimeOut, 3});
            this.registerUamRetryNum = 3;
        }
        this.registerUamRetryInterval = conf.getTimeDuration("yarn.federation.amrmproxy.register.uam.interval", YarnConfiguration.DEFAULT_FEDERATION_AMRMPROXY_REGISTER_UAM_RETRY_INTERVAL, TimeUnit.MILLISECONDS);
        this.waitUamRegisterDone = conf.getBoolean("yarn.nodemanager.amrmproxy.wait.uam-register.done", false);
    }

    @Override
    public void recover(Map<String, byte[]> recoveredDataMap) {
        super.recover(recoveredDataMap);
        LOG.info("Recovering data for FederationInterceptor for {}.", (Object)this.attemptId);
        this.justRecovered = true;
        if (recoveredDataMap == null || recoveredDataMap.isEmpty()) {
            LOG.warn("recoveredDataMap isNull Or isEmpty, FederationInterceptor can't recover.");
            return;
        }
        if (!recoveredDataMap.containsKey(NMSS_REG_REQUEST_KEY)) {
            return;
        }
        try {
            YarnServiceProtos.RegisterApplicationMasterRequestProto pb;
            if (recoveredDataMap.containsKey(NMSS_REG_REQUEST_KEY)) {
                byte[] appMasterRequestBytes = recoveredDataMap.get(NMSS_REG_REQUEST_KEY);
                pb = YarnServiceProtos.RegisterApplicationMasterRequestProto.parseFrom((byte[])appMasterRequestBytes);
                this.amRegistrationRequest = new RegisterApplicationMasterRequestPBImpl(pb);
                LOG.info("amRegistrationRequest recovered for {}.", (Object)this.attemptId);
                this.homeRMRelayer.setAMRegistrationRequest(this.amRegistrationRequest);
            }
            if (recoveredDataMap.containsKey(NMSS_REG_RESPONSE_KEY)) {
                byte[] appMasterResponseBytes = recoveredDataMap.get(NMSS_REG_RESPONSE_KEY);
                pb = YarnServiceProtos.RegisterApplicationMasterResponseProto.parseFrom((byte[])appMasterResponseBytes);
                this.amRegistrationResponse = new RegisterApplicationMasterResponsePBImpl((YarnServiceProtos.RegisterApplicationMasterResponseProto)pb);
                LOG.info("amRegistrationResponse recovered for {}.", (Object)this.attemptId);
            }
            Map<String, Token<AMRMTokenIdentifier>> uamMap = this.recoverSubClusterAMRMTokenIdentifierMap(recoveredDataMap);
            int containers = 0;
            AMRMProxyApplicationContext applicationContext = this.getApplicationContext();
            ApplicationId applicationId = this.attemptId.getApplicationId();
            String queue = this.amRegistrationResponse.getQueue();
            String homeSCId = this.homeSubClusterId.getId();
            String user = applicationContext.getUser();
            for (Map.Entry<String, Token<AMRMTokenIdentifier>> entry : uamMap.entrySet()) {
                String keyScId = entry.getKey();
                Token<AMRMTokenIdentifier> tokens = entry.getValue();
                SubClusterId subClusterId = SubClusterId.newInstance(keyScId);
                YarnConfiguration config = new YarnConfiguration(this.getConf());
                FederationProxyProviderUtil.updateConfForFederation((Configuration)config, keyScId);
                try {
                    ApplicationSubmissionContext originalSubmissionContext = this.federationFacade.getApplicationSubmissionContext(applicationId);
                    this.uamPool.reAttachUAM(keyScId, (Configuration)config, applicationId, queue, user, homeSCId, tokens, keyScId, originalSubmissionContext);
                    this.secondaryRelayers.put(keyScId, this.uamPool.getAMRMClientRelayer(keyScId));
                    RegisterApplicationMasterResponse response = this.uamPool.registerApplicationMaster(keyScId, this.amRegistrationRequest);
                    this.nmTokenMapFromRegisterSecondaryCluster.addAll(response.getNMTokensFromPreviousAttempts());
                    this.lastSCResponseTime.put(subClusterId, this.clock.getTime() - this.subClusterTimeOut);
                    List previousAttempts = response.getContainersFromPreviousAttempts();
                    for (Container container : previousAttempts) {
                        ContainerId containerId = container.getId();
                        this.containerIdToSubClusterIdMap.put(containerId, subClusterId);
                        ++containers;
                        LOG.info("From subCluster {} running container {}", (Object)subClusterId, (Object)containerId);
                    }
                    LOG.info("Recovered {} running containers from UAM in {}.", (Object)previousAttempts.size(), (Object)subClusterId);
                }
                catch (Exception e) {
                    LOG.error("Error reattaching UAM to {} for {}.", new Object[]{subClusterId, this.attemptId, e});
                    this.uamPool.unAttachUAM(keyScId);
                    this.secondaryRelayers.remove(keyScId);
                    this.lastSCResponseTime.remove(subClusterId);
                    List containerIds = this.containerIdToSubClusterIdMap.entrySet().stream().filter(item -> ((SubClusterId)item.getValue()).equals(subClusterId)).map(Map.Entry::getKey).collect(Collectors.toList());
                    for (ContainerId containerId : containerIds) {
                        this.containerIdToSubClusterIdMap.remove(containerId);
                    }
                }
            }
            UserGroupInformation appSubmitter = UserGroupInformation.isSecurityEnabled() ? UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getLoginUser()) : UserGroupInformation.createRemoteUser((String)user);
            ApplicationClientProtocol rmClient = this.createHomeRMProxy(applicationContext, ApplicationClientProtocol.class, appSubmitter);
            GetContainersRequest request = GetContainersRequest.newInstance((ApplicationAttemptId)this.attemptId);
            GetContainersResponse response = rmClient.getContainers(request);
            for (ContainerReport container : response.getContainerList()) {
                ContainerId containerId = container.getContainerId();
                this.containerIdToSubClusterIdMap.put(containerId, this.homeSubClusterId);
                ++containers;
                LOG.debug("From home RM {} running container {}.", (Object)this.homeSubClusterId, (Object)containerId);
            }
            LOG.info("{} running containers including AM recovered from home RM {}.", (Object)response.getContainerList().size(), (Object)this.homeSubClusterId);
            LOG.info("In all {} UAMs {} running containers including AM recovered for {}.", new Object[]{uamMap.size(), containers, this.attemptId});
            if (queue != null) {
                queue = this.amRegistrationResponse.getQueue();
                this.policyInterpreter = FederationPolicyUtils.loadAMRMPolicy(queue, this.policyInterpreter, this.getConf(), this.federationFacade, this.homeSubClusterId);
            }
        }
        catch (IOException | YarnException e) {
            throw new YarnRuntimeException(e);
        }
    }

    private Map<String, Token<AMRMTokenIdentifier>> recoverSubClusterAMRMTokenIdentifierMap(Map<String, byte[]> recoveredDataMap) throws IOException {
        Map<String, Token<AMRMTokenIdentifier>> uamMap;
        ApplicationId applicationId = this.attemptId.getApplicationId();
        if (this.registryClient != null) {
            uamMap = this.registryClient.loadStateFromRegistry(applicationId);
            LOG.info("Found {} existing UAMs for application {} in Yarn Registry.", (Object)uamMap.size(), (Object)applicationId);
        } else {
            uamMap = this.recoverSubClusterAMRMTokenIdentifierMapFromNMSS(recoveredDataMap);
            LOG.info("Found {} existing UAMs for application {} in NMStateStore.", (Object)uamMap.size(), (Object)applicationId);
        }
        return uamMap;
    }

    private Map<String, Token<AMRMTokenIdentifier>> recoverSubClusterAMRMTokenIdentifierMapFromNMSS(Map<String, byte[]> recoveredDataMap) throws IOException {
        HashMap<String, Token<AMRMTokenIdentifier>> uamMap = new HashMap<String, Token<AMRMTokenIdentifier>>();
        for (Map.Entry<String, byte[]> entry : recoveredDataMap.entrySet()) {
            String key = entry.getKey();
            byte[] value = entry.getValue();
            if (!key.startsWith(NMSS_SECONDARY_SC_PREFIX)) continue;
            String scId = key.substring(NMSS_SECONDARY_SC_PREFIX.length());
            Token aMRMTokenIdentifier = new Token();
            aMRMTokenIdentifier.decodeFromUrlString(new String(value, STRING_TO_BYTE_FORMAT));
            uamMap.put(scId, (Token<AMRMTokenIdentifier>)aMRMTokenIdentifier);
            LOG.debug("Recovered UAM in {} from NMSS.", (Object)scId);
        }
        return uamMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized RegisterApplicationMasterResponse registerApplicationMaster(RegisterApplicationMasterRequest request) throws YarnException, IOException {
        if (request == null) {
            throw new YarnException("RegisterApplicationMasterRequest can't be null!");
        }
        Object object = this.lastAllocateResponseLock;
        synchronized (object) {
            this.lastAllocateResponse.setResponseId(0);
        }
        this.justRecovered = false;
        if (this.amRegistrationRequest != null) {
            if (!this.amRegistrationRequest.equals(request)) {
                throw new YarnException("AM should not call registerApplicationMaster with a different request body");
            }
        } else {
            this.amRegistrationRequest = request;
            RegisterApplicationMasterRequestPBImpl requestPB = (RegisterApplicationMasterRequestPBImpl)this.amRegistrationRequest;
            this.storeAMRMProxyAppContextEntry(NMSS_REG_REQUEST_KEY, requestPB.getProto().toByteArray());
        }
        if (this.amRegistrationResponse != null) {
            return this.amRegistrationResponse;
        }
        this.amRegistrationResponse = this.homeRMRelayer.registerApplicationMaster(request);
        if (this.amRegistrationResponse == null) {
            throw new YarnException("RegisterApplicationMasterResponse can't be null!");
        }
        List containersFromPreviousAttempts = this.amRegistrationResponse.getContainersFromPreviousAttempts();
        if (containersFromPreviousAttempts != null) {
            this.cacheAllocatedContainers(containersFromPreviousAttempts, this.homeSubClusterId);
        }
        ApplicationId appId = this.attemptId.getApplicationId();
        this.reAttachUAMAndMergeRegisterResponse(this.amRegistrationResponse, appId);
        RegisterApplicationMasterResponsePBImpl responsePB = (RegisterApplicationMasterResponsePBImpl)this.amRegistrationResponse;
        this.storeAMRMProxyAppContextEntry(NMSS_REG_RESPONSE_KEY, responsePB.getProto().toByteArray());
        String queue = this.amRegistrationResponse.getQueue();
        if (queue == null) {
            LOG.warn("Received null queue for application {} from home subcluster.  Will use default queue name {} for getting AMRMProxyPolicy.", (Object)appId, (Object)"default");
        } else {
            LOG.info("Application {} belongs to queue {}.", (Object)appId, (Object)queue);
        }
        try {
            this.policyInterpreter = FederationPolicyUtils.loadAMRMPolicy(queue, this.policyInterpreter, this.getConf(), this.federationFacade, this.homeSubClusterId);
        }
        catch (FederationPolicyInitializationException e) {
            throw new YarnRuntimeException((Throwable)((Object)e));
        }
        return this.amRegistrationResponse;
    }

    private void storeAMRMProxyAppContextEntry(String key, byte[] data) {
        NMStateStoreService nmStateStore = this.getNMStateStore();
        if (nmStateStore != null) {
            try {
                nmStateStore.storeAMRMProxyAppContextEntry(this.attemptId, key, data);
            }
            catch (Exception e) {
                LOG.error("Error storing AMRMProxy application context entry[{}] for {}.", new Object[]{key, this.attemptId, e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllocateResponse allocate(AllocateRequest request) throws YarnException, IOException {
        Preconditions.checkArgument((this.policyInterpreter != null ? 1 : 0) != 0, (Object)"Allocate should be called after registerApplicationMaster");
        this.lastAMHeartbeatTime = this.clock.getTime();
        if (this.justRecovered) {
            throw new ApplicationMasterNotRegisteredException("AMRMProxy just restarted and recovered for " + this.attemptId + ". AM should re-register and full re-send pending requests.");
        }
        if (this.finishAMCalled) {
            LOG.warn("FinishApplicationMaster already called by {}, skip heartbeat processing and return dummy response.", (Object)this.attemptId);
            return (AllocateResponse)RECORD_FACTORY.newRecordInstance(AllocateResponse.class);
        }
        Object object = this.lastAllocateResponseLock;
        synchronized (object) {
            LOG.info("Heartbeat from " + this.attemptId + " with responseId " + request.getResponseId() + " when we are expecting " + this.lastAllocateResponse.getResponseId());
            if (AMRMClientUtils.getNextResponseId((int)request.getResponseId()) == this.lastAllocateResponse.getResponseId()) {
                return this.lastAllocateResponse;
            }
            if (request.getResponseId() != this.lastAllocateResponse.getResponseId()) {
                throw new InvalidApplicationMasterRequestException(AMRMClientUtils.assembleInvalidResponseIdExceptionMessage((ApplicationAttemptId)this.attemptId, (int)this.lastAllocateResponse.getResponseId(), (int)request.getResponseId()));
            }
        }
        try {
            Map<SubClusterId, AllocateRequest> requests = this.splitAllocateRequest(request);
            this.sendRequestsToResourceManagers(requests);
            long startTime = this.clock.getTime();
            Map<SubClusterId, List<AllocateResponse>> map = this.asyncResponseSink;
            synchronized (map) {
                try {
                    this.asyncResponseSink.wait(this.heartbeatMaxWaitTimeMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            long firstResponseTime = this.clock.getTime() - startTime;
            try {
                Thread.sleep(firstResponseTime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            AllocateResponse response = this.generateBaseAllocationResponse();
            this.mergeAllocateResponses(response);
            if (!FederationInterceptor.isNullOrEmpty(this.uamRegistrations)) {
                HashMap<SubClusterId, RegisterApplicationMasterResponse> newRegistrations;
                Map<SubClusterId, RegisterApplicationMasterResponse> map2 = this.uamRegistrations;
                synchronized (map2) {
                    newRegistrations = new HashMap<SubClusterId, RegisterApplicationMasterResponse>(this.uamRegistrations);
                    this.uamRegistrations.clear();
                }
                this.mergeRegistrationResponses(response, newRegistrations);
            }
            Object object2 = this.lastAllocateResponseLock;
            synchronized (object2) {
                response.setResponseId(AMRMClientUtils.getNextResponseId((int)this.lastAllocateResponse.getResponseId()));
                this.lastAllocateResponse = response;
            }
            return response;
        }
        catch (Throwable ex) {
            LOG.error("Exception encountered while processing heart beat for " + this.attemptId, ex);
            throw new YarnException(ex);
        }
    }

    public FinishApplicationMasterResponse finishApplicationMaster(FinishApplicationMasterRequest request) throws YarnException, IOException {
        this.finishAMCalled = true;
        boolean failedToUnRegister = false;
        Map<String, FinishApplicationMasterResponse> responseMap = this.uamPool.batchFinishApplicationMaster(request, this.attemptId.toString());
        for (Map.Entry<String, FinishApplicationMasterResponse> entry : responseMap.entrySet()) {
            String subClusterId = entry.getKey();
            FinishApplicationMasterResponse response = entry.getValue();
            if (response != null && response.getIsUnregistered()) {
                this.secondaryRelayers.remove(subClusterId);
                if (this.getNMStateStore() == null) continue;
                this.getNMStateStore().removeAMRMProxyAppContextEntry(this.attemptId, NMSS_SECONDARY_SC_PREFIX + subClusterId);
                continue;
            }
            failedToUnRegister = true;
        }
        FinishApplicationMasterResponse homeResponse = this.homeRMRelayer.finishApplicationMaster(request);
        this.homeHeartbeatHandler.shutdown();
        if (failedToUnRegister) {
            homeResponse.setIsUnregistered(false);
        } else if (this.checkRequestFinalApplicationStatusSuccess(request)) {
            this.uamPool.stop();
            this.removeAppFromRegistry();
        }
        return homeResponse;
    }

    private boolean checkRequestFinalApplicationStatusSuccess(FinishApplicationMasterRequest request) {
        if (request != null && request.getFinalApplicationStatus() != null) {
            return request.getFinalApplicationStatus().equals((Object)FinalApplicationStatus.SUCCEEDED);
        }
        return false;
    }

    @Override
    public void setNextInterceptor(RequestInterceptor next) {
        throw new YarnRuntimeException("setNextInterceptor is being called on FederationInterceptor. It should always be used as the last interceptor in the chain");
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down FederationInterceptor for {}", (Object)this.attemptId);
        try {
            this.uamPool.shutDownConnections();
        }
        catch (YarnException e) {
            LOG.error("Error shutting down all UAM clients without killing them", (Throwable)e);
        }
        if (this.threadpool != null) {
            try {
                this.threadpool.shutdown();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.threadpool = null;
        }
        this.homeHeartbeatHandler.shutdown();
        this.homeRMRelayer.shutdown();
        this.removeAppFromRegistry();
        super.shutdown();
    }

    private void removeAppFromRegistry() {
        ApplicationId applicationId;
        if (this.registryClient != null && this.attemptId != null && (applicationId = this.attemptId.getApplicationId()) != null) {
            this.registryClient.removeAppFromRegistry(applicationId);
        }
    }

    @VisibleForTesting
    protected void cleanupRegistry() {
        if (this.registryClient != null) {
            this.registryClient.cleanAllApplications();
        }
    }

    @VisibleForTesting
    protected FederationRegistryClient getRegistryClient() {
        return this.registryClient;
    }

    @VisibleForTesting
    protected ApplicationAttemptId getAttemptId() {
        return this.attemptId;
    }

    @VisibleForTesting
    protected AMHeartbeatRequestHandler getHomeHeartbeatHandler() {
        return this.homeHeartbeatHandler;
    }

    @VisibleForTesting
    protected UnmanagedAMPoolManager createUnmanagedAMPoolManager(ExecutorService threadPool) {
        return new UnmanagedAMPoolManager(threadPool);
    }

    @VisibleForTesting
    protected AMHeartbeatRequestHandler createHomeHeartbeatHandler(Configuration conf, ApplicationId appId, AMRMClientRelayer rmProxyRelayer) {
        return new AMHeartbeatRequestHandler(conf, appId, rmProxyRelayer);
    }

    protected <T> T createHomeRMProxy(AMRMProxyApplicationContext appContext, Class<T> protocol, UserGroupInformation user) {
        try {
            return FederationProxyProviderUtil.createRMProxy(appContext.getConf(), protocol, this.homeSubClusterId, user, appContext.getAMRMToken());
        }
        catch (Exception ex) {
            throw new YarnRuntimeException((Throwable)ex);
        }
    }

    private void mergeRegisterResponse(RegisterApplicationMasterResponse homeResponse, RegisterApplicationMasterResponse otherResponse) {
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getContainersFromPreviousAttempts())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getContainersFromPreviousAttempts())) {
                homeResponse.getContainersFromPreviousAttempts().addAll(otherResponse.getContainersFromPreviousAttempts());
            } else {
                homeResponse.setContainersFromPreviousAttempts(otherResponse.getContainersFromPreviousAttempts());
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getNMTokensFromPreviousAttempts())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getNMTokensFromPreviousAttempts())) {
                homeResponse.getNMTokensFromPreviousAttempts().addAll(otherResponse.getNMTokensFromPreviousAttempts());
            } else {
                homeResponse.setNMTokensFromPreviousAttempts(otherResponse.getNMTokensFromPreviousAttempts());
            }
        }
    }

    protected void reAttachUAMAndMergeRegisterResponse(RegisterApplicationMasterResponse homeResponse, ApplicationId appId) {
        if (this.registryClient == null) {
            LOG.warn("registryClient is null, skip attaching existing UAM if any");
            return;
        }
        Map<String, Token<AMRMTokenIdentifier>> uamMap = this.registryClient.loadStateFromRegistry(appId);
        if (uamMap.size() == 0) {
            LOG.info("No existing UAM for application {} found in Yarn Registry", (Object)appId);
            return;
        }
        LOG.info("Found {} existing UAMs for application {} in Yarn Registry. Reattaching in parallel", (Object)uamMap.size(), (Object)appId);
        ExecutorCompletionService<RegisterApplicationMasterResponse> completionService = new ExecutorCompletionService<RegisterApplicationMasterResponse>(this.threadpool);
        for (Map.Entry<String, Token<AMRMTokenIdentifier>> entry : uamMap.entrySet()) {
            SubClusterId subClusterId = SubClusterId.newInstance(entry.getKey());
            Token<AMRMTokenIdentifier> amrmToken = entry.getValue();
            completionService.submit(() -> {
                RegisterApplicationMasterResponse response = null;
                try {
                    YarnConfiguration config = new YarnConfiguration(this.getConf());
                    FederationProxyProviderUtil.updateConfForFederation((Configuration)config, subClusterId.getId());
                    ApplicationSubmissionContext originalSubmissionContext = this.federationFacade.getApplicationSubmissionContext(appId);
                    this.uamPool.reAttachUAM(subClusterId.getId(), (Configuration)config, appId, this.amRegistrationResponse.getQueue(), this.getApplicationContext().getUser(), this.homeSubClusterId.getId(), amrmToken, subClusterId.toString(), originalSubmissionContext);
                    this.secondaryRelayers.put(subClusterId.getId(), this.uamPool.getAMRMClientRelayer(subClusterId.getId()));
                    response = this.uamPool.registerApplicationMaster(subClusterId.getId(), this.amRegistrationRequest);
                    this.lastSCResponseTime.put(subClusterId, this.clock.getTime() - this.subClusterTimeOut);
                    if (response != null && response.getContainersFromPreviousAttempts() != null) {
                        this.cacheAllocatedContainers(response.getContainersFromPreviousAttempts(), subClusterId);
                    }
                    LOG.info("UAM {} reattached for {}", (Object)subClusterId, (Object)appId);
                }
                catch (Throwable e) {
                    LOG.error("Reattaching UAM {} failed for {}.", new Object[]{subClusterId, appId, e});
                }
                return response;
            });
        }
        for (int i = 0; i < uamMap.size(); ++i) {
            try {
                Future future = completionService.take();
                RegisterApplicationMasterResponse registerResponse = (RegisterApplicationMasterResponse)future.get();
                if (registerResponse == null) continue;
                LOG.info("Merging register response for {}", (Object)appId);
                this.mergeRegisterResponse(homeResponse, registerResponse);
                this.nmTokenMapFromRegisterSecondaryCluster.addAll(registerResponse.getNMTokensFromPreviousAttempts());
                continue;
            }
            catch (Exception e) {
                LOG.warn("Reattaching UAM failed for ApplicationId: " + appId, (Throwable)e);
            }
        }
    }

    private SubClusterId getSubClusterForNode(String nodeName) {
        SubClusterId subClusterId;
        try {
            subClusterId = this.subClusterResolver.getSubClusterForNode(nodeName);
        }
        catch (YarnException e) {
            LOG.error("Failed to resolve sub-cluster for node " + nodeName + ", skipping this node", (Throwable)e);
            return null;
        }
        if (subClusterId == null) {
            LOG.error("Failed to resolve sub-cluster for node {}, skipping this node", (Object)nodeName);
            return null;
        }
        return subClusterId;
    }

    private Map<SubClusterId, AllocateRequest> splitAllocateRequest(AllocateRequest request) throws YarnException {
        AllocateRequest newRequest;
        HashMap<SubClusterId, AllocateRequest> requestMap = new HashMap<SubClusterId, AllocateRequest>();
        FederationInterceptor.findOrCreateAllocateRequestForSubCluster(this.homeSubClusterId, request, requestMap);
        Set<String> subClusterIds = this.uamPool.getAllUAMIds();
        for (String string : subClusterIds) {
            FederationInterceptor.findOrCreateAllocateRequestForSubCluster(SubClusterId.newInstance(string), request, requestMap);
        }
        if (!FederationInterceptor.isNullOrEmpty(request.getAskList())) {
            Map<SubClusterId, List<ResourceRequest>> asks = this.splitResourceRequests(request.getAskList());
            for (Map.Entry<SubClusterId, List<ResourceRequest>> entry : asks.entrySet()) {
                newRequest = FederationInterceptor.findOrCreateAllocateRequestForSubCluster(entry.getKey(), request, requestMap);
                newRequest.getAskList().addAll((Collection)entry.getValue());
            }
        }
        if (request.getResourceBlacklistRequest() != null) {
            if (!FederationInterceptor.isNullOrEmpty(request.getResourceBlacklistRequest().getBlacklistAdditions())) {
                for (String string : request.getResourceBlacklistRequest().getBlacklistAdditions()) {
                    SubClusterId subClusterId = this.getSubClusterForNode(string);
                    if (subClusterId == null) continue;
                    newRequest = FederationInterceptor.findOrCreateAllocateRequestForSubCluster(subClusterId, request, requestMap);
                    newRequest.getResourceBlacklistRequest().getBlacklistAdditions().add(string);
                }
            }
            if (!FederationInterceptor.isNullOrEmpty(request.getResourceBlacklistRequest().getBlacklistRemovals())) {
                for (String string : request.getResourceBlacklistRequest().getBlacklistRemovals()) {
                    SubClusterId subClusterId = this.getSubClusterForNode(string);
                    if (subClusterId == null) continue;
                    newRequest = FederationInterceptor.findOrCreateAllocateRequestForSubCluster(subClusterId, request, requestMap);
                    newRequest.getResourceBlacklistRequest().getBlacklistRemovals().add(string);
                }
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(request.getReleaseList())) {
            for (ContainerId containerId : request.getReleaseList()) {
                if (!this.warnIfNotExists(containerId, "release")) continue;
                SubClusterId subClusterId = this.containerIdToSubClusterIdMap.get(containerId);
                newRequest = (AllocateRequest)requestMap.get(subClusterId);
                newRequest.getReleaseList().add(containerId);
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(request.getUpdateRequests())) {
            for (UpdateContainerRequest updateContainerRequest : request.getUpdateRequests()) {
                if (!this.warnIfNotExists(updateContainerRequest.getContainerId(), "update")) continue;
                SubClusterId subClusterId = this.containerIdToSubClusterIdMap.get(updateContainerRequest.getContainerId());
                newRequest = (AllocateRequest)requestMap.get(subClusterId);
                newRequest.getUpdateRequests().add(updateContainerRequest);
            }
        }
        return requestMap;
    }

    private void sendRequestsToResourceManagers(Map<SubClusterId, AllocateRequest> requests) throws YarnException, IOException {
        List<SubClusterId> newSubClusters = this.registerAndAllocateWithNewSubClusters(requests);
        for (Map.Entry<SubClusterId, AllocateRequest> entry : requests.entrySet()) {
            SubClusterId subClusterId = entry.getKey();
            if (newSubClusters.contains(subClusterId)) continue;
            if (subClusterId.equals(this.homeSubClusterId)) {
                this.homeHeartbeatHandler.allocateAsync(entry.getValue(), new HeartbeatCallBack(this.homeSubClusterId, false));
                continue;
            }
            if (!this.uamPool.hasUAMId(subClusterId.getId())) {
                throw new YarnException("UAM not found for " + this.attemptId + " in sub-cluster " + subClusterId);
            }
            this.uamPool.allocateAsync(subClusterId.getId(), entry.getValue(), new HeartbeatCallBack(subClusterId, true));
        }
    }

    private List<SubClusterId> registerAndAllocateWithNewSubClusters(Map<SubClusterId, AllocateRequest> requests) throws IOException {
        ArrayList<SubClusterId> newSubClusters = new ArrayList<SubClusterId>();
        requests.keySet().forEach(subClusterId -> {
            String id = subClusterId.getId();
            if (!subClusterId.equals(this.homeSubClusterId) && !this.uamPool.hasUAMId(id)) {
                newSubClusters.add((SubClusterId)subClusterId);
                this.lastSCResponseTime.put((SubClusterId)subClusterId, this.clock.getTime() - this.subClusterTimeOut);
            }
        });
        this.uamRegisterFutures.clear();
        for (SubClusterId subClusterId2 : newSubClusters) {
            Future<?> future = this.threadpool.submit(() -> {
                RegisterApplicationMasterResponse uamResponse;
                Token<AMRMTokenIdentifier> token;
                String subClusterId = scId.getId();
                YarnConfiguration config = new YarnConfiguration(this.getConf());
                FederationProxyProviderUtil.updateConfForFederation((Configuration)config, subClusterId);
                ApplicationId applicationId = this.attemptId.getApplicationId();
                try {
                    TokenAndRegisterResponse result = ((FederationActionRetry<TokenAndRegisterResponse>)retryCount -> this.launchUAMAndRegisterApplicationMaster(config, subClusterId, applicationId)).runWithRetries(this.registerUamRetryNum, this.registerUamRetryInterval);
                    token = result.getToken();
                    uamResponse = result.getResponse();
                }
                catch (Throwable e) {
                    LOG.error("Failed to register application master: {} Application: {}.", new Object[]{subClusterId, this.attemptId, e});
                    return;
                }
                this.uamRegistrations.put(scId, uamResponse);
                LOG.info("Successfully registered unmanaged application master: {} ApplicationId: {}.", (Object)subClusterId, (Object)this.attemptId);
                try {
                    this.uamPool.allocateAsync(subClusterId, (AllocateRequest)requests.get(scId), new HeartbeatCallBack(scId, true));
                }
                catch (Throwable e) {
                    LOG.error("Failed to allocate async to {} Application: {}.", new Object[]{subClusterId, this.attemptId, e});
                }
                try {
                    if (this.registryClient != null) {
                        this.registryClient.writeAMRMTokenForUAM(applicationId, subClusterId, token);
                    } else if (this.getNMStateStore() != null) {
                        this.getNMStateStore().storeAMRMProxyAppContextEntry(this.attemptId, NMSS_SECONDARY_SC_PREFIX + subClusterId, token.encodeToUrlString().getBytes(STRING_TO_BYTE_FORMAT));
                    }
                }
                catch (Throwable e) {
                    LOG.error("Failed to persist UAM token from {} Application {}", new Object[]{subClusterId, this.attemptId, e});
                }
            });
            this.uamRegisterFutures.put(subClusterId2, future);
        }
        if (this.waitUamRegisterDone) {
            for (Map.Entry entry : this.uamRegisterFutures.entrySet()) {
                SubClusterId subClusterId2 = (SubClusterId)entry.getKey();
                Future future = (Future)entry.getValue();
                while (!future.isDone()) {
                    LOG.info("subClusterId {} Wait Uam Register done.", (Object)subClusterId2);
                }
            }
        }
        return newSubClusters;
    }

    protected TokenAndRegisterResponse launchUAMAndRegisterApplicationMaster(YarnConfiguration config, String subClusterId, ApplicationId applicationId) throws IOException, YarnException {
        ApplicationSubmissionContext originalSubmissionContext = this.federationFacade.getApplicationSubmissionContext(applicationId);
        String submitter = this.getApplicationContext().getUser();
        String homeRM = this.homeSubClusterId.toString();
        String queue = this.amRegistrationResponse.getQueue();
        Token<AMRMTokenIdentifier> token = this.uamPool.launchUAM(subClusterId, (Configuration)config, applicationId, queue, submitter, homeRM, true, subClusterId, originalSubmissionContext);
        this.secondaryRelayers.put(subClusterId, this.uamPool.getAMRMClientRelayer(subClusterId));
        RegisterApplicationMasterResponse uamResponse = this.uamPool.registerApplicationMaster(subClusterId, this.amRegistrationRequest);
        return new TokenAndRegisterResponse(token, uamResponse);
    }

    protected AllocateResponse generateBaseAllocationResponse() {
        AllocateResponse baseResponse = (AllocateResponse)RECORD_FACTORY.newRecordInstance(AllocateResponse.class);
        baseResponse.setAvailableResources(Resource.newInstance((int)0, (int)0));
        baseResponse.setNumClusterNodes(0);
        Set<SubClusterId> expiredSC = this.getTimedOutSCs(false);
        for (Map.Entry<SubClusterId, AllocateResponse> entry : this.lastSCResponse.entrySet()) {
            if (expiredSC.contains(entry.getKey())) continue;
            AllocateResponse response = entry.getValue();
            if (response.getAvailableResources() != null) {
                baseResponse.setAvailableResources(Resources.add((Resource)baseResponse.getAvailableResources(), (Resource)response.getAvailableResources()));
            }
            baseResponse.setNumClusterNodes(baseResponse.getNumClusterNodes() + response.getNumClusterNodes());
        }
        return baseResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeAllocateResponses(AllocateResponse mergedResponse) {
        Map<SubClusterId, List<AllocateResponse>> map = this.asyncResponseSink;
        synchronized (map) {
            for (Map.Entry<SubClusterId, List<AllocateResponse>> entry : this.asyncResponseSink.entrySet()) {
                SubClusterId subClusterId = entry.getKey();
                List<AllocateResponse> responses = entry.getValue();
                if (responses.size() <= 0) continue;
                for (AllocateResponse response : responses) {
                    this.removeFinishedContainersFromCache(response.getCompletedContainersStatuses());
                    this.cacheAllocatedContainers(response.getAllocatedContainers(), subClusterId);
                    this.mergeAllocateResponse(mergedResponse, response, subClusterId);
                }
                responses.clear();
            }
        }
        if (this.nmTokenMapFromRegisterSecondaryCluster.size() > 0) {
            ArrayList<NMToken> duplicateNmToken = new ArrayList<NMToken>(this.nmTokenMapFromRegisterSecondaryCluster);
            this.nmTokenMapFromRegisterSecondaryCluster.removeAll(duplicateNmToken);
            if (!FederationInterceptor.isNullOrEmpty(mergedResponse.getNMTokens())) {
                mergedResponse.getNMTokens().addAll(duplicateNmToken);
            } else {
                mergedResponse.setNMTokens(duplicateNmToken);
            }
        }
    }

    private void removeFinishedContainersFromCache(List<ContainerStatus> finishedContainers) {
        for (ContainerStatus container : finishedContainers) {
            LOG.debug("Completed container {}", (Object)container);
            this.containerIdToSubClusterIdMap.remove(container.getContainerId());
        }
    }

    private void mergeRegistrationResponses(AllocateResponse homeResponse, Map<SubClusterId, RegisterApplicationMasterResponse> registrations) {
        for (Map.Entry<SubClusterId, RegisterApplicationMasterResponse> entry : registrations.entrySet()) {
            RegisterApplicationMasterResponse registration = entry.getValue();
            if (!FederationInterceptor.isNullOrEmpty(registration.getContainersFromPreviousAttempts())) {
                List tempContainers = homeResponse.getAllocatedContainers();
                if (!FederationInterceptor.isNullOrEmpty(tempContainers)) {
                    tempContainers.addAll(registration.getContainersFromPreviousAttempts());
                    homeResponse.setAllocatedContainers(tempContainers);
                } else {
                    homeResponse.setAllocatedContainers(registration.getContainersFromPreviousAttempts());
                }
                this.cacheAllocatedContainers(registration.getContainersFromPreviousAttempts(), entry.getKey());
            }
            if (FederationInterceptor.isNullOrEmpty(registration.getNMTokensFromPreviousAttempts())) continue;
            List tempTokens = homeResponse.getNMTokens();
            if (!FederationInterceptor.isNullOrEmpty(tempTokens)) {
                tempTokens.addAll(registration.getNMTokensFromPreviousAttempts());
                homeResponse.setNMTokens(tempTokens);
                continue;
            }
            homeResponse.setNMTokens(registration.getNMTokensFromPreviousAttempts());
        }
    }

    @VisibleForTesting
    protected void mergeAllocateResponse(AllocateResponse homeResponse, AllocateResponse otherResponse, SubClusterId otherRMAddress) {
        if (otherResponse.getAMRMToken() != null) {
            if (otherRMAddress.equals(this.homeSubClusterId)) {
                homeResponse.setAMRMToken(otherResponse.getAMRMToken());
            } else {
                LOG.warn("amrmToken from UAM {} not null, it should be null here", (Object)otherRMAddress);
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getAllocatedContainers())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getAllocatedContainers())) {
                homeResponse.getAllocatedContainers().addAll(otherResponse.getAllocatedContainers());
            } else {
                homeResponse.setAllocatedContainers(otherResponse.getAllocatedContainers());
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getCompletedContainersStatuses())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getCompletedContainersStatuses())) {
                homeResponse.getCompletedContainersStatuses().addAll(otherResponse.getCompletedContainersStatuses());
            } else {
                homeResponse.setCompletedContainersStatuses(otherResponse.getCompletedContainersStatuses());
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getUpdatedNodes())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getUpdatedNodes())) {
                homeResponse.getUpdatedNodes().addAll(otherResponse.getUpdatedNodes());
            } else {
                homeResponse.setUpdatedNodes(otherResponse.getUpdatedNodes());
            }
        }
        if (otherResponse.getApplicationPriority() != null) {
            homeResponse.setApplicationPriority(otherResponse.getApplicationPriority());
        }
        homeResponse.setNumClusterNodes(homeResponse.getNumClusterNodes() + otherResponse.getNumClusterNodes());
        PreemptionMessage homePreempMessage = homeResponse.getPreemptionMessage();
        PreemptionMessage otherPreempMessage = otherResponse.getPreemptionMessage();
        if (homePreempMessage == null && otherPreempMessage != null) {
            homeResponse.setPreemptionMessage(otherPreempMessage);
        }
        if (homePreempMessage != null && otherPreempMessage != null) {
            PreemptionContract par1 = homePreempMessage.getContract();
            PreemptionContract par2 = otherPreempMessage.getContract();
            if (par1 == null && par2 != null) {
                homePreempMessage.setContract(par2);
            }
            if (par1 != null && par2 != null) {
                par1.getResourceRequest().addAll(par2.getResourceRequest());
                par1.getContainers().addAll(par2.getContainers());
            }
            StrictPreemptionContract spar1 = homePreempMessage.getStrictContract();
            StrictPreemptionContract spar2 = otherPreempMessage.getStrictContract();
            if (spar1 == null && spar2 != null) {
                homePreempMessage.setStrictContract(spar2);
            }
            if (spar1 != null && spar2 != null) {
                spar1.getContainers().addAll(spar2.getContainers());
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getNMTokens())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getNMTokens())) {
                homeResponse.getNMTokens().addAll(otherResponse.getNMTokens());
            } else {
                homeResponse.setNMTokens(otherResponse.getNMTokens());
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getUpdatedContainers())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getUpdatedContainers())) {
                homeResponse.getUpdatedContainers().addAll(otherResponse.getUpdatedContainers());
            } else {
                homeResponse.setUpdatedContainers(otherResponse.getUpdatedContainers());
            }
        }
        if (!FederationInterceptor.isNullOrEmpty(otherResponse.getUpdateErrors())) {
            if (!FederationInterceptor.isNullOrEmpty(homeResponse.getUpdateErrors())) {
                homeResponse.getUpdateErrors().addAll(otherResponse.getUpdateErrors());
            } else {
                homeResponse.setUpdateErrors(otherResponse.getUpdateErrors());
            }
        }
    }

    private void cacheAllocatedContainers(List<Container> containers, SubClusterId subClusterId) {
        for (Container container : containers) {
            SubClusterId chooseSubClusterId;
            block8: {
                chooseSubClusterId = SubClusterId.newInstance(subClusterId.toString());
                LOG.debug("Adding container {}", (Object)container);
                if (this.containerIdToSubClusterIdMap.containsKey(container.getId())) {
                    SubClusterId existingSubClusterId = this.containerIdToSubClusterIdMap.get(container.getId());
                    if (existingSubClusterId.equals(subClusterId)) {
                        LOG.warn("Duplicate containerID: {} found in the allocated containers from same sub-cluster: {}, so ignoring.", (Object)container.getId(), (Object)subClusterId);
                    } else {
                        LOG.info("Duplicate containerID found in the allocated containers. try to re-pick the sub-cluster.");
                        try {
                            boolean existAllocatedScHealth = this.isSCHealth(existingSubClusterId);
                            boolean newAllocatedScHealth = this.isSCHealth(subClusterId);
                            if (existAllocatedScHealth) {
                                LOG.info("Use Previous Allocated Container's subCluster. ContainerId: {} ApplicationId: {} From RM: {}.", new Object[]{this.attemptId, container.getId(), existingSubClusterId});
                                chooseSubClusterId = existingSubClusterId;
                                break block8;
                            }
                            if (newAllocatedScHealth) {
                                LOG.info("Use Newly Allocated Container's subCluster. ApplicationId: {} ContainerId: {} From RM: {}.", new Object[]{this.attemptId, container.getId(), subClusterId});
                                chooseSubClusterId = subClusterId;
                                break block8;
                            }
                            throw new YarnRuntimeException(" Can't use any subCluster because an exception occurred ContainerId: " + container.getId() + " ApplicationId: " + this.attemptId + " From RM: " + subClusterId + ".  Previous Container was From subCluster: " + existingSubClusterId);
                        }
                        catch (Exception ex) {
                            throw new YarnRuntimeException(" Can't use any subCluster because an exception occurred ContainerId: " + container.getId() + " ApplicationId: " + this.attemptId + " From RM: " + subClusterId + ".  Previous Container was From subCluster: " + existingSubClusterId, (Throwable)ex);
                        }
                    }
                }
            }
            this.containerIdToSubClusterIdMap.put(container.getId(), chooseSubClusterId);
        }
    }

    private static AllocateRequest findOrCreateAllocateRequestForSubCluster(SubClusterId subClusterId, AllocateRequest originalAMRequest, Map<SubClusterId, AllocateRequest> requestMap) {
        AllocateRequest newRequest;
        if (requestMap.containsKey(subClusterId)) {
            newRequest = requestMap.get(subClusterId);
        } else {
            newRequest = FederationInterceptor.createAllocateRequest();
            newRequest.setResponseId(originalAMRequest.getResponseId());
            newRequest.setProgress(originalAMRequest.getProgress());
            requestMap.put(subClusterId, newRequest);
        }
        return newRequest;
    }

    private static AllocateRequest createAllocateRequest() {
        AllocateRequest request = (AllocateRequest)RECORD_FACTORY.newRecordInstance(AllocateRequest.class);
        request.setAskList(new ArrayList());
        request.setReleaseList(new ArrayList());
        ResourceBlacklistRequest blackList = ResourceBlacklistRequest.newInstance(null, null);
        blackList.setBlacklistAdditions(new ArrayList());
        blackList.setBlacklistRemovals(new ArrayList());
        request.setResourceBlacklistRequest(blackList);
        request.setUpdateRequests(new ArrayList());
        return request;
    }

    protected Set<SubClusterId> getTimedOutSCs(boolean verbose) {
        HashSet<SubClusterId> timedOutSCs = new HashSet<SubClusterId>();
        for (Map.Entry<SubClusterId, Long> entry : this.lastSCResponseTime.entrySet()) {
            long duration;
            if (entry.getValue() > this.lastAMHeartbeatTime || (duration = this.clock.getTime() - entry.getValue()) <= this.subClusterTimeOut) continue;
            if (verbose) {
                LOG.warn("Subcluster {} doesn't have a successful heartbeat for {} seconds for {}", new Object[]{entry.getKey(), (double)duration / 1000.0, this.attemptId});
            }
            timedOutSCs.add(entry.getKey());
        }
        return timedOutSCs;
    }

    private boolean warnIfNotExists(ContainerId containerId, String actionName) {
        if (!this.containerIdToSubClusterIdMap.containsKey(containerId)) {
            LOG.error("AM is trying to {} a container {} that does not exist. Might happen shortly after NM restart when NM recovery is enabled", (Object)actionName, (Object)containerId.toString());
            return false;
        }
        return true;
    }

    protected Map<SubClusterId, List<ResourceRequest>> splitResourceRequests(List<ResourceRequest> askList) throws YarnException {
        return this.policyInterpreter.splitResourceRequests(askList, this.getTimedOutSCs(true));
    }

    @VisibleForTesting
    protected int getUnmanagedAMPoolSize() {
        return this.uamPool.getAllUAMIds().size();
    }

    @VisibleForTesting
    protected UnmanagedAMPoolManager getUnmanagedAMPool() {
        return this.uamPool;
    }

    @VisibleForTesting
    protected Map<SubClusterId, Future<?>> getUamRegisterFutures() {
        return this.uamRegisterFutures;
    }

    @VisibleForTesting
    public Map<SubClusterId, List<AllocateResponse>> getAsyncResponseSink() {
        return this.asyncResponseSink;
    }

    public static <T> boolean isNullOrEmpty(Collection<T> c) {
        return c == null || c.size() == 0;
    }

    public static <T1, T2> boolean isNullOrEmpty(Map<T1, T2> c) {
        return c == null || c.size() == 0;
    }

    @VisibleForTesting
    protected void cacheAllocatedContainersForSubClusterId(List<Container> containers, SubClusterId subClusterId) {
        this.cacheAllocatedContainers(containers, subClusterId);
    }

    @VisibleForTesting
    protected Map<ContainerId, SubClusterId> getContainerIdToSubClusterIdMap() {
        return this.containerIdToSubClusterIdMap;
    }

    private boolean isSCHealth(SubClusterId subClusterId) throws YarnException {
        Set<SubClusterId> timeOutScs = this.getTimedOutSCs(true);
        SubClusterInfo subClusterInfo = this.federationFacade.getSubCluster(subClusterId);
        return !timeOutScs.contains(subClusterId) && subClusterInfo != null && subClusterInfo.getState().isUsable();
    }

    private static class FinishApplicationMasterResponseInfo {
        private final FinishApplicationMasterResponse response;
        private final String subClusterId;

        FinishApplicationMasterResponseInfo(FinishApplicationMasterResponse response, String subClusterId) {
            this.response = response;
            this.subClusterId = subClusterId;
        }

        public FinishApplicationMasterResponse getResponse() {
            return this.response;
        }

        public String getSubClusterId() {
            return this.subClusterId;
        }
    }

    private class HeartbeatCallBack
    implements AsyncCallback<AllocateResponse> {
        private final SubClusterId subClusterId;
        private final boolean isUAM;

        HeartbeatCallBack(SubClusterId subClusterId, boolean isUAM) {
            this.subClusterId = subClusterId;
            this.isUAM = isUAM;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void callback(AllocateResponse response) {
            org.apache.hadoop.yarn.api.records.Token amrmToken = response.getAMRMToken();
            Map map = FederationInterceptor.this.asyncResponseSink;
            synchronized (map) {
                List<AllocateResponse> responses;
                if (FederationInterceptor.this.asyncResponseSink.containsKey(this.subClusterId)) {
                    responses = (List)FederationInterceptor.this.asyncResponseSink.get(this.subClusterId);
                } else {
                    responses = new ArrayList();
                    FederationInterceptor.this.asyncResponseSink.put(this.subClusterId, responses);
                }
                responses.add(response);
                if (this.isUAM) {
                    response.setAMRMToken(null);
                }
                FederationInterceptor.this.asyncResponseSink.notifyAll();
            }
            FederationInterceptor.this.lastSCResponse.put(this.subClusterId, response);
            FederationInterceptor.this.lastSCResponseTime.put(this.subClusterId, FederationInterceptor.this.clock.getTime());
            try {
                FederationInterceptor.this.policyInterpreter.notifyOfResponse(this.subClusterId, response);
            }
            catch (YarnException e) {
                LOG.warn("notifyOfResponse for policy failed for sub-cluster {}.", (Object)this.subClusterId, (Object)e);
            }
            if (this.isUAM && amrmToken != null) {
                Token newToken = ConverterUtils.convertFromYarn((org.apache.hadoop.yarn.api.records.Token)amrmToken, (Text)null);
                response.setAMRMToken(null);
                if (FederationInterceptor.this.registryClient != null) {
                    if (FederationInterceptor.this.registryClient.writeAMRMTokenForUAM(FederationInterceptor.this.attemptId.getApplicationId(), this.subClusterId.getId(), (Token<AMRMTokenIdentifier>)newToken)) {
                        try {
                            AMRMTokenIdentifier identifier = new AMRMTokenIdentifier();
                            identifier.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(newToken.getIdentifier())));
                            LOG.info("Received new UAM amrmToken with keyId {} and service {} from {} for {}, written to Registry", new Object[]{identifier.getKeyId(), newToken.getService(), this.subClusterId, FederationInterceptor.this.attemptId});
                        }
                        catch (IOException identifier) {}
                    }
                } else if (FederationInterceptor.this.getNMStateStore() != null) {
                    try {
                        FederationInterceptor.this.getNMStateStore().storeAMRMProxyAppContextEntry(FederationInterceptor.this.attemptId, FederationInterceptor.NMSS_SECONDARY_SC_PREFIX + this.subClusterId.getId(), newToken.encodeToUrlString().getBytes(FederationInterceptor.STRING_TO_BYTE_FORMAT));
                    }
                    catch (IOException e) {
                        LOG.error("Error storing UAM token as AMRMProxy context entry in NMSS for {}.", (Object)FederationInterceptor.this.attemptId, (Object)e);
                    }
                }
            }
        }
    }
}

