/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies.amrmproxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.shaded.org.apache.commons.collections4.MapUtils;
import org.apache.hadoop.util.Preconditions;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.records.EnhancedHeadroom;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyUtils;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.AbstractAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.dao.WeightedPolicyInfo;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.NoActiveSubclustersException;
import org.apache.hadoop.yarn.server.federation.resolver.SubClusterResolver;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterIdInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalityMulticastAMRMProxyPolicy
extends AbstractAMRMProxyPolicy {
    public static final Logger LOG = LoggerFactory.getLogger(LocalityMulticastAMRMProxyPolicy.class);
    private static Random rand = new Random();
    private Map<SubClusterId, Float> weights;
    private SubClusterResolver resolver;
    private Configuration conf;
    private Map<SubClusterId, Resource> headroom;
    private Map<SubClusterId, EnhancedHeadroom> enhancedHeadroom;
    private float hrAlpha;
    private FederationStateStoreFacade federationFacade;
    private SubClusterId homeSubcluster;
    private int printRRMax;
    public static final String PRINT_RR_MAX = "yarn.nodemanager.amrmproxy.address.splitmerge.printmaxrrcount";
    public static final int DEFAULT_PRINT_RR_MAX = 1000;
    private boolean failOnError = true;

    public static String prettyPrintRequests(List<ResourceRequest> response, int max) {
        StringBuilder builder = new StringBuilder();
        for (ResourceRequest rr : response) {
            builder.append("[id:").append(rr.getAllocationRequestId()).append(" loc:").append(rr.getResourceName()).append(" num:").append(rr.getNumContainers()).append(" pri:").append(rr.getPriority() != null ? rr.getPriority().getPriority() : -1).append("], ");
            if (max == -1 || max-- > 0) continue;
            break;
        }
        return builder.toString();
    }

    @Override
    public void reinitialize(FederationPolicyInitializationContext policyContext) throws FederationPolicyInitializationException {
        WeightedPolicyInfo tempPolicy = this.getPolicyInfo();
        super.reinitialize(policyContext);
        if (!this.getIsDirty()) {
            return;
        }
        HashMap<SubClusterId, Float> newWeightsConverted = new HashMap<SubClusterId, Float>();
        boolean allInactive = true;
        WeightedPolicyInfo policy = this.getPolicyInfo();
        if (policy.getAMRMPolicyWeights() != null && policy.getAMRMPolicyWeights().size() > 0) {
            for (Map.Entry<SubClusterIdInfo, Float> e : policy.getAMRMPolicyWeights().entrySet()) {
                if (e.getValue().floatValue() > 0.0f) {
                    allInactive = false;
                }
                newWeightsConverted.put(e.getKey().toId(), e.getValue());
            }
        }
        if (allInactive) {
            this.setPolicyInfo(tempPolicy);
            throw new FederationPolicyInitializationException("The weights used to configure this policy are all set to zero! (no ResourceRequest could be forwarded with this setting.)");
        }
        if (policyContext.getHomeSubcluster() == null) {
            this.setPolicyInfo(tempPolicy);
            throw new FederationPolicyInitializationException("The homeSubcluster filed in the context must be initialized to use this policy");
        }
        this.weights = newWeightsConverted;
        this.resolver = policyContext.getFederationSubclusterResolver();
        if (this.headroom == null) {
            this.headroom = new ConcurrentHashMap<SubClusterId, Resource>();
            this.enhancedHeadroom = new ConcurrentHashMap<SubClusterId, EnhancedHeadroom>();
        }
        this.hrAlpha = policy.getHeadroomAlpha();
        this.federationFacade = policyContext.getFederationStateStoreFacade();
        this.homeSubcluster = policyContext.getHomeSubcluster();
        this.conf = this.federationFacade.getConf();
        this.printRRMax = this.conf.getInt(PRINT_RR_MAX, 1000);
        this.failOnError = this.conf.getBoolean("yarn.nodemanager.least-load-policy-selector.fail-on-error", true);
    }

    @Override
    public void notifyOfResponse(SubClusterId subClusterId, AllocateResponse response) throws YarnException {
        if (response.getAvailableResources() != null) {
            this.headroom.put(subClusterId, response.getAvailableResources());
        }
        if (response.getEnhancedHeadroom() != null) {
            this.enhancedHeadroom.put(subClusterId, response.getEnhancedHeadroom());
        }
        LOG.info("Subcluster {} updated with AvailableResource {}, EnhancedHeadRoom {}", new Object[]{subClusterId, response.getAvailableResources(), response.getEnhancedHeadroom()});
    }

    @Override
    public Map<SubClusterId, List<ResourceRequest>> splitResourceRequests(List<ResourceRequest> resourceRequests, Set<SubClusterId> timedOutSubClusters) throws YarnException {
        AllocationBookkeeper bookkeeper = new AllocationBookkeeper();
        bookkeeper.reinitialize(this.getActiveSubclusters(), timedOutSubClusters, this.conf);
        ArrayList<ResourceRequest> nonLocalizedRequests = new ArrayList<ResourceRequest>();
        SubClusterId targetId = null;
        Set<SubClusterId> targetIds = null;
        for (ResourceRequest rr : resourceRequests) {
            targetId = null;
            targetIds = null;
            if (ResourceRequest.isAnyLocation((String)rr.getResourceName())) {
                nonLocalizedRequests.add(rr);
                continue;
            }
            try {
                targetId = this.resolver.getSubClusterForNode(rr.getResourceName());
                boolean loadBasedSCSelectorEnabled = this.conf.getBoolean("yarn.nodemanager.least-load-policy-selector.enabled", false);
                if (loadBasedSCSelectorEnabled) {
                    int maxPendingThreshold = this.conf.getInt("yarn.nodemanager.least-load-policy-selector.pending-container.threshold", 10000);
                    targetId = this.routeNodeRequestIfNeeded(targetId, maxPendingThreshold, bookkeeper.getActiveAndEnabledSC());
                }
                LOG.debug("Node request {}", (Object)rr.getResourceName());
            }
            catch (YarnException loadBasedSCSelectorEnabled) {
                // empty catch block
            }
            if (bookkeeper.isActiveAndEnabled(targetId)) {
                bookkeeper.addLocalizedNodeRR(targetId, rr);
                continue;
            }
            try {
                targetIds = this.resolver.getSubClustersForRack(rr.getResourceName());
            }
            catch (YarnException loadBasedSCSelectorEnabled) {
                // empty catch block
            }
            if (targetIds != null && targetIds.size() > 0) {
                boolean hasActive = false;
                for (SubClusterId tid : targetIds) {
                    if (!bookkeeper.isActiveAndEnabled(tid)) continue;
                    bookkeeper.addRackRR(tid, rr);
                    hasActive = true;
                }
                if (hasActive) continue;
            }
            targetId = this.getSubClusterForUnResolvedRequest(bookkeeper, rr.getAllocationRequestId());
            LOG.debug("ERROR resolving sub-cluster for resourceName: {}, picked a random subcluster to forward:{}", (Object)rr.getResourceName(), (Object)targetId);
            if (targetIds != null && targetIds.size() > 0) {
                bookkeeper.addRackRR(targetId, rr);
                continue;
            }
            bookkeeper.addLocalizedNodeRR(targetId, rr);
        }
        this.splitAnyRequests(nonLocalizedRequests, bookkeeper);
        Map answer = bookkeeper.getAnswer();
        LOG.info("Before split {} RRs: {}", (Object)resourceRequests.size(), (Object)LocalityMulticastAMRMProxyPolicy.prettyPrintRequests(resourceRequests, this.printRRMax));
        for (Map.Entry entry : bookkeeper.getAnswer().entrySet()) {
            LOG.info("After split {} has {} RRs: {}", new Object[]{entry.getKey(), ((List)entry.getValue()).size(), LocalityMulticastAMRMProxyPolicy.prettyPrintRequests((List)entry.getValue(), this.printRRMax)});
        }
        return answer;
    }

    protected SubClusterId getSubClusterForUnResolvedRequest(AllocationBookkeeper bookKeeper, long allocationId) {
        return bookKeeper.getSubClusterForUnResolvedRequest(allocationId);
    }

    private void splitAnyRequests(List<ResourceRequest> originalResourceRequests, AllocationBookkeeper allocationBookkeeper) throws YarnException {
        for (ResourceRequest resourceRequest : originalResourceRequests) {
            Long allocationId = resourceRequest.getAllocationRequestId();
            Set targetSubclusters = allocationBookkeeper.getSubClustersForId(allocationId) != null ? allocationBookkeeper.getSubClustersForId(allocationId) : allocationBookkeeper.getActiveAndEnabledSC();
            this.splitIndividualAny(resourceRequest, targetSubclusters, allocationBookkeeper);
        }
    }

    private void splitIndividualAny(ResourceRequest originalResourceRequest, Set<SubClusterId> targetSubclusters, AllocationBookkeeper allocationBookkeeper) throws YarnException {
        long allocationId = originalResourceRequest.getAllocationRequestId();
        int numContainer = originalResourceRequest.getNumContainers();
        if (numContainer == 0) {
            for (SubClusterId targetId : this.headroom.keySet()) {
                allocationBookkeeper.addAnyRR(targetId, originalResourceRequest);
            }
            return;
        }
        ArrayList<SubClusterId> targetSCs = new ArrayList<SubClusterId>(targetSubclusters);
        ArrayList<Float> weightsList = new ArrayList<Float>();
        for (SubClusterId targetId : targetSCs) {
            if (allocationBookkeeper.getSubClustersForId(allocationId) != null) {
                weightsList.add(Float.valueOf(this.getLocalityBasedWeighting(allocationId, targetId, allocationBookkeeper)));
                continue;
            }
            float headroomWeighting = this.getHeadroomWeighting(targetId, allocationBookkeeper);
            float policyWeighting = this.getPolicyConfigWeighting(targetId, allocationBookkeeper);
            weightsList.add(Float.valueOf(this.hrAlpha * headroomWeighting + (1.0f - this.hrAlpha) * policyWeighting));
        }
        ArrayList<Integer> containerNums = this.computeIntegerAssignment(numContainer, weightsList);
        int i = 0;
        for (SubClusterId targetId : targetSCs) {
            if (containerNums.get(i) > 0) {
                ResourceRequest out = ResourceRequest.clone((ResourceRequest)originalResourceRequest);
                out.setNumContainers(containerNums.get(i).intValue());
                if (ResourceRequest.isAnyLocation((String)out.getResourceName())) {
                    allocationBookkeeper.addAnyRR(targetId, out);
                } else {
                    allocationBookkeeper.addRackRR(targetId, out);
                }
            }
            ++i;
        }
    }

    @VisibleForTesting
    protected ArrayList<Integer> computeIntegerAssignment(int totalNum, ArrayList<Float> weightsList) throws YarnException {
        int i;
        ArrayList<Integer> ret = new ArrayList<Integer>();
        float totalWeight = 0.0f;
        float totalNumFloat = totalNum;
        if (weightsList.size() == 0) {
            return ret;
        }
        for (i = 0; i < weightsList.size(); ++i) {
            ret.add(0);
            if (!(weightsList.get(i).floatValue() > 0.0f)) continue;
            totalWeight += weightsList.get(i).floatValue();
        }
        if (totalWeight == 0.0f) {
            StringBuilder sb = new StringBuilder();
            for (Float weight : weightsList) {
                sb.append(weight + ", ");
            }
            throw new FederationPolicyException("No positive value found in weight array " + sb.toString());
        }
        int residue = totalNum;
        for (i = 0; i < weightsList.size(); ++i) {
            if (!(weightsList.get(i).floatValue() > 0.0f)) continue;
            int base = (int)(totalNumFloat * weightsList.get(i).floatValue() / totalWeight);
            ret.set(i, ret.get(i) + base);
            residue -= base;
        }
        for (i = 0; i < residue; ++i) {
            int index = FederationPolicyUtils.getWeightedRandom(weightsList);
            ret.set(index, ret.get(index) + 1);
        }
        return ret;
    }

    private float getLocalityBasedWeighting(long reqId, SubClusterId targetId, AllocationBookkeeper allocationBookkeeper) {
        float totWeight = allocationBookkeeper.getTotNumLocalizedContainers(reqId);
        float localWeight = allocationBookkeeper.getNumLocalizedContainers(reqId, targetId);
        return totWeight > 0.0f ? localWeight / totWeight : 0.0f;
    }

    private float getPolicyConfigWeighting(SubClusterId targetId, AllocationBookkeeper allocationBookkeeper) {
        float totWeight = allocationBookkeeper.totPolicyWeight;
        Float localWeight = (Float)allocationBookkeeper.policyWeights.get(targetId);
        return localWeight != null && totWeight > 0.0f ? localWeight.floatValue() / totWeight : 0.0f;
    }

    private float getHeadroomWeighting(SubClusterId targetId, AllocationBookkeeper allocationBookkeeper) {
        float headroomWeighting = 1.0f / (float)allocationBookkeeper.getActiveAndEnabledSC().size();
        if (this.headroom.containsKey(targetId) && allocationBookkeeper.totHeadroomMemory > 0.0f) {
            float ratioHeadroomKnown = (float)allocationBookkeeper.totHeadRoomEnabledRMs / (float)allocationBookkeeper.getActiveAndEnabledSC().size();
            headroomWeighting = (float)this.headroom.get(targetId).getMemorySize() / allocationBookkeeper.totHeadroomMemory * ratioHeadroomKnown;
        }
        return headroomWeighting;
    }

    protected SubClusterId routeNodeRequestIfNeeded(SubClusterId targetId, int maxThreshold, Set<SubClusterId> activeAndEnabledSCs) {
        int targetPendingCount;
        if (activeAndEnabledSCs.contains(targetId) && ((targetPendingCount = this.getSubClusterLoad(targetId)) == -1 || targetPendingCount < maxThreshold)) {
            return targetId;
        }
        SubClusterId scId = this.chooseSubClusterIdForMaxLoadSC(targetId, maxThreshold, activeAndEnabledSCs);
        return scId;
    }

    private SubClusterId chooseSubClusterIdForMaxLoadSC(SubClusterId targetId, int maxThreshold, Set<SubClusterId> activeAndEnabledSCs) {
        ArrayList<Float> weight = new ArrayList<Float>();
        ArrayList<SubClusterId> scIds = new ArrayList<SubClusterId>();
        int targetLoad = this.getSubClusterLoad(targetId);
        if (targetLoad == -1 || !activeAndEnabledSCs.contains(targetId)) {
            targetLoad = Integer.MAX_VALUE;
        }
        for (SubClusterId sc : activeAndEnabledSCs) {
            int scLoad = this.getSubClusterLoad(sc);
            if (scLoad > targetLoad) {
                return targetId;
            }
            if (scLoad <= maxThreshold / 2) {
                weight.add(Float.valueOf(2.0f));
            } else {
                weight.add(Float.valueOf((float)maxThreshold / (float)scLoad));
            }
            scIds.add(sc);
        }
        if (this.weights.size() == 0) {
            return targetId;
        }
        return (SubClusterId)scIds.get(FederationPolicyUtils.getWeightedRandom(weight));
    }

    private int getSubClusterLoad(SubClusterId subClusterId) {
        EnhancedHeadroom headroomData = this.enhancedHeadroom.get(subClusterId);
        if (headroomData == null) {
            return -1;
        }
        boolean useActiveCoreEnabled = this.conf.getBoolean("yarn.nodemanager.least-load-policy-selector.use-active-core", false);
        if (useActiveCoreEnabled) {
            if (headroomData.getTotalActiveCores() <= 0) {
                return Integer.MAX_VALUE;
            }
            long multiplier = this.conf.getLong("yarn.nodemanager.least-load-policy-selector.multiplier", 50000L);
            double value = headroomData.getNormalizedPendingCount(multiplier) / (double)headroomData.getTotalActiveCores();
            if (value > 2.147483647E9) {
                return Integer.MAX_VALUE;
            }
            return (int)value;
        }
        return headroomData.getTotalPendingCount();
    }

    protected final class AllocationBookkeeper {
        private Map<SubClusterId, List<ResourceRequest>> answer = new TreeMap<SubClusterId, List<ResourceRequest>>();
        private Map<SubClusterId, Set<Long>> maskForRackDeletion = new HashMap<SubClusterId, Set<Long>>();
        private Map<Long, Map<SubClusterId, AtomicLong>> countContainersPerRM = new HashMap<Long, Map<SubClusterId, AtomicLong>>();
        private Map<Long, AtomicLong> totNumLocalizedContainers = new HashMap<Long, AtomicLong>();
        private Map<Long, SubClusterId> unResolvedRequestLocation = new HashMap<Long, SubClusterId>();
        private Set<SubClusterId> activeAndEnabledSC = new HashSet<SubClusterId>();
        private float totHeadroomMemory = 0.0f;
        private int totHeadRoomEnabledRMs = 0;
        private Map<SubClusterId, Float> policyWeights;
        private float totPolicyWeight = 0.0f;

        protected AllocationBookkeeper() {
        }

        private void reinitialize(Map<SubClusterId, SubClusterInfo> activeSubclusters, Set<SubClusterId> timedOutSubClusters, Configuration pConf) throws YarnException {
            if (MapUtils.isEmpty(activeSubclusters)) {
                throw new YarnRuntimeException("null activeSubclusters received");
            }
            this.answer.clear();
            this.maskForRackDeletion.clear();
            this.countContainersPerRM.clear();
            this.totNumLocalizedContainers.clear();
            this.activeAndEnabledSC.clear();
            this.totHeadroomMemory = 0.0f;
            this.totHeadRoomEnabledRMs = 0;
            this.policyWeights = LocalityMulticastAMRMProxyPolicy.this.weights;
            this.totPolicyWeight = 0.0f;
            for (Map.Entry<SubClusterId, Float> entry : this.policyWeights.entrySet()) {
                if (!(entry.getValue().floatValue() > 0.0f) || !activeSubclusters.containsKey(entry.getKey())) continue;
                this.activeAndEnabledSC.add(entry.getKey());
            }
            String blacklistedSubClusters = pConf.get("yarn.nodemanager.least-load-policy-selector.blacklist-subclusters", "");
            if (blacklistedSubClusters != null) {
                Collection tempList = StringUtils.getStringCollection((String)blacklistedSubClusters);
                for (String string : tempList) {
                    this.activeAndEnabledSC.remove(SubClusterId.newInstance(string.trim()));
                }
            }
            if (this.activeAndEnabledSC.size() < 1) {
                String errorMsg = "None of the subClusters enabled in this Policy (weight > 0) are currently active we cannot forward the ResourceRequest(s)";
                if (LocalityMulticastAMRMProxyPolicy.this.failOnError) {
                    throw new NoActiveSubclustersException(errorMsg);
                }
                LOG.error(errorMsg + ", continuing by enabling all active subClusters.");
                this.activeAndEnabledSC.addAll(activeSubclusters.keySet());
                for (SubClusterId subClusterId : activeSubclusters.keySet()) {
                    this.policyWeights.put(subClusterId, Float.valueOf(1.0f));
                }
            }
            HashSet<SubClusterId> tmpSCSet = new HashSet<SubClusterId>(this.activeAndEnabledSC);
            tmpSCSet.removeAll(timedOutSubClusters);
            if (tmpSCSet.size() < 1) {
                LOG.warn("All active and enabled subclusters have expired last heartbeat time. Ignore the expiry check for this request.");
            } else {
                this.activeAndEnabledSC = tmpSCSet;
            }
            LOG.info("{} subcluster active, {} subclusters active and enabled", (Object)activeSubclusters.size(), (Object)this.activeAndEnabledSC.size());
            for (SubClusterId subClusterId : this.activeAndEnabledSC) {
                this.totPolicyWeight += this.policyWeights.get(subClusterId).floatValue();
            }
            for (Map.Entry entry : LocalityMulticastAMRMProxyPolicy.this.headroom.entrySet()) {
                if (!this.activeAndEnabledSC.contains(entry.getKey())) continue;
                this.totHeadroomMemory += (float)((Resource)entry.getValue()).getMemorySize();
                ++this.totHeadRoomEnabledRMs;
            }
        }

        private void addLocalizedNodeRR(SubClusterId targetId, ResourceRequest rr) {
            Preconditions.checkArgument((!ResourceRequest.isAnyLocation((String)rr.getResourceName()) ? 1 : 0) != 0);
            if (rr.getNumContainers() > 0) {
                if (!this.countContainersPerRM.containsKey(rr.getAllocationRequestId())) {
                    this.countContainersPerRM.put(rr.getAllocationRequestId(), new HashMap());
                }
                if (!this.countContainersPerRM.get(rr.getAllocationRequestId()).containsKey(targetId)) {
                    this.countContainersPerRM.get(rr.getAllocationRequestId()).put(targetId, new AtomicLong(0L));
                }
                this.countContainersPerRM.get(rr.getAllocationRequestId()).get(targetId).addAndGet(rr.getNumContainers());
                if (!this.totNumLocalizedContainers.containsKey(rr.getAllocationRequestId())) {
                    this.totNumLocalizedContainers.put(rr.getAllocationRequestId(), new AtomicLong(0L));
                }
                this.totNumLocalizedContainers.get(rr.getAllocationRequestId()).addAndGet(rr.getNumContainers());
            }
            this.internalAddToAnswer(targetId, rr, false);
        }

        private void addRackRR(SubClusterId targetId, ResourceRequest rr) {
            Preconditions.checkArgument((!ResourceRequest.isAnyLocation((String)rr.getResourceName()) ? 1 : 0) != 0);
            this.internalAddToAnswer(targetId, rr, true);
        }

        private void addAnyRR(SubClusterId targetId, ResourceRequest rr) {
            Preconditions.checkArgument((boolean)ResourceRequest.isAnyLocation((String)rr.getResourceName()));
            this.internalAddToAnswer(targetId, rr, false);
        }

        private void internalAddToAnswer(SubClusterId targetId, ResourceRequest partialRR, boolean isRack) {
            if (!isRack) {
                if (!this.maskForRackDeletion.containsKey(targetId)) {
                    this.maskForRackDeletion.put(targetId, new HashSet());
                }
                this.maskForRackDeletion.get(targetId).add(partialRR.getAllocationRequestId());
            }
            if (!this.answer.containsKey(targetId)) {
                this.answer.put(targetId, new ArrayList());
            }
            this.answer.get(targetId).add(partialRR);
        }

        private SubClusterId getSubClusterForUnResolvedRequest(long allocationId) {
            if (this.unResolvedRequestLocation.containsKey(allocationId)) {
                return this.unResolvedRequestLocation.get(allocationId);
            }
            int id = rand.nextInt(this.activeAndEnabledSC.size());
            for (SubClusterId subclusterId : this.activeAndEnabledSC) {
                if (id == 0) {
                    this.unResolvedRequestLocation.put(allocationId, subclusterId);
                    return subclusterId;
                }
                --id;
            }
            throw new RuntimeException("Should not be here. activeAndEnabledSC size = " + this.activeAndEnabledSC.size() + " id = " + id);
        }

        private Set<SubClusterId> getSubClustersForId(long allocationId) {
            if (this.countContainersPerRM.get(allocationId) == null) {
                return null;
            }
            return this.countContainersPerRM.get(allocationId).keySet();
        }

        private Map<SubClusterId, List<ResourceRequest>> getAnswer() {
            Iterator<Map.Entry<SubClusterId, List<ResourceRequest>>> answerIter = this.answer.entrySet().iterator();
            while (answerIter.hasNext()) {
                Map.Entry<SubClusterId, List<ResourceRequest>> entry = answerIter.next();
                SubClusterId scId = entry.getKey();
                Set<Long> mask = this.maskForRackDeletion.get(scId);
                if (mask != null) {
                    Iterator<ResourceRequest> rrIter = entry.getValue().iterator();
                    while (rrIter.hasNext()) {
                        ResourceRequest rr = rrIter.next();
                        if (mask.contains(rr.getAllocationRequestId())) continue;
                        rrIter.remove();
                    }
                }
                if (mask != null && entry.getValue().size() != 0) continue;
                answerIter.remove();
                LOG.info("removing {} from output because it has only rack RR", (Object)scId);
            }
            return this.answer;
        }

        private Set<SubClusterId> getActiveAndEnabledSC() {
            return this.activeAndEnabledSC;
        }

        private long getTotNumLocalizedContainers(long allocationId) {
            AtomicLong c = this.totNumLocalizedContainers.get(allocationId);
            return c == null ? 0L : c.get();
        }

        private long getNumLocalizedContainers(long allocationId, SubClusterId targetId) {
            AtomicLong c = this.countContainersPerRM.get(allocationId).get(targetId);
            return c == null ? 0L : c.get();
        }

        private boolean isActiveAndEnabled(SubClusterId targetId) {
            if (targetId == null) {
                return false;
            }
            return this.getActiveAndEnabledSC().contains(targetId);
        }
    }
}

