/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.events;

import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.events.StoreEvent;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.events.StoreEventListener;

class FireableStoreEventHolder<K, V> {
    private final Lock lock = new ReentrantLock();
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.CREATED);
    private volatile boolean failed = false;
    private final StoreEvent<K, V> event;
    private final Condition condition;

    FireableStoreEventHolder(StoreEvent<K, V> event) {
        this.event = event;
        this.condition = this.lock.newCondition();
    }

    void markFireable() {
        this.status.compareAndSet(Status.CREATED, Status.FIREABLE);
    }

    boolean isFireable() {
        return this.status.get().equals((Object)Status.FIREABLE);
    }

    void waitTillFired() {
        while (!this.isFired()) {
            this.lock.lock();
            try {
                if (this.isFired()) continue;
                this.condition.awaitUninterruptibly();
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    private boolean isFired() {
        return this.status.get() == Status.FIRED;
    }

    boolean markFired() {
        boolean didIt = this.status.compareAndSet(Status.FIREABLE, Status.FIRED);
        if (didIt) {
            this.lock.lock();
            try {
                this.condition.signal();
            }
            finally {
                this.lock.unlock();
            }
        }
        return didIt;
    }

    void markFailed() {
        this.failed = true;
    }

    void fireOn(StoreEventListener<K, V> listener) {
        if (!this.failed) {
            listener.onEvent(this.event);
        }
    }

    int eventKeyHash() {
        return this.event.getKey().hashCode();
    }

    StoreEvent<K, V> getEvent() {
        return this.event;
    }

    public String toString() {
        return "FireableStoreEventHolder in state " + (Object)((Object)this.status.get()) + " of " + this.event + (this.failed ? " (failed)" : " (not failed)");
    }

    static enum Status {
        CREATED,
        FIREABLE,
        FIRED;

    }
}

