/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.slive;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.util.StringUtils;

class OperationOutput {
    private OutputType dataType;
    private String opType;
    private String measurementType;
    private Object value;
    private static final String TYPE_SEP = ":";
    private static final String MEASUREMENT_SEP = "*";
    private static final String STRING_SEP = ";";

    OperationOutput(String key, Object value) {
        int place = key.indexOf(TYPE_SEP);
        if (place == -1) {
            throw new IllegalArgumentException("Invalid key format - no type separator - :");
        }
        try {
            this.dataType = OutputType.valueOf(StringUtils.toUpperCase((String)key.substring(0, place)));
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid key format - invalid output type", e);
        }
        key = key.substring(place + 1);
        place = key.indexOf(MEASUREMENT_SEP);
        if (place == -1) {
            throw new IllegalArgumentException("Invalid key format - no measurement separator - *");
        }
        this.opType = key.substring(0, place);
        this.measurementType = key.substring(place + 1);
        this.value = value;
    }

    OperationOutput(Text key, Object value) {
        this(key.toString(), value);
    }

    public String toString() {
        return this.getKeyString() + " (" + this.value + ")";
    }

    OperationOutput(OutputType dataType, String opType, String measurementType, Object value) {
        this.dataType = dataType;
        this.opType = opType;
        this.measurementType = measurementType;
        this.value = value;
    }

    static OperationOutput merge(OperationOutput o1, OperationOutput o2) {
        if (o1.getMeasurementType().equals(o2.getMeasurementType()) && o1.getOperationType().equals(o2.getOperationType())) {
            Object newvalue = null;
            OutputType newtype = null;
            String opType = o1.getOperationType();
            String mType2 = o1.getMeasurementType();
            if (o1.getOutputType() == OutputType.STRING || o2.getOutputType() == OutputType.STRING) {
                newtype = OutputType.STRING;
                StringBuilder str = new StringBuilder();
                str.append(o1.getValue());
                str.append(STRING_SEP);
                str.append(o2.getValue());
                newvalue = str.toString();
            } else {
                if (o1.getOutputType() == OutputType.DOUBLE || o2.getOutputType() == OutputType.DOUBLE) {
                    newtype = OutputType.DOUBLE;
                    try {
                        newvalue = Double.parseDouble(o1.getValue().toString()) + Double.parseDouble(o2.getValue().toString());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Unable to combine a type with a double " + o1 + " & " + o2, e);
                    }
                }
                if (o1.getOutputType() == OutputType.FLOAT || o2.getOutputType() == OutputType.FLOAT) {
                    newtype = OutputType.FLOAT;
                    try {
                        newvalue = Float.valueOf(Float.parseFloat(o1.getValue().toString()) + Float.parseFloat(o2.getValue().toString()));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Unable to combine a type with a float " + o1 + " & " + o2, e);
                    }
                }
                if (o1.getOutputType() == OutputType.LONG || o2.getOutputType() == OutputType.LONG) {
                    newtype = OutputType.LONG;
                    try {
                        newvalue = Long.parseLong(o1.getValue().toString()) + Long.parseLong(o2.getValue().toString());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Unable to combine a type with a long " + o1 + " & " + o2, e);
                    }
                }
                if (o1.getOutputType() == OutputType.INTEGER || o2.getOutputType() == OutputType.INTEGER) {
                    newtype = OutputType.INTEGER;
                    try {
                        newvalue = Integer.parseInt(o1.getValue().toString()) + Integer.parseInt(o2.getValue().toString());
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Unable to combine a type with an int " + o1 + " & " + o2, e);
                    }
                }
            }
            return new OperationOutput(newtype, opType, mType2, newvalue);
        }
        throw new IllegalArgumentException("Unable to combine dissimilar types " + o1 + " & " + o2);
    }

    private String getKeyString() {
        StringBuilder str = new StringBuilder();
        str.append(this.getOutputType().name());
        str.append(TYPE_SEP);
        str.append(this.getOperationType());
        str.append(MEASUREMENT_SEP);
        str.append(this.getMeasurementType());
        return str.toString();
    }

    Text getKey() {
        return new Text(this.getKeyString());
    }

    Text getOutputValue() {
        StringBuilder valueStr = new StringBuilder();
        valueStr.append(this.getValue());
        return new Text(valueStr.toString());
    }

    Object getValue() {
        return this.value;
    }

    OutputType getOutputType() {
        return this.dataType;
    }

    String getOperationType() {
        return this.opType;
    }

    String getMeasurementType() {
        return this.measurementType;
    }

    static enum OutputType {
        STRING,
        FLOAT,
        LONG,
        DOUBLE,
        INTEGER;

    }
}

