/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import java.util.concurrent.atomic.AtomicInteger;
import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.internal.producers.ProducerArbiter;
import rx.subscriptions.SerialSubscription;

public final class OnSubscribeSwitchIfEmpty<T>
implements Observable.OnSubscribe<T> {
    final Observable<? extends T> source;
    final Observable<? extends T> alternate;

    public OnSubscribeSwitchIfEmpty(Observable<? extends T> source, Observable<? extends T> alternate) {
        this.source = source;
        this.alternate = alternate;
    }

    @Override
    public void call(Subscriber<? super T> child) {
        SerialSubscription serial = new SerialSubscription();
        ProducerArbiter arbiter = new ProducerArbiter();
        ParentSubscriber<? extends T> parent = new ParentSubscriber<T>(child, serial, arbiter, this.alternate);
        serial.set(parent);
        child.add(serial);
        child.setProducer(arbiter);
        parent.subscribe(this.source);
    }

    static final class AlternateSubscriber<T>
    extends Subscriber<T> {
        private final ProducerArbiter arbiter;
        private final Subscriber<? super T> child;

        AlternateSubscriber(Subscriber<? super T> child, ProducerArbiter arbiter) {
            this.child = child;
            this.arbiter = arbiter;
        }

        @Override
        public void setProducer(Producer producer) {
            this.arbiter.setProducer(producer);
        }

        @Override
        public void onCompleted() {
            this.child.onCompleted();
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.child.onNext(t);
            this.arbiter.produced(1L);
        }
    }

    static final class ParentSubscriber<T>
    extends Subscriber<T> {
        private boolean empty = true;
        private final Subscriber<? super T> child;
        private final SerialSubscription serial;
        private final ProducerArbiter arbiter;
        private final Observable<? extends T> alternate;
        final AtomicInteger wip;
        volatile boolean active;

        ParentSubscriber(Subscriber<? super T> child, SerialSubscription serial, ProducerArbiter arbiter, Observable<? extends T> alternate) {
            this.child = child;
            this.serial = serial;
            this.arbiter = arbiter;
            this.alternate = alternate;
            this.wip = new AtomicInteger();
        }

        @Override
        public void setProducer(Producer producer) {
            this.arbiter.setProducer(producer);
        }

        @Override
        public void onCompleted() {
            if (!this.empty) {
                this.child.onCompleted();
            } else if (!this.child.isUnsubscribed()) {
                this.active = false;
                this.subscribe(null);
            }
        }

        void subscribe(Observable<? extends T> source) {
            if (this.wip.getAndIncrement() == 0) {
                while (!this.child.isUnsubscribed()) {
                    if (!this.active) {
                        if (source == null) {
                            AlternateSubscriber<? super T> as = new AlternateSubscriber<T>(this.child, this.arbiter);
                            this.serial.set(as);
                            this.active = true;
                            this.alternate.unsafeSubscribe(as);
                        } else {
                            this.active = true;
                            source.unsafeSubscribe(this);
                            source = null;
                        }
                    }
                    if (this.wip.decrementAndGet() != 0) continue;
                }
            }
        }

        @Override
        public void onError(Throwable e) {
            this.child.onError(e);
        }

        @Override
        public void onNext(T t) {
            this.empty = false;
            this.child.onNext(t);
            this.arbiter.produced(1L);
        }
    }
}

