/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contracts.annotations;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceStability.Evolving
public class ConfigurationValidationAnnotations {

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface BooleanConfigurationValidatorAnnotation {
        public String ConfigurationKey();

        public boolean DefaultValue();

        public boolean ThrowIfInvalid() default false;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Base64StringConfigurationValidatorAnnotation {
        public String ConfigurationKey();

        public String DefaultValue();

        public boolean ThrowIfInvalid() default false;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface StringConfigurationValidatorAnnotation {
        public String ConfigurationKey();

        public String DefaultValue();

        public boolean ThrowIfInvalid() default false;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface LongConfigurationValidatorAnnotation {
        public String ConfigurationKey();

        public long MaxValue() default 0x7FFFFFFFFFFFFFFFL;

        public long MinValue() default -9223372036854775808L;

        public long DefaultValue();

        public boolean ThrowIfInvalid() default false;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntegerWithOutlierConfigurationValidatorAnnotation {
        public String ConfigurationKey();

        public int MaxValue() default 0x7FFFFFFF;

        public int MinValue() default -2147483648;

        public int OutlierValue() default -2147483648;

        public int DefaultValue();

        public boolean ThrowIfInvalid() default false;
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface IntegerConfigurationValidatorAnnotation {
        public String ConfigurationKey();

        public int MaxValue() default 0x7FFFFFFF;

        public int MinValue() default -2147483648;

        public int DefaultValue();

        public boolean ThrowIfInvalid() default false;
    }
}

