/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.policies;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.policies.FederationPolicyInitializationContext;
import org.apache.hadoop.yarn.server.federation.policies.amrmproxy.FederationAMRMProxyPolicy;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyException;
import org.apache.hadoop.yarn.server.federation.policies.exceptions.FederationPolicyInitializationException;
import org.apache.hadoop.yarn.server.federation.policies.manager.FederationPolicyManager;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterPolicyConfiguration;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class FederationPolicyUtils {
    private static final Logger LOG = LoggerFactory.getLogger(FederationPolicyUtils.class);
    public static final String NO_ACTIVE_SUBCLUSTER_AVAILABLE = "No active SubCluster available to submit the request.";
    private static Random rand = new Random(System.currentTimeMillis());

    private FederationPolicyUtils() {
    }

    public static FederationPolicyManager instantiatePolicyManager(String newType) throws FederationPolicyInitializationException {
        FederationPolicyManager federationPolicyManager = null;
        try {
            Class<?> c = Class.forName(newType);
            federationPolicyManager = (FederationPolicyManager)c.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new FederationPolicyInitializationException(e);
        }
        catch (InstantiationException e) {
            throw new FederationPolicyInitializationException(e);
        }
        catch (IllegalAccessException e) {
            throw new FederationPolicyInitializationException(e);
        }
        return federationPolicyManager;
    }

    public static SubClusterPolicyConfiguration loadPolicyConfiguration(String queue, Configuration conf, FederationStateStoreFacade federationFacade) {
        SubClusterPolicyConfiguration configuration = null;
        if (queue != null) {
            try {
                configuration = federationFacade.getPolicyConfiguration(queue);
            }
            catch (YarnException e) {
                LOG.warn("Failed to get policy from FederationFacade with queue " + queue + ": " + e.getMessage());
            }
        }
        if (configuration == null) {
            LOG.info("No policy configured for queue {} in StateStore, fallback to default queue", (Object)queue);
            queue = "*";
            try {
                configuration = federationFacade.getPolicyConfiguration(queue);
            }
            catch (YarnException e) {
                LOG.warn("No fallback behavior defined in store, defaulting to XML configuration fallback behavior.");
            }
        }
        if (configuration == null) {
            LOG.info("No policy configured for default queue {} in StateStore, fallback to local config", (Object)queue);
            String defaultFederationPolicyManager = conf.get("yarn.federation.policy-manager", "org.apache.hadoop.yarn.server.federation.policies.manager.UniformBroadcastPolicyManager");
            String defaultPolicyParamString = conf.get("yarn.federation.policy-manager-params", "");
            ByteBuffer defaultPolicyParam = ByteBuffer.wrap(defaultPolicyParamString.getBytes(StandardCharsets.UTF_8));
            configuration = SubClusterPolicyConfiguration.newInstance(queue, defaultFederationPolicyManager, defaultPolicyParam);
        }
        return configuration;
    }

    public static FederationAMRMProxyPolicy loadAMRMPolicy(String queue, FederationAMRMProxyPolicy oldPolicy, Configuration conf, FederationStateStoreFacade federationFacade, SubClusterId homeSubClusterId) throws FederationPolicyInitializationException {
        SubClusterPolicyConfiguration configuration = FederationPolicyUtils.loadPolicyConfiguration(queue, conf, federationFacade);
        FederationPolicyInitializationContext context = new FederationPolicyInitializationContext(configuration, federationFacade.getSubClusterResolver(), federationFacade, homeSubClusterId);
        LOG.info("Creating policy manager of type: " + configuration.getType());
        FederationPolicyManager federationPolicyManager = FederationPolicyUtils.instantiatePolicyManager(configuration.getType());
        federationPolicyManager.setQueue(configuration.getQueue());
        return federationPolicyManager.getAMRMPolicy(context, oldPolicy);
    }

    public static void validateSubClusterAvailability(Collection<SubClusterId> activeSubClusters, Collection<SubClusterId> blackListSubClusters) throws FederationPolicyException {
        if (activeSubClusters != null && !activeSubClusters.isEmpty()) {
            if (blackListSubClusters == null) {
                return;
            }
            for (SubClusterId scId : activeSubClusters) {
                if (blackListSubClusters.contains(scId)) continue;
                return;
            }
        }
        throw new FederationPolicyException(NO_ACTIVE_SUBCLUSTER_AVAILABLE);
    }

    public static int getWeightedRandom(ArrayList<Float> weights) {
        int i;
        float totalWeight = 0.0f;
        for (i = 0; i < weights.size(); ++i) {
            if (!(weights.get(i).floatValue() > 0.0f)) continue;
            totalWeight += weights.get(i).floatValue();
        }
        if (totalWeight == 0.0f) {
            return -1;
        }
        float samplePoint = rand.nextFloat() * totalWeight;
        int lastIndex = 0;
        for (i = 0; i < weights.size(); ++i) {
            if (!(weights.get(i).floatValue() > 0.0f)) continue;
            if (samplePoint <= weights.get(i).floatValue()) {
                return i;
            }
            lastIndex = i;
            samplePoint -= weights.get(i).floatValue();
        }
        return lastIndex;
    }

    @VisibleForTesting
    public static void setRand(long seed) {
        rand.setSeed(seed);
    }
}

