/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.output.committer.manifest;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.statistics.IOStatisticsSource;
import org.apache.hadoop.fs.statistics.impl.IOStatisticsStore;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.impl.ManifestCommitterSupport;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageConfig;
import org.apache.hadoop.mapreduce.lib.output.committer.manifest.stages.StageEventCallbacks;
import org.apache.hadoop.shaded.org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.thirdparty.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.util.functional.CloseableTaskPoolSubmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ManifestCommitterConfig
implements IOStatisticsSource {
    private static final Logger LOG = LoggerFactory.getLogger(ManifestCommitterConfig.class);
    private final Path destinationDir;
    private final String role;
    private final Path taskAttemptDir;
    private final Configuration conf;
    private final JobContext jobContext;
    private final boolean createJobMarker;
    private final String jobUniqueId;
    private final String jobUniqueIdSource;
    private final int jobAttemptNumber;
    private final String jobAttemptId;
    private final String taskId;
    private final String taskAttemptId;
    private final Progressable progressable;
    private final IOStatisticsStore iostatistics;
    private final boolean validateOutput;
    private final ManifestCommitterSupport.AttemptDirectories dirs;
    private final StageEventCallbacks stageEventCallbacks;
    private final String name;
    private final boolean deleteTargetPaths;
    private final int writerQueueCapacity;
    private final int saveManifestAttempts;

    ManifestCommitterConfig(Path outputPath, String role, JobContext context, IOStatisticsStore iostatistics, StageEventCallbacks stageEventCallbacks) {
        this.role = role;
        this.jobContext = context;
        this.conf = context.getConfiguration();
        this.destinationDir = outputPath;
        this.iostatistics = iostatistics;
        this.stageEventCallbacks = stageEventCallbacks;
        Pair<String, String> pair = ManifestCommitterSupport.buildJobUUID(this.conf, context.getJobID());
        this.jobUniqueId = (String)pair.getLeft();
        this.jobUniqueIdSource = (String)pair.getRight();
        this.jobAttemptNumber = ManifestCommitterSupport.getAppAttemptId(context);
        this.jobAttemptId = this.jobUniqueId + "_" + this.jobAttemptNumber;
        this.dirs = new ManifestCommitterSupport.AttemptDirectories(outputPath, this.jobUniqueId, this.jobAttemptNumber);
        this.createJobMarker = this.conf.getBoolean("mapreduce.fileoutputcommitter.marksuccessfuljobs", true);
        this.validateOutput = this.conf.getBoolean("mapreduce.manifest.committer.validate.output", false);
        this.deleteTargetPaths = this.conf.getBoolean("mapreduce.manifest.committer.delete.target.files", false);
        this.writerQueueCapacity = this.conf.getInt("mapreduce.manifest.committer.writer.queue.capacity", 32);
        int attempts = this.conf.getInt("mapreduce.manifest.committer.manifest.save.attempts", 5);
        if (attempts < 1) {
            LOG.warn("Invalid value for {}: {}", (Object)"mapreduce.manifest.committer.manifest.save.attempts", (Object)attempts);
            attempts = 1;
        }
        this.saveManifestAttempts = attempts;
        if (context instanceof TaskAttemptContext) {
            TaskAttemptContext tac = (TaskAttemptContext)context;
            TaskAttemptID taskAttempt = Objects.requireNonNull(tac.getTaskAttemptID());
            this.taskAttemptId = taskAttempt.toString();
            this.taskId = taskAttempt.getTaskID().toString();
            this.taskAttemptDir = this.dirs.getTaskAttemptPath(this.taskAttemptId);
            this.progressable = tac;
            this.name = String.format("[Task-Attempt %s]", this.taskAttemptId);
        } else {
            this.taskId = "";
            this.taskAttemptId = "";
            this.taskAttemptDir = null;
            this.progressable = null;
            this.name = String.format("[Job-Attempt %s]", this.jobAttemptId);
        }
    }

    public String toString() {
        return "ManifestCommitterConfig{name=" + this.name + ", destinationDir=" + this.destinationDir + ", role='" + this.role + '\'' + ", taskAttemptDir=" + this.taskAttemptDir + ", createJobMarker=" + this.createJobMarker + ", jobUniqueId='" + this.jobUniqueId + '\'' + ", jobUniqueIdSource='" + this.jobUniqueIdSource + '\'' + ", jobAttemptNumber=" + this.jobAttemptNumber + ", jobAttemptId='" + this.jobAttemptId + '\'' + ", taskId='" + this.taskId + '\'' + ", taskAttemptId='" + this.taskAttemptId + '\'' + '}';
    }

    FileSystem getDestinationFileSystem() throws IOException {
        return FileSystem.get(this.destinationDir.toUri(), this.conf);
    }

    StageConfig createStageConfig() {
        StageConfig stageConfig = new StageConfig();
        stageConfig.withConfiguration(this.conf).withDeleteTargetPaths(this.deleteTargetPaths).withIOStatistics(this.iostatistics).withJobAttemptNumber(this.jobAttemptNumber).withJobDirectories(this.dirs).withJobId(this.jobUniqueId).withJobIdSource(this.jobUniqueIdSource).withName(this.name).withProgressable(this.progressable).withStageEventCallbacks(this.stageEventCallbacks).withTaskAttemptDir(this.taskAttemptDir).withTaskAttemptId(this.taskAttemptId).withTaskId(this.taskId).withWriterQueueCapacity(this.writerQueueCapacity);
        return stageConfig;
    }

    public Path getDestinationDir() {
        return this.destinationDir;
    }

    public String getRole() {
        return this.role;
    }

    public Path getTaskAttemptDir() {
        return this.taskAttemptDir;
    }

    public Path getJobAttemptDir() {
        return this.dirs.getJobAttemptDir();
    }

    public Path getTaskManifestDir() {
        return this.dirs.getTaskManifestDir();
    }

    public Configuration getConf() {
        return this.conf;
    }

    public JobContext getJobContext() {
        return this.jobContext;
    }

    public boolean getCreateJobMarker() {
        return this.createJobMarker;
    }

    public String getJobAttemptId() {
        return this.jobAttemptId;
    }

    public String getTaskAttemptId() {
        return this.taskAttemptId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public String getJobUniqueId() {
        return this.jobUniqueId;
    }

    public boolean getValidateOutput() {
        return this.validateOutput;
    }

    public String getName() {
        return this.name;
    }

    public int getSaveManifestAttempts() {
        return this.saveManifestAttempts;
    }

    public int getWriterQueueCapacity() {
        return this.writerQueueCapacity;
    }

    @Override
    public IOStatisticsStore getIOStatistics() {
        return this.iostatistics;
    }

    public CloseableTaskPoolSubmitter createSubmitter() {
        return this.createSubmitter("mapreduce.manifest.committer.io.threads", 32);
    }

    public CloseableTaskPoolSubmitter createSubmitter(String key, int defVal) {
        int numThreads = this.conf.getInt(key, defVal);
        if (numThreads <= 0) {
            numThreads = defVal;
        }
        return ManifestCommitterConfig.createCloseableTaskSubmitter(numThreads, this.getJobAttemptId());
    }

    public static CloseableTaskPoolSubmitter createCloseableTaskSubmitter(int numThreads, String jobAttemptId) {
        return new CloseableTaskPoolSubmitter(HadoopExecutors.newFixedThreadPool(numThreads, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("manifest-committer-" + jobAttemptId + "-%d").build()));
    }
}

