/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestFrame;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestHeaders;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.UUID;

public final class RntbdRequest {
    private static final byte[] EmptyByteArray = new byte[0];
    private final RntbdRequestFrame frame;
    private final RntbdRequestHeaders headers;
    private final byte[] payload;

    private RntbdRequest(RntbdRequestFrame frame, RntbdRequestHeaders headers, byte[] payload) {
        Objects.requireNonNull(frame, "frame");
        Objects.requireNonNull(headers, "headers");
        this.frame = frame;
        this.headers = headers;
        this.payload = payload == null ? EmptyByteArray : payload;
    }

    static RntbdRequest decode(ByteBuf in) {
        int resourceOperationCode = in.getInt(in.readerIndex() + 4);
        if (resourceOperationCode == 0) {
            String reason = String.format("resourceOperationCode=0x%08X", resourceOperationCode);
            throw new IllegalStateException(reason);
        }
        int start = in.readerIndex();
        int expectedLength = in.readIntLE();
        RntbdRequestFrame header = RntbdRequestFrame.decode(in);
        RntbdRequestHeaders metadata = RntbdRequestHeaders.decode(in);
        ByteBuf payloadBuf = in.readSlice(expectedLength - (in.readerIndex() - start));
        int observedLength = in.readerIndex() - start;
        if (observedLength != expectedLength) {
            String reason = String.format("expectedLength=%d, observedLength=%d", expectedLength, observedLength);
            throw new IllegalStateException(reason);
        }
        byte[] payload = new byte[payloadBuf.readableBytes()];
        payloadBuf.readBytes(payload);
        in.discardReadBytes();
        return new RntbdRequest(header, metadata, payload);
    }

    public static RntbdRequest from(RntbdRequestArgs args) {
        RxDocumentServiceRequest serviceRequest = args.getServiceRequest();
        RntbdRequestFrame frame = new RntbdRequestFrame(serviceRequest.getActivityId(), serviceRequest.getOperationType(), serviceRequest.getResourceType());
        RntbdRequestHeaders headers = new RntbdRequestHeaders(args, frame);
        return new RntbdRequest(frame, headers, serviceRequest.getContent());
    }

    public UUID getActivityId() {
        return this.frame.getActivityId();
    }

    void encode(ByteBuf out) {
        int expectedLength = 24 + this.headers.computeLength();
        int start = out.readerIndex();
        out.writeIntLE(expectedLength);
        this.frame.encode(out);
        this.headers.encode(out);
        assert (out.writerIndex() - start == expectedLength);
        if (this.payload.length > 0) {
            out.writeIntLE(this.payload.length);
            out.writeBytes(this.payload);
        }
    }
}

