/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.microsoft.azure.cosmosdb.internal.UserAgentContainer;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContextDecoder;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContextRequest;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdContextRequestEncoder;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CombinedChannelDuplexHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RntbdContextNegotiator
extends CombinedChannelDuplexHandler<RntbdContextDecoder, RntbdContextRequestEncoder> {
    private static final Logger logger = LoggerFactory.getLogger(RntbdContextNegotiator.class);
    private final RntbdRequestManager manager;
    private final UserAgentContainer userAgent;
    private volatile boolean pendingRntbdContextRequest = true;

    public RntbdContextNegotiator(RntbdRequestManager manager, UserAgentContainer userAgent) {
        super((ChannelInboundHandler)new RntbdContextDecoder(), (ChannelOutboundHandler)new RntbdContextRequestEncoder());
        Objects.requireNonNull(manager);
        Objects.requireNonNull(userAgent);
        this.manager = manager;
        this.userAgent = userAgent;
    }

    public void write(ChannelHandlerContext context, Object message, ChannelPromise promise) throws Exception {
        if (!(message instanceof ByteBuf)) {
            throw new IllegalArgumentException(String.format("message: %s", message.getClass()));
        }
        ByteBuf out = (ByteBuf)message;
        if (this.manager.hasRntbdContext()) {
            context.writeAndFlush((Object)out, promise);
        } else {
            if (this.pendingRntbdContextRequest) {
                this.startRntbdContextRequest(context);
                this.pendingRntbdContextRequest = false;
            }
            this.manager.pendWrite(out, promise);
        }
    }

    private void startRntbdContextRequest(ChannelHandlerContext context) throws Exception {
        logger.debug("{} START CONTEXT REQUEST", (Object)context.channel());
        Channel channel = context.channel();
        RntbdContextRequest request = new RntbdContextRequest(UUID.randomUUID(), this.userAgent);
        CompletableFuture<RntbdContextRequest> contextRequestFuture = this.manager.getRntbdContextRequestFuture();
        super.write(context, (Object)request, channel.newPromise().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                contextRequestFuture.complete(request);
                return;
            }
            if (future.isCancelled()) {
                contextRequestFuture.cancel(true);
                return;
            }
            contextRequestFuture.completeExceptionally(future.cause());
        })));
    }
}

