/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.series;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.SortedMap;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.IndexMapper;
import org.ojalgo.array.DenseArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.series.MappedIndexSeries;
import org.ojalgo.series.primitive.CoordinatedSet;
import org.ojalgo.series.primitive.DataSeries;
import org.ojalgo.series.primitive.PrimitiveSeries;
import org.ojalgo.type.CalendarDate;
import org.ojalgo.type.CalendarDateDuration;
import org.ojalgo.type.ColourData;
import org.ojalgo.type.TimeIndex;
import org.ojalgo.type.keyvalue.KeyValue;

public interface BasicSeries<K extends Comparable<? super K>, V extends Number>
extends SortedMap<K, V> {
    public static final TimeSeriesBuilder<Calendar> CALENDAR = new TimeSeriesBuilder<Calendar>(TimeIndex.CALENDAR);
    public static final TimeSeriesBuilder<CalendarDate> CALENDAR_DATE = new TimeSeriesBuilder<CalendarDate>(TimeIndex.CALENDAR_DATE);
    public static final TimeSeriesBuilder<Date> DATE = new TimeSeriesBuilder<Date>(TimeIndex.DATE);
    public static final TimeSeriesBuilder<Instant> INSTANT = new TimeSeriesBuilder<Instant>(TimeIndex.INSTANT);
    public static final TimeSeriesBuilder<LocalDate> LOCAL_DATE = new TimeSeriesBuilder<LocalDate>(TimeIndex.LOCAL_DATE);
    public static final TimeSeriesBuilder<LocalDateTime> LOCAL_DATE_TIME = new TimeSeriesBuilder<LocalDateTime>(TimeIndex.LOCAL_DATE_TIME);
    public static final TimeSeriesBuilder<LocalTime> LOCAL_TIME = new TimeSeriesBuilder<LocalTime>(TimeIndex.LOCAL_TIME);
    public static final TimeSeriesBuilder<OffsetDateTime> OFFSET_DATE_TIME = new TimeSeriesBuilder<OffsetDateTime>(TimeIndex.OFFSET_DATE_TIME);
    public static final TimeSeriesBuilder<ZonedDateTime> ZONED_DATE_TIME = new TimeSeriesBuilder<ZonedDateTime>(TimeIndex.ZONED_DATE_TIME);

    public static BasicSeries<Double, Double> make(DenseArray.Factory<Double> arrayFactory) {
        return new MappedIndexSeries<Double, Double>(arrayFactory, MappedIndexSeries.MAPPER, null);
    }

    public static BasicSeries<Double, Double> make(DenseArray.Factory<Double> arrayFactory, BinaryFunction<Double> accumulator) {
        return new MappedIndexSeries<Double, Double>(arrayFactory, MappedIndexSeries.MAPPER, accumulator);
    }

    public static <N extends Number> BasicSeries<N, N> make(DenseArray.Factory<N> arrayFactory, IndexMapper<N> indexMapper) {
        return new MappedIndexSeries<N, N>(arrayFactory, indexMapper, null);
    }

    public static <N extends Number> BasicSeries<N, N> make(DenseArray.Factory<N> arrayFactory, IndexMapper<N> indexMapper, BinaryFunction<N> accumulator) {
        return new MappedIndexSeries<N, N>(arrayFactory, indexMapper, accumulator);
    }

    public static <K extends Comparable<? super K>> CoordinatedSet<K> coordinate(List<? extends BasicSeries<K, ?>> uncoordinated) {
        return CoordinatedSet.from(uncoordinated);
    }

    public static <K extends Comparable<? super K>> K findEarliestFirstKey(Collection<? extends BasicSeries<K, ?>> collection) {
        Comparable retVal = null;
        Comparable tmpVal = null;
        for (BasicSeries<K, ?> individual : collection) {
            tmpVal = (Comparable)individual.firstKey();
            if (retVal != null && tmpVal.compareTo(retVal) >= 0) continue;
            retVal = tmpVal;
        }
        return (K)retVal;
    }

    public static <K extends Comparable<? super K>> K findEarliestLastKey(Collection<? extends BasicSeries<K, ?>> collection) {
        Comparable retVal = null;
        Comparable tmpVal = null;
        for (BasicSeries<K, ?> individual : collection) {
            tmpVal = (Comparable)individual.lastKey();
            if (retVal != null && tmpVal.compareTo(retVal) >= 0) continue;
            retVal = tmpVal;
        }
        return (K)retVal;
    }

    public static <K extends Comparable<? super K>> K findLatestFirstKey(Collection<? extends BasicSeries<K, ?>> collection) {
        Comparable retVal = null;
        Comparable tmpVal = null;
        for (BasicSeries<K, ?> individual : collection) {
            tmpVal = (Comparable)individual.firstKey();
            if (retVal != null && tmpVal.compareTo(retVal) <= 0) continue;
            retVal = tmpVal;
        }
        return (K)retVal;
    }

    public static <K extends Comparable<? super K>> K findLatestLastKey(Collection<? extends BasicSeries<K, ?>> collection) {
        Comparable retVal = null;
        Comparable tmpVal = null;
        for (BasicSeries<K, ?> individual : collection) {
            tmpVal = (Comparable)individual.lastKey();
            if (retVal != null && tmpVal.compareTo(retVal) <= 0) continue;
            retVal = tmpVal;
        }
        return (K)retVal;
    }

    public PrimitiveSeries asPrimitive();

    public BasicSeries<K, V> colour(ColourData var1);

    public double doubleValue(K var1);

    public V firstValue();

    @Override
    public V get(K var1);

    public ColourData getColour();

    @Deprecated
    default public DataSeries getDataSeries() {
        return this.asPrimitive().toDataSeries();
    }

    public String getName();

    @Deprecated
    default public PrimitiveSeries getPrimitiveSeries() {
        return this.asPrimitive();
    }

    @Deprecated
    default public double[] getPrimitiveValues() {
        return this.asPrimitive().toRawCopy1D();
    }

    public V lastValue();

    @Deprecated
    default public void modifyAll(UnaryFunction<V> function) {
        this.asPrimitive().loopAll(val -> function.invoke(val));
    }

    public BasicSeries<K, V> name(String var1);

    @Override
    public double put(K var1, double var2);

    @Override
    public V put(K var1, V var2);

    default public void putAll(Collection<? extends KeyValue<? extends K, ? extends V>> data) {
        for (KeyValue<K, V> tmpKeyValue : data) {
            this.put((K)((Comparable)tmpKeyValue.getKey()), (V)((Number)tmpKeyValue.getValue()));
        }
    }

    public static final class TimeSeriesBuilder<K extends Comparable<? super K>> {
        private K myReference = null;
        private CalendarDateDuration myResolution = null;
        private final TimeIndex<K> myTimeIndex;

        TimeSeriesBuilder(TimeIndex<K> timeIndex) {
            this.myTimeIndex = timeIndex;
        }

        public <N extends Number> NaturallySequenced<K, N> build(DenseArray.Factory<N> arrayFactory) {
            Objects.requireNonNull(arrayFactory);
            return this.doBuild(arrayFactory, null);
        }

        public <N extends Number> NaturallySequenced<K, N> build(DenseArray.Factory<N> arrayFactory, BinaryFunction<N> accumularor) {
            Objects.requireNonNull(arrayFactory);
            Objects.requireNonNull(accumularor);
            return this.doBuild(arrayFactory, accumularor);
        }

        public TimeSeriesBuilder<K> reference(K reference) {
            this.myReference = reference;
            return this;
        }

        public TimeSeriesBuilder<K> resolution(CalendarDateDuration resolution) {
            this.myResolution = resolution;
            return this;
        }

        private <N extends Number> NaturallySequenced<K, N> doBuild(DenseArray.Factory<N> arrayFactory, BinaryFunction<N> accumularor) {
            if (this.myReference != null) {
                if (this.myResolution != null) {
                    return new MappedIndexSeries<K, N>(arrayFactory, this.myTimeIndex.from(this.myReference, this.myResolution), accumularor);
                }
                return new MappedIndexSeries<K, N>(arrayFactory, this.myTimeIndex.from(this.myReference), accumularor);
            }
            if (this.myResolution != null) {
                return new MappedIndexSeries<K, N>(arrayFactory, this.myTimeIndex.plain(this.myResolution), accumularor);
            }
            return new MappedIndexSeries<K, N>(arrayFactory, this.myTimeIndex.plain(), accumularor);
        }
    }

    public static interface NaturallySequenced<K extends Comparable<? super K>, V extends Number>
    extends BasicSeries<K, V>,
    Access1D<V> {
        @Override
        default public PrimitiveSeries asPrimitive() {
            return PrimitiveSeries.wrap(this);
        }

        default public void complete() {
            Comparable tmpKey = (Comparable)this.firstKey();
            Object tmpVal = null;
            Object patchVal = this.firstValue();
            Comparable lastKey = (Comparable)this.lastKey();
            while (tmpKey.compareTo(lastKey) <= 0) {
                tmpVal = this.get(tmpKey);
                if (tmpVal != null) {
                    patchVal = tmpVal;
                } else {
                    this.put(tmpKey, patchVal);
                }
                tmpKey = this.step(tmpKey);
            }
        }

        @Override
        default public long count() {
            return this.size();
        }

        public IndexMapper<K> mapper();

        default public K nextKey() {
            return (K)this.step((Comparable)this.lastKey());
        }

        @Override
        public double put(long var1, double var3);

        @Override
        public V put(long var1, V var3);

        public K step(K var1);
    }
}

