/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanKind;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.trace.ConnectionSpanBuilder;
import org.apache.hadoop.hbase.trace.HBaseSemanticAttributes;
import org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class TableSpanBuilder
implements Supplier<Span> {
    private String name;
    private final Map<AttributeKey<?>, Object> attributes = new HashMap();

    public TableSpanBuilder(ClusterConnection conn) {
        ConnectionSpanBuilder.populateConnectionAttributes(this.attributes, conn);
    }

    public TableSpanBuilder(AsyncConnectionImpl conn) {
        ConnectionSpanBuilder.populateConnectionAttributes(this.attributes, conn);
    }

    @Override
    public Span get() {
        return this.build();
    }

    public TableSpanBuilder setName(String name) {
        this.name = name;
        return this;
    }

    public TableSpanBuilder setTableName(TableName tableName) {
        TableSpanBuilder.populateTableNameAttributes(this.attributes, tableName);
        return this;
    }

    public Span build() {
        SpanBuilder builder = TraceUtil.getGlobalTracer().spanBuilder(this.name).setSpanKind(SpanKind.INTERNAL);
        this.attributes.forEach((k, v) -> builder.setAttribute(k, v));
        return builder.startSpan();
    }

    static void populateTableNameAttributes(Map<AttributeKey<?>, Object> attributes, TableName tableName) {
        attributes.put(HBaseSemanticAttributes.DB_NAME, tableName.getNamespaceAsString());
        attributes.put(HBaseSemanticAttributes.TABLE_KEY, tableName.getNameAsString());
    }
}

