/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.common.telemetry;

import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Stack;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Attribute;
import software.amazon.s3.analyticsaccelerator.common.telemetry.Operation;

public final class OperationContext {
    private static final String DEFAULT_OPERATION_NAME = "default";
    final Operation defaultOperation = new Operation("default", "default", new HashMap<String, Attribute>(), this, Optional.empty(), false);
    private final ThreadLocal<Stack<Operation>> operationsStack = ThreadLocal.withInitial(() -> {
        Stack<Operation> stack = new Stack<Operation>();
        stack.push(this.defaultOperation);
        return stack;
    });
    public static final OperationContext DEFAULT = new OperationContext();

    public Operation getCurrentOperation() {
        Stack<Operation> operationsStack = this.operationsStack.get();
        try {
            return operationsStack.peek();
        }
        catch (EmptyStackException exception) {
            throw new IllegalStateException("The operation stack must not be empty", exception);
        }
    }

    public Optional<Operation> getCurrentNonDefaultOperation() {
        Operation currentOperation = this.getCurrentOperation();
        return currentOperation == this.defaultOperation ? Optional.empty() : Optional.of(currentOperation);
    }

    public void pushOperation(@NonNull Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        this.operationsStack.get().push(operation);
    }

    public void popOperation(@NonNull Operation operation) {
        if (operation == null) {
            throw new NullPointerException("operation is marked non-null but is null");
        }
        Stack<Operation> operationsStack = this.operationsStack.get();
        try {
            Operation currentOperation = operationsStack.peek();
            if (currentOperation != operation) {
                throw new IllegalStateException(String.format("The operation `%s` being popped is not equal to the current operation `%s`", operation, currentOperation));
            }
        }
        catch (EmptyStackException exception) {
            throw new IllegalStateException("The operation stack must not be empty", exception);
        }
        operationsStack.pop();
    }
}

