/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hdfs.server.namenode.BlockResolver;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class FixedBlockResolver
extends BlockResolver
implements Configurable {
    public static final String BLOCKSIZE = "hdfs.image.writer.resolver.fixed.block.size";
    public static final String START_BLOCK = "hdfs.image.writer.resolver.fixed.block.start";
    public static final long BLOCKSIZE_DEFAULT = 0x10000000L;
    private Configuration conf;
    private long blocksize = 0x10000000L;
    private final AtomicLong blockIds = new AtomicLong(0L);

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.blocksize = conf.getLong(BLOCKSIZE, 0x10000000L);
        this.blockIds.set(conf.getLong(START_BLOCK, 0x40000000L));
    }

    public Configuration getConf() {
        return this.conf;
    }

    @Override
    protected List<Long> blockLengths(FileStatus s) {
        ArrayList<Long> ret = new ArrayList<Long>();
        if (!s.isFile()) {
            return ret;
        }
        if (0L == s.getLen()) {
            ret.add(0L);
            return ret;
        }
        int nblocks = (int)((s.getLen() - 1L) / this.blocksize) + 1;
        for (int i = 0; i < nblocks - 1; ++i) {
            ret.add(this.blocksize);
        }
        long rem = s.getLen() % this.blocksize;
        ret.add(0L == rem % this.blocksize ? this.blocksize : rem);
        return ret;
    }

    @Override
    public long nextId() {
        return this.blockIds.incrementAndGet();
    }

    @Override
    public long lastId() {
        return this.blockIds.get();
    }

    @Override
    public long preferredBlockSize(FileStatus s) {
        return this.blocksize;
    }

    @Override
    public int getReplication(FileStatus s) {
        return 1;
    }
}

