/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.client.api.AHSClient;
import org.apache.hadoop.yarn.client.api.TimelineReaderClient;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.timeline.TimelineEntityV2Converter;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AHSv2ClientImpl
extends AHSClient {
    private TimelineReaderClient readerClient;
    private String logServerUrl;

    public AHSv2ClientImpl() {
        super(AHSv2ClientImpl.class.getName());
    }

    public void serviceInit(Configuration conf) {
        this.logServerUrl = conf.get("yarn.log.server.url");
        this.readerClient = TimelineReaderClient.createTimelineReaderClient();
        this.readerClient.init(conf);
    }

    @VisibleForTesting
    protected void setReaderClient(TimelineReaderClient readerClient) {
        this.readerClient = readerClient;
    }

    public void serviceStart() {
        this.readerClient.start();
    }

    public void serviceStop() {
        this.readerClient.stop();
    }

    @Override
    public ApplicationReport getApplicationReport(ApplicationId appId) throws YarnException, IOException {
        TimelineEntity entity = this.readerClient.getApplicationEntity(appId, "ALL", null);
        return TimelineEntityV2Converter.convertToApplicationReport((TimelineEntity)entity);
    }

    @Override
    public List<ApplicationReport> getApplications() throws YarnException, IOException {
        throw new UnsupportedOperationException("ATSv2.0 doesn't support retrieving ALL application entities.");
    }

    @Override
    public ApplicationAttemptReport getApplicationAttemptReport(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        TimelineEntity entity = this.readerClient.getApplicationAttemptEntity(applicationAttemptId, "ALL", null);
        return TimelineEntityV2Converter.convertToApplicationAttemptReport((TimelineEntity)entity);
    }

    @Override
    public List<ApplicationAttemptReport> getApplicationAttempts(ApplicationId applicationId) throws YarnException, IOException {
        List entities = this.readerClient.getApplicationAttemptEntities(applicationId, "ALL", null, 0L, null);
        ArrayList<ApplicationAttemptReport> appAttemptReports = new ArrayList<ApplicationAttemptReport>();
        if (entities != null && !entities.isEmpty()) {
            for (TimelineEntity entity : entities) {
                ApplicationAttemptReport container = TimelineEntityV2Converter.convertToApplicationAttemptReport((TimelineEntity)entity);
                appAttemptReports.add(container);
            }
        }
        return appAttemptReports;
    }

    @Override
    public ContainerReport getContainerReport(ContainerId containerId) throws YarnException, IOException {
        ApplicationReport appReport = this.getApplicationReport(containerId.getApplicationAttemptId().getApplicationId());
        TimelineEntity entity = this.readerClient.getContainerEntity(containerId, "ALL", null);
        return TimelineEntityV2Converter.convertToContainerReport((TimelineEntity)entity, (String)this.logServerUrl, (String)appReport.getUser());
    }

    @Override
    public List<ContainerReport> getContainers(ApplicationAttemptId applicationAttemptId) throws YarnException, IOException {
        ApplicationId appId = applicationAttemptId.getApplicationId();
        ApplicationReport appReport = this.getApplicationReport(appId);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("infofilters", "SYSTEM_INFO_PARENT_ENTITY eq {\"type\":\"YARN_APPLICATION_ATTEMPT\",\"id\":\"" + applicationAttemptId + "\"}");
        List entities = this.readerClient.getContainerEntities(appId, "ALL", filters, 0L, null);
        ArrayList<ContainerReport> containers = new ArrayList<ContainerReport>();
        if (entities != null && !entities.isEmpty()) {
            for (TimelineEntity entity : entities) {
                ContainerReport container = TimelineEntityV2Converter.convertToContainerReport((TimelineEntity)entity, (String)this.logServerUrl, (String)appReport.getUser());
                containers.add(container);
            }
        }
        return containers;
    }
}

