/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.federation;

import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.hadoop.hdfs.server.federation.resolver.order.DestinationOrder;
import org.apache.hadoop.hdfs.server.federation.store.records.MountTable;
import org.apache.hadoop.hdfs.tools.federation.RouterAdmin;

public class AddMountAttributes {
    private String mount;
    private String[] nss;
    private String dest;
    private boolean readonly;
    private boolean faultTolerant;
    private DestinationOrder order;
    private RouterAdmin.ACLEntity aclInfo;
    private int paramIndex;

    public String getMount() {
        return this.mount;
    }

    public void setMount(String mount) {
        this.mount = mount;
    }

    public String[] getNss() {
        return this.nss;
    }

    public void setNss(String[] nss) {
        this.nss = nss;
    }

    public String getDest() {
        return this.dest;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public void setReadonly(boolean readonly) {
        this.readonly = readonly;
    }

    public boolean isFaultTolerant() {
        return this.faultTolerant;
    }

    public void setFaultTolerant(boolean faultTolerant) {
        this.faultTolerant = faultTolerant;
    }

    public DestinationOrder getOrder() {
        return this.order;
    }

    public void setOrder(DestinationOrder order) {
        this.order = order;
    }

    public RouterAdmin.ACLEntity getAclInfo() {
        return this.aclInfo;
    }

    public void setAclInfo(RouterAdmin.ACLEntity aclInfo) {
        this.aclInfo = aclInfo;
    }

    public int getParamIndex() {
        return this.paramIndex;
    }

    public void setParamIndex(int paramIndex) {
        this.paramIndex = paramIndex;
    }

    public MountTable getMountTableEntryWithAttributes() throws IOException {
        String normalizedMount = RouterAdmin.normalizeFileSystemPath(this.getMount());
        return this.getMountTableForAddRequest(normalizedMount);
    }

    public MountTable getNewOrUpdatedMountTableEntryWithAttributes(MountTable existingEntry) throws IOException {
        if (existingEntry == null) {
            return this.getMountTableForAddRequest(this.mount);
        }
        for (String nsId : this.getNss()) {
            if (existingEntry.addDestination(nsId, this.getDest())) continue;
            System.err.println("Cannot add destination at " + nsId + " " + this.getDest());
            return null;
        }
        this.updateCommonAttributes(existingEntry);
        return existingEntry;
    }

    private MountTable getMountTableForAddRequest(String mountSrc) throws IOException {
        LinkedHashMap<String, String> destMap = new LinkedHashMap<String, String>();
        for (String ns : this.getNss()) {
            destMap.put(ns, this.getDest());
        }
        MountTable newEntry = MountTable.newInstance(mountSrc, destMap);
        this.updateCommonAttributes(newEntry);
        return newEntry;
    }

    private void updateCommonAttributes(MountTable existingEntry) {
        RouterAdmin.ACLEntity mountAclInfo;
        if (this.isReadonly()) {
            existingEntry.setReadOnly(true);
        }
        if (this.isFaultTolerant()) {
            existingEntry.setFaultTolerant(true);
        }
        if (this.getOrder() != null) {
            existingEntry.setDestOrder(this.getOrder());
        }
        if ((mountAclInfo = this.getAclInfo()).getOwner() != null) {
            existingEntry.setOwnerName(mountAclInfo.getOwner());
        }
        if (mountAclInfo.getGroup() != null) {
            existingEntry.setGroupName(mountAclInfo.getGroup());
        }
        if (mountAclInfo.getMode() != null) {
            existingEntry.setMode(mountAclInfo.getMode());
        }
        existingEntry.validate();
    }
}

