/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.submarine.common.api.builder;

import java.util.ArrayList;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.Service;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.submarine.common.api.JobComponentStatus;
import org.apache.hadoop.yarn.submarine.common.api.JobState;
import org.apache.hadoop.yarn.submarine.common.api.JobStatus;
import org.apache.hadoop.yarn.submarine.common.api.builder.JobComponentStatusBuilder;

public class JobStatusBuilder {
    public static JobStatus fromServiceSpec(Service serviceSpec) {
        JobStatus status = new JobStatus();
        status.setState(JobStatusBuilder.fromServiceState(serviceSpec.getState()));
        if (JobState.isFinal(status.getState())) {
            return status;
        }
        ArrayList<JobComponentStatus> componentStatusList = new ArrayList<JobComponentStatus>();
        for (Component component : serviceSpec.getComponents()) {
            componentStatusList.add(JobComponentStatusBuilder.fromServiceComponent(component));
        }
        status.setComponentStatus(componentStatusList);
        status.setJobName(serviceSpec.getName());
        return status;
    }

    private static JobState fromServiceState(ServiceState serviceState) {
        switch (serviceState) {
            case STOPPED: {
                return JobState.SUCCEEDED;
            }
            case FAILED: {
                return JobState.FAILED;
            }
        }
        return JobState.RUNNING;
    }
}

