/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azure;

import com.google.common.annotations.VisibleForTesting;
import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlob;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.azure.StorageInterface;

public class SelfRenewingLease {
    private StorageInterface.CloudBlobWrapper blobWrapper;
    private Thread renewer;
    private volatile boolean leaseFreed = false;
    private String leaseID = null;
    private static final int LEASE_TIMEOUT = 60;
    public static final int LEASE_RENEWAL_PERIOD = 40000;
    private static final Log LOG = LogFactory.getLog(SelfRenewingLease.class);
    private static AtomicInteger threadNumber = new AtomicInteger(0);
    @VisibleForTesting
    static final int LEASE_ACQUIRE_RETRY_INTERVAL = 2000;

    public SelfRenewingLease(StorageInterface.CloudBlobWrapper blobWrapper, boolean throwIfPresent) throws StorageException {
        this.blobWrapper = blobWrapper;
        CloudBlob blob = blobWrapper.getBlob();
        while (this.leaseID == null) {
            block6: {
                try {
                    this.leaseID = blob.acquireLease(Integer.valueOf(60), null);
                }
                catch (StorageException e) {
                    if (throwIfPresent && e.getErrorCode().equals("LeaseAlreadyPresent")) {
                        throw e;
                    }
                    if ("LeaseAlreadyPresent".equals(e.getErrorCode())) break block6;
                    LOG.info((Object)("Caught exception when trying to get lease on blob " + blobWrapper.getUri().toString() + ". " + e.getMessage()));
                    throw e;
                }
            }
            if (this.leaseID != null) continue;
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.renewer = new Thread(new Renewer());
        this.renewer.setDaemon(true);
        this.renewer.setName("AzureLeaseRenewer-" + threadNumber.getAndIncrement());
        this.renewer.start();
        LOG.debug((Object)("Acquired lease " + this.leaseID + " on " + blob.getUri() + " managed by thread " + this.renewer.getName()));
    }

    public void free() throws StorageException {
        block6: {
            AccessCondition accessCondition = AccessCondition.generateEmptyCondition();
            accessCondition.setLeaseID(this.leaseID);
            try {
                this.blobWrapper.getBlob().releaseLease(accessCondition);
            }
            catch (StorageException e) {
                if ("BlobNotFound".equals(e.getErrorCode())) {
                    break block6;
                }
                LOG.warn((Object)("Unanticipated exception when trying to free lease " + this.leaseID + " on " + this.blobWrapper.getStorageUri()));
                throw e;
            }
            finally {
                this.leaseFreed = true;
                LOG.debug((Object)("Freed lease " + this.leaseID + " on " + this.blobWrapper.getUri() + " managed by thread " + this.renewer.getName()));
            }
        }
    }

    public boolean isFreed() {
        return this.leaseFreed;
    }

    public String getLeaseID() {
        return this.leaseID;
    }

    public CloudBlob getCloudBlob() {
        return this.blobWrapper.getBlob();
    }

    private class Renewer
    implements Runnable {
        private Renewer() {
        }

        @Override
        public void run() {
            LOG.debug((Object)"Starting lease keep-alive thread.");
            AccessCondition accessCondition = AccessCondition.generateEmptyCondition();
            accessCondition.setLeaseID(SelfRenewingLease.this.leaseID);
            while (!SelfRenewingLease.this.leaseFreed) {
                try {
                    Thread.sleep(40000L);
                }
                catch (InterruptedException e) {
                    LOG.debug((Object)("Keep-alive thread for lease " + SelfRenewingLease.this.leaseID + " interrupted."));
                    Thread.currentThread().interrupt();
                }
                try {
                    if (SelfRenewingLease.this.leaseFreed) continue;
                    SelfRenewingLease.this.blobWrapper.getBlob().renewLease(accessCondition);
                    LOG.info((Object)("Renewed lease " + SelfRenewingLease.this.leaseID + " on " + SelfRenewingLease.this.getCloudBlob().getUri()));
                }
                catch (StorageException e) {
                    if (SelfRenewingLease.this.leaseFreed) continue;
                    SelfRenewingLease.this.leaseFreed = true;
                    LOG.warn((Object)("Attempt to renew lease " + SelfRenewingLease.this.leaseID + " on " + SelfRenewingLease.this.getCloudBlob().getUri() + " failed, but lease not yet freed. Reason: " + e.getMessage()));
                }
            }
        }
    }
}

