/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RMWebAppUtil;
import org.apache.hadoop.yarn.server.router.clientrm.RouterClientRMService;
import org.apache.hadoop.yarn.server.router.rmadmin.RouterRMAdminService;
import org.apache.hadoop.yarn.server.router.webapp.RouterWebApp;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Router
extends CompositeService {
    private static final Logger LOG = LoggerFactory.getLogger(Router.class);
    private static CompositeService.CompositeServiceShutdownHook routerShutdownHook;
    private Configuration conf;
    private AtomicBoolean isStopping = new AtomicBoolean(false);
    private RouterClientRMService clientRMProxyService;
    private RouterRMAdminService rmAdminProxyService;
    private WebApp webApp;
    @VisibleForTesting
    protected String webAppAddress;
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final String METRICS_NAME = "Router";

    public Router() {
        super(Router.class.getName());
    }

    protected void doSecureLogin() throws IOException {
    }

    protected void serviceInit(Configuration config) throws Exception {
        this.conf = config;
        this.clientRMProxyService = this.createClientRMProxyService();
        this.addService((Service)this.clientRMProxyService);
        this.rmAdminProxyService = this.createRMAdminProxyService();
        this.addService((Service)this.rmAdminProxyService);
        this.webAppAddress = WebAppUtils.getWebAppBindURL((Configuration)this.conf, (String)"yarn.router.bind-host", (String)WebAppUtils.getRouterWebAppURLWithoutScheme((Configuration)this.conf));
        DefaultMetricsSystem.initialize((String)METRICS_NAME);
        super.serviceInit(this.conf);
    }

    protected void serviceStart() throws Exception {
        try {
            this.doSecureLogin();
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed Router login", (Throwable)e);
        }
        this.startWepApp();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.webApp != null) {
            this.webApp.stop();
        }
        if (this.isStopping.getAndSet(true)) {
            return;
        }
        super.serviceStop();
        DefaultMetricsSystem.shutdown();
    }

    protected void shutDown() {
        new Thread(){

            @Override
            public void run() {
                Router.this.stop();
            }
        }.start();
    }

    protected RouterClientRMService createClientRMProxyService() {
        return new RouterClientRMService();
    }

    protected RouterRMAdminService createRMAdminProxyService() {
        return new RouterRMAdminService();
    }

    @InterfaceAudience.Private
    public WebApp getWebapp() {
        return this.webApp;
    }

    @VisibleForTesting
    public void startWepApp() {
        RMWebAppUtil.setupSecurityAndFilters((Configuration)this.conf, null);
        WebApps.Builder builder = WebApps.$for((String)"cluster", null, null, (String)"ws").with(this.conf).at(this.webAppAddress);
        this.webApp = builder.start((WebApp)new RouterWebApp(this));
    }

    public static void main(String[] argv) {
        YarnConfiguration conf = new YarnConfiguration();
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(Router.class, (String[])argv, (Logger)LOG);
        Router router = new Router();
        try {
            if (null != routerShutdownHook) {
                ShutdownHookManager.get().removeShutdownHook((Runnable)routerShutdownHook);
            }
            routerShutdownHook = new CompositeService.CompositeServiceShutdownHook((CompositeService)router);
            ShutdownHookManager.get().addShutdownHook((Runnable)routerShutdownHook, 30);
            router.init((Configuration)conf);
            router.start();
        }
        catch (Throwable t) {
            LOG.error("Error starting Router", t);
            System.exit(-1);
        }
    }
}

