/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import java.util.Objects;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.service.api.records.Artifact;
import org.apache.hadoop.yarn.service.api.records.BaseResource;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.Resource;

@InterfaceAudience.Public
@InterfaceStability.Unstable
@ApiModel(description="An instance of a running service container")
@XmlRootElement
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Container
extends BaseResource {
    private static final long serialVersionUID = -8955788064529288L;
    private String id = null;
    private Date launchTime = null;
    private String ip = null;
    private String hostname = null;
    private String bareHost = null;
    private ContainerState state = null;
    private String componentInstanceName = null;
    private Resource resource = null;
    private Artifact artifact = null;
    private Boolean privilegedContainer = null;

    public Container id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="null", value="Unique container id of a running service, e.g. container_e3751_1458061340047_0008_01_000002.")
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Container launchTime(Date launchTime) {
        this.launchTime = launchTime == null ? null : (Date)launchTime.clone();
        return this;
    }

    @ApiModelProperty(example="null", value="The time when the container was created, e.g. 2016-03-16T01:01:49.000Z. This will most likely be different from cluster launch time.")
    @JsonProperty(value="launch_time")
    public Date getLaunchTime() {
        return this.launchTime == null ? null : (Date)this.launchTime.clone();
    }

    @XmlElement(name="launch_time")
    public void setLaunchTime(Date launchTime) {
        this.launchTime = launchTime == null ? null : (Date)launchTime.clone();
    }

    public Container ip(String ip) {
        this.ip = ip;
        return this;
    }

    @ApiModelProperty(example="null", value="IP address of a running container, e.g. 172.31.42.141. The IP address and hostname attribute values are dependent on the cluster/docker network setup as per YARN-4007.")
    @JsonProperty(value="ip")
    public String getIp() {
        return this.ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public Container hostname(String hostname) {
        this.hostname = hostname;
        return this;
    }

    @ApiModelProperty(example="null", value="Fully qualified hostname of a running container, e.g. ctr-e3751-1458061340047-0008-01-000002.examplestg.site. The IP address and hostname attribute values are dependent on the cluster/docker network setup as per YARN-4007.")
    @JsonProperty(value="hostname")
    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public Container bareHost(String bareHost) {
        this.bareHost = bareHost;
        return this;
    }

    @ApiModelProperty(example="null", value="The bare node or host in which the container is running, e.g. cn008.example.com.")
    @JsonProperty(value="bare_host")
    public String getBareHost() {
        return this.bareHost;
    }

    @XmlElement(name="bare_host")
    public void setBareHost(String bareHost) {
        this.bareHost = bareHost;
    }

    public Container state(ContainerState state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(example="null", value="State of the container of an service.")
    @JsonProperty(value="state")
    public ContainerState getState() {
        return this.state;
    }

    public void setState(ContainerState state) {
        this.state = state;
    }

    public Container componentInstanceName(String componentInstanceName) {
        this.componentInstanceName = componentInstanceName;
        return this;
    }

    @ApiModelProperty(example="null", value="Name of the component instance that this container instance belongs to.")
    @JsonProperty(value="component_instance_name")
    public String getComponentInstanceName() {
        return this.componentInstanceName;
    }

    @XmlElement(name="component_instance_name")
    public void setComponentInstanceName(String componentInstanceName) {
        this.componentInstanceName = componentInstanceName;
    }

    public Container resource(Resource resource) {
        this.resource = resource;
        return this;
    }

    @ApiModelProperty(example="null", value="Resource used for this container.")
    @JsonProperty(value="resource")
    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Container artifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    @ApiModelProperty(example="null", value="Artifact used for this container.")
    @JsonProperty(value="artifact")
    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(Artifact artifact) {
        this.artifact = artifact;
    }

    public Container privilegedContainer(Boolean privilegedContainer) {
        this.privilegedContainer = privilegedContainer;
        return this;
    }

    @ApiModelProperty(example="null", value="Container running in privileged mode or not.")
    @JsonProperty(value="privileged_container")
    public Boolean getPrivilegedContainer() {
        return this.privilegedContainer;
    }

    public void setPrivilegedContainer(Boolean privilegedContainer) {
        this.privilegedContainer = privilegedContainer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Container container = (Container)o;
        return Objects.equals(this.id, container.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Container {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    launchTime: ").append(this.toIndentedString(this.launchTime)).append("\n");
        sb.append("    ip: ").append(this.toIndentedString(this.ip)).append("\n");
        sb.append("    hostname: ").append(this.toIndentedString(this.hostname)).append("\n");
        sb.append("    bareHost: ").append(this.toIndentedString(this.bareHost)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    componentInstanceName: ").append(this.toIndentedString(this.componentInstanceName)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    artifact: ").append(this.toIndentedString(this.artifact)).append("\n");
        sb.append("    privilegedContainer: ").append(this.toIndentedString(this.privilegedContainer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

