/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedExceptionAction;
import java.text.MessageFormat;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.util.KerberosUtil;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.client.api.AppAdminClient;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.service.api.records.Component;
import org.apache.hadoop.yarn.service.api.records.ComponentState;
import org.apache.hadoop.yarn.service.api.records.Container;
import org.apache.hadoop.yarn.service.api.records.ContainerState;
import org.apache.hadoop.yarn.service.api.records.ServiceState;
import org.apache.hadoop.yarn.service.api.records.ServiceStatus;
import org.apache.hadoop.yarn.service.client.ServiceClient;
import org.apache.hadoop.yarn.service.utils.ServiceApiUtil;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.eclipse.jetty.util.UrlEncoded;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApiServiceClient
extends AppAdminClient {
    private static final Logger LOG = LoggerFactory.getLogger(ApiServiceClient.class);
    private static final Base64 BASE_64_CODEC = new Base64(0);
    protected YarnClient yarnClient;

    protected void serviceInit(Configuration configuration) throws Exception {
        this.yarnClient = YarnClient.createYarnClient();
        this.addService((Service)this.yarnClient);
        super.serviceInit(configuration);
    }

    String generateToken(final String server) throws IOException, InterruptedException {
        UserGroupInformation currentUser = UserGroupInformation.getCurrentUser();
        LOG.debug("The user credential is {}", (Object)currentUser);
        String challenge = (String)currentUser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<String>(){

            @Override
            public String run() throws Exception {
                try {
                    Oid mechOid = KerberosUtil.getOidInstance((String)"GSS_KRB5_MECH_OID");
                    GSSManager manager = GSSManager.getInstance();
                    GSSName serverName = manager.createName("HTTP@" + server, GSSName.NT_HOSTBASED_SERVICE);
                    GSSContext gssContext = manager.createContext(serverName.canonicalize(mechOid), mechOid, null, 0);
                    gssContext.requestMutualAuth(true);
                    gssContext.requestCredDeleg(true);
                    byte[] inToken = new byte[]{};
                    byte[] outToken = gssContext.initSecContext(inToken, 0, inToken.length);
                    gssContext.dispose();
                    LOG.debug("Got valid challenge for host {}", (Object)serverName);
                    return new String(BASE_64_CODEC.encode(outToken), StandardCharsets.US_ASCII);
                }
                catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException | GSSException e) {
                    LOG.error("Error: {}", (Throwable)e);
                    throw new AuthenticationException((Throwable)e);
                }
            }
        });
        return challenge;
    }

    String getRMWebAddress() {
        Configuration conf = this.getConfig();
        String scheme = "http://";
        String path = "/app/v1/services/version";
        String rmAddress = conf.get("yarn.resourcemanager.webapp.address");
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            scheme = "https://";
            rmAddress = conf.get("yarn.resourcemanager.webapp.https.address");
        }
        boolean useKerberos = UserGroupInformation.isSecurityEnabled();
        List<String> rmServers = this.getRMHAWebAddresses(conf);
        for (String host : rmServers) {
            try {
                ClientResponse test;
                Client client = Client.create();
                client.setFollowRedirects(Boolean.valueOf(false));
                StringBuilder sb = new StringBuilder();
                sb.append(scheme);
                sb.append(host);
                sb.append(path);
                if (!useKerberos) {
                    try {
                        String username = UserGroupInformation.getCurrentUser().getShortUserName();
                        sb.append("?user.name=");
                        sb.append(username);
                    }
                    catch (IOException e) {
                        LOG.debug("Fail to resolve username: {}", (Throwable)e);
                    }
                }
                WebResource.Builder builder = client.resource(sb.toString()).type("application/json");
                if (useKerberos) {
                    String[] server = host.split(":");
                    String challenge = this.generateToken(server[0]);
                    builder.header("Authorization", (Object)("Negotiate " + challenge));
                    LOG.debug("Authorization: Negotiate {}", (Object)challenge);
                }
                if ((test = (ClientResponse)builder.get(ClientResponse.class)).getStatus() != 200) continue;
                rmAddress = host;
                break;
            }
            catch (Exception e) {
                LOG.info("Fail to connect to: " + host);
                LOG.debug("Root cause: {}", (Throwable)e);
            }
        }
        return scheme + rmAddress;
    }

    List<String> getRMHAWebAddresses(Configuration conf) {
        return RMHAUtils.getRMHAWebappAddresses((YarnConfiguration)new YarnConfiguration(conf));
    }

    private String getServicePath(String appName) throws IOException {
        String url = this.getRMWebAddress();
        StringBuilder api = new StringBuilder();
        api.append(url);
        api.append("/app/v1/services");
        if (appName != null) {
            api.append("/");
            api.append(appName);
        }
        this.appendUserNameIfRequired(api);
        return api.toString();
    }

    private String getInstancesPath(String appName) throws IOException {
        Preconditions.checkNotNull((Object)appName);
        String url = this.getRMWebAddress();
        StringBuilder api = new StringBuilder();
        api.append(url);
        api.append("/app/v1/services/").append(appName).append("/").append("component-instances");
        this.appendUserNameIfRequired(api);
        return api.toString();
    }

    private String getInstancePath(String appName, List<String> components, String version, List<String> containerStates) throws IOException {
        UriBuilder builder = UriBuilder.fromUri((String)this.getInstancesPath(appName));
        if (components != null && !components.isEmpty()) {
            components.forEach(compName -> builder.queryParam("componentName", new Object[]{compName}));
        }
        if (!Strings.isNullOrEmpty((String)version)) {
            builder.queryParam("version", new Object[]{version});
        }
        if (containerStates != null && !containerStates.isEmpty()) {
            containerStates.forEach(state -> builder.queryParam("containerState", new Object[]{state}));
        }
        return builder.build(new Object[0]).toString();
    }

    private String getComponentsPath(String appName) throws IOException {
        Preconditions.checkNotNull((Object)appName);
        String url = this.getRMWebAddress();
        StringBuilder api = new StringBuilder();
        api.append(url);
        api.append("/app/v1/services/").append(appName).append("/").append("components");
        this.appendUserNameIfRequired(api);
        return api.toString();
    }

    private void appendUserNameIfRequired(StringBuilder builder) {
        Configuration conf = this.getConfig();
        if (conf.get("hadoop.http.authentication.type").equalsIgnoreCase("simple")) {
            builder.append("?user.name=").append(UrlEncoded.encodeString((String)System.getProperty("user.name")));
        }
    }

    private WebResource.Builder getApiClient() throws IOException {
        return this.getApiClient(this.getServicePath(null));
    }

    private WebResource.Builder getApiClient(String requestPath) throws IOException {
        Client client = Client.create((ClientConfig)this.getClientConfig());
        client.setChunkedEncodingSize(null);
        WebResource.Builder builder = client.resource(requestPath).type("application/json");
        if (UserGroupInformation.isSecurityEnabled()) {
            try {
                URI url = new URI(requestPath);
                String challenge = this.generateToken(url.getHost());
                builder.header("Authorization", (Object)("Negotiate " + challenge));
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        return (WebResource.Builder)builder.accept(new String[]{"application/json;charset=utf-8"});
    }

    private ClientConfig getClientConfig() {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getProperties().put("com.sun.jersey.client.property.chunkedEncodingSize", 0);
        config.getProperties().put("com.sun.jersey.client.property.bufferResponseEntityOnException", true);
        return config;
    }

    private int processResponse(ClientResponse response) {
        String output;
        response.bufferEntity();
        if (response.getStatus() == 401) {
            LOG.error("Authentication required");
            return 56;
        }
        if (response.getStatus() == 503) {
            LOG.error("YARN Service is unavailable or disabled.");
            return 56;
        }
        try {
            ServiceStatus ss = (ServiceStatus)response.getEntity(ServiceStatus.class);
            output = ss.getDiagnostics();
        }
        catch (Throwable t) {
            output = (String)response.getEntity(String.class);
        }
        if (output == null) {
            output = (String)response.getEntity(String.class);
        }
        if (response.getStatus() <= 299) {
            LOG.info(output);
            return 0;
        }
        LOG.error(output);
        return 56;
    }

    public org.apache.hadoop.yarn.service.api.records.Service loadAppJsonFromLocalFS(String fileName, String serviceName, Long lifetime, String queue) throws IOException, YarnException {
        File file = new File(fileName);
        if (!file.exists() && fileName.equals(file.getName())) {
            String dir;
            String[] examplesDirs;
            String examplesDirStr = System.getenv("YARN_SERVICE_EXAMPLES_DIR");
            if (examplesDirStr == null) {
                String yarnHome = System.getenv(ApplicationConstants.Environment.HADOOP_YARN_HOME.key());
                examplesDirs = new String[]{yarnHome + "/share/hadoop/yarn/yarn-service-examples", yarnHome + "/yarn-service-examples"};
            } else {
                examplesDirs = StringUtils.split((String)examplesDirStr, (String)":");
            }
            String[] stringArray = examplesDirs;
            int n = stringArray.length;
            for (int i = 0; i < n && !(file = new File(MessageFormat.format("{0}/{1}/{2}.json", dir = stringArray[i], fileName, fileName))).exists() && !(file = new File(MessageFormat.format("{0}/{1}.json", dir, fileName))).exists(); ++i) {
            }
        }
        if (!file.exists()) {
            throw new YarnException("File or example could not be found: " + fileName);
        }
        Path filePath = new Path(file.getAbsolutePath());
        LOG.info("Loading service definition from local FS: " + filePath);
        org.apache.hadoop.yarn.service.api.records.Service service = (org.apache.hadoop.yarn.service.api.records.Service)ServiceApiUtil.jsonSerDeser.load((FileSystem)FileSystem.getLocal((Configuration)this.getConfig()), filePath);
        if (!StringUtils.isEmpty((CharSequence)serviceName)) {
            service.setName(serviceName);
        }
        if (lifetime != null && lifetime > 0L) {
            service.setLifetime(lifetime);
        }
        if (!StringUtils.isEmpty((CharSequence)queue)) {
            service.setQueue(queue);
        }
        return service;
    }

    public int actionLaunch(String fileName, String appName, Long lifetime, String queue) throws IOException, YarnException {
        int result = 0;
        try {
            org.apache.hadoop.yarn.service.api.records.Service service = this.loadAppJsonFromLocalFS(fileName, appName, lifetime, queue);
            String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
            ClientResponse response = (ClientResponse)this.getApiClient().post(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Fail to launch application: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int actionStop(String appName) throws IOException, YarnException {
        int result = 0;
        try {
            org.apache.hadoop.yarn.service.api.records.Service service = new org.apache.hadoop.yarn.service.api.records.Service();
            service.setName(appName);
            service.setState(ServiceState.STOPPED);
            String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
            ClientResponse response = (ClientResponse)this.getApiClient(this.getServicePath(appName)).put(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Fail to stop application: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int actionStart(String appName) throws IOException, YarnException {
        int result = 0;
        try {
            org.apache.hadoop.yarn.service.api.records.Service service = new org.apache.hadoop.yarn.service.api.records.Service();
            service.setName(appName);
            service.setState(ServiceState.STARTED);
            String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
            ClientResponse response = (ClientResponse)this.getApiClient(this.getServicePath(appName)).put(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Fail to start application: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int actionSave(String fileName, String appName, Long lifetime, String queue) throws IOException, YarnException {
        int result = 0;
        try {
            org.apache.hadoop.yarn.service.api.records.Service service = this.loadAppJsonFromLocalFS(fileName, appName, lifetime, queue);
            service.setState(ServiceState.STOPPED);
            String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
            ClientResponse response = (ClientResponse)this.getApiClient().post(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Fail to save application: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int actionDestroy(String appName) throws IOException, YarnException {
        int result = 0;
        try {
            ClientResponse response = (ClientResponse)this.getApiClient(this.getServicePath(appName)).delete(ClientResponse.class);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Fail to destroy application: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int actionFlex(String appName, Map<String, String> componentCounts) throws IOException, YarnException {
        int result = 0;
        try {
            org.apache.hadoop.yarn.service.api.records.Service service = new org.apache.hadoop.yarn.service.api.records.Service();
            service.setName(appName);
            service.setState(ServiceState.FLEX);
            for (Map.Entry<String, String> entry : componentCounts.entrySet()) {
                Component component = new Component();
                component.setName(entry.getKey());
                Long numberOfContainers = Long.parseLong(entry.getValue());
                component.setNumberOfContainers(numberOfContainers);
                service.addComponent(component);
            }
            String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
            ClientResponse response = (ClientResponse)this.getApiClient(this.getServicePath(appName)).put(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Fail to flex application: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int enableFastLaunch(String destinationFolder) throws IOException, YarnException {
        ServiceClient sc = new ServiceClient();
        sc.init(this.getConfig());
        sc.start();
        int result = sc.enableFastLaunch(destinationFolder);
        sc.close();
        return result;
    }

    public String getStatusString(String appIdOrName) throws IOException, YarnException {
        String appName;
        String output = "";
        try {
            ApplicationId appId = ApplicationId.fromString((String)appIdOrName);
            ApplicationReport appReport = this.yarnClient.getApplicationReport(appId);
            appName = appReport.getName();
        }
        catch (IllegalArgumentException e) {
            appName = appIdOrName;
            ServiceApiUtil.validateNameFormat((String)appName, (Configuration)this.getConfig());
        }
        try {
            StringBuilder sb;
            ClientResponse response = (ClientResponse)this.getApiClient(this.getServicePath(appName)).get(ClientResponse.class);
            if (response.getStatus() == 404) {
                sb = new StringBuilder();
                sb.append(" Service ");
                sb.append(appName);
                sb.append(" not found");
                return sb.toString();
            }
            if (response.getStatus() != 200) {
                sb = new StringBuilder();
                sb.append(appName);
                sb.append(" Failed : HTTP error code : ");
                sb.append(response.getStatus());
                return sb.toString();
            }
            output = (String)response.getEntity(String.class);
        }
        catch (Exception e) {
            LOG.error("Fail to check application status: ", (Throwable)e);
        }
        return output;
    }

    public int actionUpgradeExpress(String appName, File path) throws IOException, YarnException {
        int result;
        try {
            org.apache.hadoop.yarn.service.api.records.Service service = this.loadAppJsonFromLocalFS(path.getAbsolutePath(), appName, null, null);
            service.setState(ServiceState.EXPRESS_UPGRADING);
            String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
            LOG.info("Upgrade in progress. Please wait..");
            ClientResponse response = (ClientResponse)this.getApiClient(this.getServicePath(appName)).put(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Failed to upgrade application: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int initiateUpgrade(String appName, String fileName, boolean autoFinalize) throws IOException, YarnException {
        int result;
        try {
            org.apache.hadoop.yarn.service.api.records.Service service = this.loadAppJsonFromLocalFS(fileName, appName, null, null);
            if (autoFinalize) {
                service.setState(ServiceState.UPGRADING_AUTO_FINALIZE);
            } else {
                service.setState(ServiceState.UPGRADING);
            }
            String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
            ClientResponse response = (ClientResponse)this.getApiClient(this.getServicePath(appName)).put(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Failed to upgrade application: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int actionUpgradeInstances(String appName, List<String> compInstances) throws IOException, YarnException {
        int result;
        Container[] toUpgrade = new Container[compInstances.size()];
        try {
            int idx = 0;
            for (String instanceName : compInstances) {
                Container container = new Container();
                container.setComponentInstanceName(instanceName);
                container.setState(ContainerState.UPGRADING);
                toUpgrade[idx++] = container;
            }
            String buffer = ServiceApiUtil.CONTAINER_JSON_SERDE.toJson((Object)toUpgrade);
            ClientResponse response = (ClientResponse)this.getApiClient(this.getInstancesPath(appName)).put(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Failed to upgrade component instance: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int actionUpgradeComponents(String appName, List<String> components) throws IOException, YarnException {
        int result;
        Component[] toUpgrade = new Component[components.size()];
        try {
            int idx = 0;
            for (String compName : components) {
                Component component = new Component();
                component.setName(compName);
                component.setState(ComponentState.UPGRADING);
                toUpgrade[idx++] = component;
            }
            String buffer = ServiceApiUtil.COMP_JSON_SERDE.toJson((Object)toUpgrade);
            ClientResponse response = (ClientResponse)this.getApiClient(this.getComponentsPath(appName)).put(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Failed to upgrade components: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int actionCleanUp(String appName, String userName) throws IOException, YarnException {
        ServiceClient sc = new ServiceClient();
        sc.init(this.getConfig());
        sc.start();
        int result = sc.actionCleanUp(appName, userName);
        sc.close();
        return result;
    }

    public String getInstances(String appName, List<String> components, String version, List<String> containerStates) throws IOException, YarnException {
        try {
            String uri = this.getInstancePath(appName, components, version, containerStates);
            ClientResponse response = (ClientResponse)this.getApiClient(uri).get(ClientResponse.class);
            if (response.getStatus() != 200) {
                StringBuilder sb = new StringBuilder();
                sb.append("Failed: HTTP error code: ");
                sb.append(response.getStatus());
                sb.append(" ErrorMsg: ").append((String)response.getEntity(String.class));
                return sb.toString();
            }
            return (String)response.getEntity(String.class);
        }
        catch (Exception e) {
            LOG.error("Fail to get containers {}", (Throwable)e);
            return null;
        }
    }

    public int actionCancelUpgrade(String appName) throws IOException, YarnException {
        int result;
        try {
            org.apache.hadoop.yarn.service.api.records.Service service = new org.apache.hadoop.yarn.service.api.records.Service();
            service.setName(appName);
            service.setState(ServiceState.CANCEL_UPGRADING);
            String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
            LOG.info("Cancel upgrade in progress. Please wait..");
            ClientResponse response = (ClientResponse)this.getApiClient(this.getServicePath(appName)).put(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Failed to cancel upgrade: ", (Throwable)e);
            result = 56;
        }
        return result;
    }

    public int actionDecommissionInstances(String appName, List<String> componentInstances) throws IOException, YarnException {
        int result = 0;
        try {
            org.apache.hadoop.yarn.service.api.records.Service service = new org.apache.hadoop.yarn.service.api.records.Service();
            service.setName(appName);
            for (String instance : componentInstances) {
                String componentName = ServiceApiUtil.parseComponentName((String)instance);
                Component component = service.getComponent(componentName);
                if (component == null) {
                    component = new Component();
                    component.setName(componentName);
                    service.addComponent(component);
                }
                component.addDecommissionedInstance(instance);
            }
            String buffer = ServiceApiUtil.jsonSerDeser.toJson((Object)service);
            ClientResponse response = (ClientResponse)this.getApiClient(this.getServicePath(appName)).put(ClientResponse.class, (Object)buffer);
            result = this.processResponse(response);
        }
        catch (Exception e) {
            LOG.error("Fail to decommission instance: ", (Throwable)e);
            result = 56;
        }
        return result;
    }
}

