/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.join;

import java.io.IOException;
import java.util.PriorityQueue;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.join.ComposableRecordReader;
import org.apache.hadoop.mapred.join.CompositeRecordReader;
import org.apache.hadoop.mapred.join.ResetableIterator;
import org.apache.hadoop.mapred.join.TupleWritable;

@InterfaceAudience.Public
@InterfaceStability.Stable
public abstract class JoinRecordReader<K extends WritableComparable>
extends CompositeRecordReader<K, Writable, TupleWritable>
implements ComposableRecordReader<K, TupleWritable> {
    public JoinRecordReader(int id, JobConf conf, int capacity, Class<? extends WritableComparator> cmpcl) throws IOException {
        super(id, capacity, cmpcl);
        this.setConf(conf);
    }

    @Override
    public boolean next(K key, TupleWritable value) throws IOException {
        if (this.jc.flush(value)) {
            WritableUtils.cloneInto(key, this.jc.key());
            return true;
        }
        this.jc.clear();
        Object iterkey = this.createKey();
        PriorityQueue q = this.getRecordReaderQueue();
        while (!q.isEmpty()) {
            this.fillJoinCollector(iterkey);
            this.jc.reset(iterkey);
            if (this.jc.flush(value)) {
                WritableUtils.cloneInto(key, this.jc.key());
                return true;
            }
            this.jc.clear();
        }
        return false;
    }

    @Override
    public TupleWritable createValue() {
        return this.createInternalValue();
    }

    @Override
    protected ResetableIterator<TupleWritable> getDelegate() {
        return new JoinDelegationIterator();
    }

    protected class JoinDelegationIterator
    implements ResetableIterator<TupleWritable> {
        protected JoinDelegationIterator() {
        }

        @Override
        public boolean hasNext() {
            return JoinRecordReader.this.jc.hasNext();
        }

        @Override
        public boolean next(TupleWritable val) throws IOException {
            return JoinRecordReader.this.jc.flush(val);
        }

        @Override
        public boolean replay(TupleWritable val) throws IOException {
            return JoinRecordReader.this.jc.replay(val);
        }

        @Override
        public void reset() {
            JoinRecordReader.this.jc.reset(JoinRecordReader.this.jc.key());
        }

        @Override
        public void add(TupleWritable item) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void close() throws IOException {
            JoinRecordReader.this.jc.close();
        }

        @Override
        public void clear() {
            JoinRecordReader.this.jc.clear();
        }
    }
}

