/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.security;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenIdentifier;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSecretManager;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.Recoverable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RMDelegationTokenSecretManager
extends AbstractDelegationTokenSecretManager<RMDelegationTokenIdentifier>
implements Recoverable {
    private static final Logger LOG = LoggerFactory.getLogger(RMDelegationTokenSecretManager.class);
    private final ResourceManager rm;

    public RMDelegationTokenSecretManager(long delegationKeyUpdateInterval, long delegationTokenMaxLifetime, long delegationTokenRenewInterval, long delegationTokenRemoverScanInterval, RMContext rmContext) {
        super(delegationKeyUpdateInterval, delegationTokenMaxLifetime, delegationTokenRenewInterval, delegationTokenRemoverScanInterval);
        this.rm = rmContext.getResourceManager();
    }

    public RMDelegationTokenIdentifier createIdentifier() {
        return new RMDelegationTokenIdentifier();
    }

    private boolean shouldIgnoreException(Exception e) {
        return !this.running && e.getCause() instanceof InterruptedException;
    }

    protected void storeNewMasterKey(DelegationKey newKey) {
        block2: {
            try {
                LOG.info("storing master key with keyID " + newKey.getKeyId());
                this.rm.getRMContext().getStateStore().storeRMDTMasterKey(newKey);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in storing master key with KeyID: " + newKey.getKeyId());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    protected void removeStoredMasterKey(DelegationKey key) {
        block2: {
            try {
                LOG.info("removing master key with keyID " + key.getKeyId());
                this.rm.getRMContext().getStateStore().removeRMDTMasterKey(key);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in removing master key with KeyID: " + key.getKeyId());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    protected void storeNewToken(RMDelegationTokenIdentifier identifier, long renewDate) {
        block2: {
            try {
                LOG.info("storing RMDelegation token with sequence number: " + identifier.getSequenceNumber());
                this.rm.getRMContext().getStateStore().storeRMDelegationToken(identifier, renewDate);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in storing RMDelegationToken with sequence number: " + identifier.getSequenceNumber());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    protected void updateStoredToken(RMDelegationTokenIdentifier id, long renewDate) {
        block2: {
            try {
                LOG.info("updating RMDelegation token with sequence number: " + id.getSequenceNumber());
                this.rm.getRMContext().getStateStore().updateRMDelegationToken(id, renewDate);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in updating persisted RMDelegationToken with sequence number: " + id.getSequenceNumber());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    protected void removeStoredToken(RMDelegationTokenIdentifier ident) throws IOException {
        block2: {
            try {
                LOG.info("removing RMDelegation token with sequence number: " + ident.getSequenceNumber());
                this.rm.getRMContext().getStateStore().removeRMDelegationToken(ident);
            }
            catch (Exception e) {
                if (this.shouldIgnoreException(e)) break block2;
                LOG.error("Error in removing RMDelegationToken with sequence number: " + ident.getSequenceNumber());
                ExitUtil.terminate((int)1, (Throwable)e);
            }
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized Set<DelegationKey> getAllMasterKeys() {
        HashSet<DelegationKey> keySet = new HashSet<DelegationKey>();
        keySet.addAll(this.allKeys.values());
        return keySet;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public synchronized Map<RMDelegationTokenIdentifier, Long> getAllTokens() {
        HashMap<RMDelegationTokenIdentifier, Long> allTokens = new HashMap<RMDelegationTokenIdentifier, Long>();
        for (Map.Entry entry : this.currentTokens.entrySet()) {
            allTokens.put((RMDelegationTokenIdentifier)entry.getKey(), ((AbstractDelegationTokenSecretManager.DelegationTokenInformation)entry.getValue()).getRenewDate());
        }
        return allTokens;
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public int getLatestDTSequenceNumber() {
        return this.delegationTokenSequenceNumber;
    }

    @Override
    public void recover(RMStateStore.RMState rmState) throws Exception {
        LOG.info("recovering RMDelegationTokenSecretManager.");
        for (DelegationKey dtKey : rmState.getRMDTSecretManagerState().getMasterKeyState()) {
            this.addKey(dtKey);
        }
        Map<RMDelegationTokenIdentifier, Long> rmDelegationTokens = rmState.getRMDTSecretManagerState().getTokenState();
        this.delegationTokenSequenceNumber = rmState.getRMDTSecretManagerState().getDTSequenceNumber();
        for (Map.Entry<RMDelegationTokenIdentifier, Long> entry : rmDelegationTokens.entrySet()) {
            this.addPersistedDelegationToken((AbstractDelegationTokenIdentifier)entry.getKey(), entry.getValue());
        }
    }

    public long getRenewDate(RMDelegationTokenIdentifier ident) throws SecretManager.InvalidToken {
        AbstractDelegationTokenSecretManager.DelegationTokenInformation info = (AbstractDelegationTokenSecretManager.DelegationTokenInformation)this.currentTokens.get(ident);
        if (info == null) {
            throw new SecretManager.InvalidToken("token (" + ident.toString() + ") can't be found in cache");
        }
        return info.getRenewDate();
    }
}

