/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.common;

import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceSizing;
import org.apache.hadoop.yarn.util.resource.Resources;

public class PendingAsk {
    private final Resource perAllocationResource;
    private final int count;
    public static final PendingAsk ZERO = new PendingAsk(Resources.none(), 0);

    public PendingAsk(ResourceSizing sizing) {
        this.perAllocationResource = sizing.getResources();
        this.count = sizing.getNumAllocations();
    }

    public PendingAsk(Resource res, int num) {
        this.perAllocationResource = res;
        this.count = num;
    }

    public Resource getPerAllocationResource() {
        return this.perAllocationResource;
    }

    public int getCount() {
        return this.count;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<per-allocation-resource=");
        sb.append(this.getPerAllocationResource());
        sb.append(",repeat=");
        sb.append(this.getCount());
        sb.append(">");
        return sb.toString();
    }
}

