/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Options;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.sls.utils.SLSUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RumenToSLSConverter {
    private static final String EOL = System.getProperty("line.separator");
    private static long baseline = 0L;
    private static Map<String, Set<String>> rackNodeMap = new TreeMap<String, Set<String>>();

    public static void main(String[] args) throws Exception {
        File nodeFile;
        File jsonFile;
        Options options = new Options();
        options.addOption("input", true, "input rumen json file");
        options.addOption("outputJobs", true, "output jobs file");
        options.addOption("outputNodes", true, "output nodes file");
        GnuParser parser = new GnuParser();
        CommandLine cmd = parser.parse(options, args);
        if (!(cmd.hasOption("input") && cmd.hasOption("outputJobs") && cmd.hasOption("outputNodes"))) {
            System.err.println();
            System.err.println("ERROR: Missing input or output file");
            System.err.println();
            System.err.println("LoadGenerator creates a SLS script from a Hadoop Rumen output");
            System.err.println();
            System.err.println("Options: -input FILE -outputJobs FILE -outputNodes FILE");
            System.err.println();
            System.exit(1);
        }
        String inputFile = cmd.getOptionValue("input");
        String outputJsonFile = cmd.getOptionValue("outputJobs");
        String outputNodeFile = cmd.getOptionValue("outputNodes");
        if (!new File(inputFile).exists()) {
            System.err.println();
            System.err.println("ERROR: input does not exist");
            System.exit(1);
        }
        if (new File(outputJsonFile).exists()) {
            System.err.println();
            System.err.println("ERROR: output job file is existing");
            System.exit(1);
        }
        if (new File(outputNodeFile).exists()) {
            System.err.println();
            System.err.println("ERROR: output node file is existing");
            System.exit(1);
        }
        if (!(jsonFile = new File(outputJsonFile)).getParentFile().exists() && !jsonFile.getParentFile().mkdirs()) {
            System.err.println("ERROR: Cannot create output directory in path: " + jsonFile.getParentFile().getAbsoluteFile());
            System.exit(1);
        }
        if (!(nodeFile = new File(outputNodeFile)).getParentFile().exists() && !nodeFile.getParentFile().mkdirs()) {
            System.err.println("ERROR: Cannot create output directory in path: " + nodeFile.getParentFile().getAbsoluteFile());
            System.exit(1);
        }
        RumenToSLSConverter.generateSLSLoadFile(inputFile, outputJsonFile);
        RumenToSLSConverter.generateSLSNodeFile(outputNodeFile);
    }

    private static void generateSLSLoadFile(String inputFile, String outputFile) throws IOException {
        try (InputStreamReader input = new InputStreamReader((InputStream)new FileInputStream(inputFile), "UTF-8");
             OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");){
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            MappingIterator i = mapper.readValues(new JsonFactory().createParser((Reader)input), Map.class);
            while (i.hasNext()) {
                Map m = (Map)i.next();
                output.write(writer.writeValueAsString((Object)RumenToSLSConverter.createSLSJob(m)) + EOL);
            }
        }
    }

    private static void generateSLSNodeFile(String outputFile) throws IOException {
        try (OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF-8");){
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer = mapper.writerWithDefaultPrettyPrinter();
            for (Map.Entry<String, Set<String>> entry : rackNodeMap.entrySet()) {
                LinkedHashMap<String, Object> rack = new LinkedHashMap<String, Object>();
                rack.put("rack", entry.getKey());
                ArrayList nodes = new ArrayList();
                for (String name : entry.getValue()) {
                    LinkedHashMap<String, String> node = new LinkedHashMap<String, String>();
                    node.put("node", name);
                    nodes.add(node);
                }
                rack.put("nodes", nodes);
                output.write(writer.writeValueAsString(rack) + EOL);
            }
        }
    }

    private static Map createSLSJob(Map rumenJob) {
        LinkedHashMap<String, Object> json = new LinkedHashMap<String, Object>();
        long jobStart = (Long)rumenJob.get("submitTime");
        long jobFinish = (Long)rumenJob.get("finishTime");
        String jobId = rumenJob.get("jobID").toString();
        String queue = rumenJob.get("queue").toString();
        String user = rumenJob.get("user").toString();
        if (baseline == 0L) {
            baseline = jobStart;
        }
        jobFinish -= baseline;
        long offset = 0L;
        if ((jobStart -= baseline) < 0L) {
            System.out.println("Warning: reset job " + jobId + " start time to 0.");
            offset = -jobStart;
            jobFinish -= jobStart;
            jobStart = 0L;
        }
        json.put("am.type", "mapreduce");
        json.put("job.start.ms", jobStart);
        json.put("job.end.ms", jobFinish);
        json.put("job.queue.name", queue);
        json.put("job.id", jobId);
        json.put("job.user", user);
        List maps = RumenToSLSConverter.createSLSTasks("map", (List)rumenJob.get("mapTasks"), offset);
        List reduces = RumenToSLSConverter.createSLSTasks("reduce", (List)rumenJob.get("reduceTasks"), offset);
        ArrayList tasks = new ArrayList();
        tasks.addAll(maps);
        tasks.addAll(reduces);
        json.put("job.tasks", tasks);
        return json;
    }

    private static List createSLSTasks(String taskType, List rumenTasks, long offset) {
        int priority = taskType.equals("reduce") ? 10 : 20;
        ArrayList array = new ArrayList();
        for (Object e : rumenTasks) {
            Map rumenTask = (Map)e;
            for (Object ee : (List)rumenTask.get("attempts")) {
                Map rumenAttempt = (Map)ee;
                long taskStart = (Long)rumenAttempt.get("startTime");
                long taskFinish = (Long)rumenAttempt.get("finishTime");
                String hostname = (String)rumenAttempt.get("hostName");
                taskStart = taskStart - baseline + offset;
                taskFinish = taskFinish - baseline + offset;
                LinkedHashMap<String, Object> task = new LinkedHashMap<String, Object>();
                task.put("container.host", hostname);
                task.put("container.start.ms", taskStart);
                task.put("container.end.ms", taskFinish);
                task.put("container.priority", priority);
                task.put("container.type", taskType);
                array.add(task);
                String[] rackHost = SLSUtils.getRackHostName(hostname);
                if (rackNodeMap.containsKey(rackHost[0])) {
                    rackNodeMap.get(rackHost[0]).add(rackHost[1]);
                    continue;
                }
                TreeSet<String> hosts = new TreeSet<String>();
                hosts.add(rackHost[1]);
                rackNodeMap.put(rackHost[0], hosts);
            }
        }
        return array;
    }
}

