/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.protocol.HdfsConstants;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestNNStorageRetentionFunctional {
    private static final File TEST_ROOT_DIR = new File(MiniDFSCluster.getBaseDirectory());
    private static final Logger LOG = LoggerFactory.getLogger(TestNNStorageRetentionFunctional.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPurgingWithNameEditsDirAfterFailure() throws Exception {
        MiniDFSCluster cluster = null;
        HdfsConfiguration conf = new HdfsConfiguration();
        conf.setLong("dfs.namenode.num.extra.edits.retained", 0L);
        File sd0 = new File(TEST_ROOT_DIR, "nn0");
        File sd1 = new File(TEST_ROOT_DIR, "nn1");
        File cd0 = new File(sd0, "current");
        File cd1 = new File(sd1, "current");
        conf.set("dfs.namenode.name.dir", Joiner.on((String)",").join((Object)sd0, (Object)sd1, new Object[0]));
        try {
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(0).manageNameDfsDirs(false).format(true).build();
            NameNode nn = cluster.getNameNode();
            TestNNStorageRetentionFunctional.doSaveNamespace(nn);
            LOG.info("After first save, images 0 and 2 should exist in both dirs");
            GenericTestUtils.assertGlobEquals((File)cd0, (String)"fsimage_\\d*", (String[])new String[]{NNStorage.getImageFileName((long)0L), NNStorage.getImageFileName((long)2L)});
            GenericTestUtils.assertGlobEquals((File)cd1, (String)"fsimage_\\d*", (String[])new String[]{NNStorage.getImageFileName((long)0L), NNStorage.getImageFileName((long)2L)});
            GenericTestUtils.assertGlobEquals((File)cd0, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)2L), NNStorage.getInProgressEditsFileName((long)3L)});
            GenericTestUtils.assertGlobEquals((File)cd1, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)1L, (long)2L), NNStorage.getInProgressEditsFileName((long)3L)});
            TestNNStorageRetentionFunctional.doSaveNamespace(nn);
            LOG.info("After second save, image 0 should be purged, and image 4 should exist in both.");
            GenericTestUtils.assertGlobEquals((File)cd0, (String)"fsimage_\\d*", (String[])new String[]{NNStorage.getImageFileName((long)2L), NNStorage.getImageFileName((long)4L)});
            GenericTestUtils.assertGlobEquals((File)cd1, (String)"fsimage_\\d*", (String[])new String[]{NNStorage.getImageFileName((long)2L), NNStorage.getImageFileName((long)4L)});
            GenericTestUtils.assertGlobEquals((File)cd0, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)3L, (long)4L), NNStorage.getInProgressEditsFileName((long)5L)});
            GenericTestUtils.assertGlobEquals((File)cd1, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)3L, (long)4L), NNStorage.getInProgressEditsFileName((long)5L)});
            LOG.info("Failing first storage dir by chmodding it");
            Assert.assertEquals((long)0L, (long)FileUtil.chmod((String)cd0.getAbsolutePath(), (String)"000"));
            TestNNStorageRetentionFunctional.doSaveNamespace(nn);
            LOG.info("Restoring accessibility of first storage dir");
            Assert.assertEquals((long)0L, (long)FileUtil.chmod((String)cd0.getAbsolutePath(), (String)"755"));
            LOG.info("nothing should have been purged in first storage dir");
            GenericTestUtils.assertGlobEquals((File)cd0, (String)"fsimage_\\d*", (String[])new String[]{NNStorage.getImageFileName((long)2L), NNStorage.getImageFileName((long)4L)});
            GenericTestUtils.assertGlobEquals((File)cd0, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)3L, (long)4L), NNStorage.getInProgressEditsFileName((long)5L)});
            LOG.info("fsimage_2 should be purged in second storage dir");
            GenericTestUtils.assertGlobEquals((File)cd1, (String)"fsimage_\\d*", (String[])new String[]{NNStorage.getImageFileName((long)4L), NNStorage.getImageFileName((long)6L)});
            GenericTestUtils.assertGlobEquals((File)cd1, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)5L, (long)6L), NNStorage.getInProgressEditsFileName((long)7L)});
            LOG.info("On next save, we should purge logs from the failed dir, but not images, since the image directory is in failed state.");
            TestNNStorageRetentionFunctional.doSaveNamespace(nn);
            GenericTestUtils.assertGlobEquals((File)cd1, (String)"fsimage_\\d*", (String[])new String[]{NNStorage.getImageFileName((long)6L), NNStorage.getImageFileName((long)8L)});
            GenericTestUtils.assertGlobEquals((File)cd1, (String)"edits_.*", (String[])new String[]{NNStorage.getFinalizedEditsFileName((long)7L, (long)8L), NNStorage.getInProgressEditsFileName((long)9L)});
            GenericTestUtils.assertGlobEquals((File)cd0, (String)"fsimage_\\d*", (String[])new String[]{NNStorage.getImageFileName((long)2L), NNStorage.getImageFileName((long)4L)});
            GenericTestUtils.assertGlobEquals((File)cd0, (String)"edits_.*", (String[])new String[]{NNStorage.getInProgressEditsFileName((long)9L)});
        }
        finally {
            FileUtil.chmod((String)cd0.getAbsolutePath(), (String)"755");
            LOG.info("Shutting down...");
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private static void doSaveNamespace(NameNode nn) throws IOException {
        LOG.info("Saving namespace...");
        nn.getRpcServer().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_ENTER, false);
        nn.getRpcServer().saveNamespace(0L, 0L);
        nn.getRpcServer().setSafeMode(HdfsConstants.SafeModeAction.SAFEMODE_LEAVE, false);
    }
}

