/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeManager;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.DataNodeTestUtils;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.PlatformAssumptions;
import org.apache.hadoop.util.DiskChecker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.Timeout;

public class TestDataNodeVolumeFailureToleration {
    private FileSystem fs;
    private MiniDFSCluster cluster;
    private Configuration conf;
    final int WAIT_FOR_HEARTBEATS = 3000;
    final int WAIT_FOR_DEATH = 15000;
    @Rule
    public Timeout timeout = new Timeout(120000);

    @Before
    public void setUp() throws Exception {
        this.conf = new HdfsConfiguration();
        this.conf.setLong("dfs.blocksize", 512L);
        this.conf.setInt("dfs.heartbeat.interval", 1);
        this.conf.setInt("dfs.df.interval", 1000);
        this.conf.setInt("dfs.namenode.heartbeat.recheck-interval", 1000);
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        this.cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(1).build();
        this.cluster.waitActive();
        this.fs = this.cluster.getFileSystem();
    }

    @After
    public void tearDown() throws Exception {
        if (this.cluster != null) {
            this.cluster.shutdown();
            this.cluster = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testValidVolumesAtStartup() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.cluster.shutdownDataNodes();
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", 1);
        File tld = new File(MiniDFSCluster.getBaseDirectory(), "badData");
        File dataDir1 = new File(tld, "data1");
        File dataDir1Actual = new File(dataDir1, "1");
        dataDir1Actual.mkdirs();
        File dataDir2 = new File(tld, "data2");
        this.prepareDirToFail(dataDir2);
        File dataDir2Actual = new File(dataDir2, "2");
        this.conf.set("dfs.datanode.data.dir", dataDir1Actual.getPath() + "," + dataDir2Actual.getPath());
        this.cluster.startDataNodes(this.conf, 1, false, null, null);
        this.cluster.waitActive();
        try {
            Assert.assertTrue((String)"The DN should have started up fine.", (boolean)this.cluster.isDataNodeUp());
            DataNode dn = this.cluster.getDataNodes().get(0);
            String si = DataNodeTestUtils.getFSDataset(dn).getStorageInfo();
            Assert.assertTrue((String)"The DN should have started with this directory", (boolean)si.contains(dataDir1Actual.getPath()));
            Assert.assertFalse((String)"The DN shouldn't have a bad directory.", (boolean)si.contains(dataDir2Actual.getPath()));
        }
        finally {
            this.cluster.shutdownDataNodes();
            FileUtil.chmod((String)dataDir2.toString(), (String)"755");
        }
    }

    @Test
    public void testConfigureMinValidVolumes() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", 0);
        this.conf.setTimeDuration("dfs.datanode.disk.check.min.gap", 0L, TimeUnit.MILLISECONDS);
        this.cluster.startDataNodes(this.conf, 2, true, null, null);
        this.cluster.waitActive();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        long dnCapacity = DFSTestUtil.getDatanodeCapacity(dm, 0);
        File dn2Vol1 = this.cluster.getInstanceStorageDir(1, 0);
        DataNodeTestUtils.injectDataDirFailure(dn2Vol1);
        Path file1 = new Path("/test1");
        DFSTestUtil.createFile(this.fs, file1, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file1, (short)2);
        DFSTestUtil.waitForDatanodeStatus(dm, 2, 1, 0L, origCapacity - 1L * dnCapacity, 3000L);
        DataNodeTestUtils.restoreDataDirFromFailure(dn2Vol1);
        Path file2 = new Path("/test2");
        DFSTestUtil.createFile(this.fs, file2, 1024L, (short)3, 1L);
        DFSTestUtil.waitReplication(this.fs, file2, (short)2);
    }

    private void restartDatanodes(int volTolerated, boolean manageDfsDirs) throws IOException {
        this.cluster.shutdownDataNodes();
        this.conf.setInt("dfs.datanode.failed.volumes.tolerated", volTolerated);
        this.cluster.startDataNodes(this.conf, 1, manageDfsDirs, null, null);
        this.cluster.waitActive();
    }

    @Test
    public void testVolumeAndTolerableConfiguration() throws Exception {
        this.testVolumeConfig(-2, 0, false, true);
        this.testVolumeConfig(-1, 0, true, true);
        this.testVolumeConfig(-1, 1, true, true);
        this.testVolumeConfig(-1, 2, false, true);
        this.testVolumeConfig(100, 0, false, true);
        this.testVolumeConfig(0, 1, false, false);
        this.testVolumeConfig(1, 1, true, false);
        this.testVolumeConfig(0, 0, true, false);
        this.testVolumeConfig(0, 2, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testVolumeConfig(int volumesTolerated, int volumesFailed, boolean expectedBPServiceState, boolean manageDfsDirs) throws IOException, InterruptedException {
        PlatformAssumptions.assumeNotWindows();
        boolean dnIndex = false;
        File[] dirs = new File[]{new File(this.cluster.getInstanceStorageDir(0, 0), "current"), new File(this.cluster.getInstanceStorageDir(0, 1), "current")};
        try {
            for (int i = 0; i < volumesFailed; ++i) {
                this.prepareDirToFail(dirs[i]);
            }
            this.restartDatanodes(volumesTolerated, manageDfsDirs);
        }
        catch (DiskChecker.DiskErrorException e) {
            GenericTestUtils.assertExceptionContains((String)"Invalid value configured for dfs.datanode.failed.volumes.tolerated", (Throwable)e);
        }
        finally {
            boolean bpServiceState = this.cluster.getDataNodes().size() == 0 ? false : this.cluster.getDataNodes().get(0).isBPServiceAlive(this.cluster.getNamesystem().getBlockPoolId());
            Assert.assertEquals((Object)expectedBPServiceState, (Object)bpServiceState);
            for (File dir : dirs) {
                FileUtil.chmod((String)dir.toString(), (String)"755");
            }
        }
    }

    private void prepareDirToFail(File dir) throws IOException, InterruptedException {
        dir.mkdirs();
        Assert.assertEquals((String)"Couldn't chmod local vol", (long)0L, (long)FileUtil.chmod((String)dir.toString(), (String)"000"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailedVolumeOnStartupIsCounted() throws Exception {
        PlatformAssumptions.assumeNotWindows();
        DatanodeManager dm = this.cluster.getNamesystem().getBlockManager().getDatanodeManager();
        long origCapacity = DFSTestUtil.getLiveDatanodeCapacity(dm);
        File dir = new File(this.cluster.getInstanceStorageDir(0, 0), "current");
        try {
            this.prepareDirToFail(dir);
            this.restartDatanodes(1, false);
            Assert.assertEquals((Object)true, (Object)this.cluster.getDataNodes().get(0).isBPServiceAlive(this.cluster.getNamesystem().getBlockPoolId()));
            DFSTestUtil.waitForDatanodeStatus(dm, 1, 0, 1L, origCapacity / 2L, 3000L);
        }
        finally {
            FileUtil.chmod((String)dir.toString(), (String)"755");
        }
    }
}

