/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.task;

import java.math.BigDecimal;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.Structure2D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.Cholesky;
import org.ojalgo.matrix.decomposition.LU;
import org.ojalgo.matrix.decomposition.QR;
import org.ojalgo.matrix.decomposition.SingularValue;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.task.AbstractInverter;
import org.ojalgo.matrix.task.MatrixTask;
import org.ojalgo.matrix.task.TaskException;
import org.ojalgo.scalar.ComplexNumber;

public interface InverterTask<N extends Number>
extends MatrixTask<N> {
    public static final Factory<BigDecimal> BIG = new Factory<BigDecimal>(){

        @Override
        public InverterTask<BigDecimal> make(MatrixStore<BigDecimal> template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (InverterTask)Cholesky.BIG.make(template);
            }
            if (template.isSquare()) {
                return (InverterTask)LU.BIG.make(template);
            }
            if (template.isTall()) {
                return (InverterTask)QR.BIG.make(template);
            }
            return (InverterTask)SingularValue.BIG.make(template);
        }
    };
    public static final Factory<ComplexNumber> COMPLEX = new Factory<ComplexNumber>(){

        @Override
        public InverterTask<ComplexNumber> make(MatrixStore<ComplexNumber> template, boolean symmetric, boolean positiveDefinite) {
            if (symmetric && positiveDefinite) {
                return (InverterTask)Cholesky.COMPLEX.make(template);
            }
            if (template.isSquare()) {
                return (InverterTask)LU.COMPLEX.make(template);
            }
            if (template.isTall()) {
                return (InverterTask)QR.COMPLEX.make(template);
            }
            return (InverterTask)SingularValue.COMPLEX.make(template);
        }
    };
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public InverterTask<Double> make(MatrixStore<Double> template, boolean symmetric, boolean positiveDefinite) {
            long tmpDim = template.countRows();
            if (symmetric) {
                if (tmpDim == 1L) {
                    return AbstractInverter.FULL_1X1;
                }
                if (tmpDim == 2L) {
                    return AbstractInverter.SYMMETRIC_2X2;
                }
                if (tmpDim == 3L) {
                    return AbstractInverter.SYMMETRIC_3X3;
                }
                if (tmpDim == 4L) {
                    return AbstractInverter.SYMMETRIC_4X4;
                }
                if (tmpDim == 5L) {
                    return AbstractInverter.SYMMETRIC_5X5;
                }
                return positiveDefinite ? (InverterTask)Cholesky.PRIMITIVE.make(template) : (InverterTask)LU.PRIMITIVE.make(template);
            }
            if (template.isSquare()) {
                if (tmpDim == 1L) {
                    return AbstractInverter.FULL_1X1;
                }
                if (tmpDim == 2L) {
                    return AbstractInverter.FULL_2X2;
                }
                if (tmpDim == 3L) {
                    return AbstractInverter.FULL_3X3;
                }
                if (tmpDim == 4L) {
                    return AbstractInverter.FULL_4X4;
                }
                if (tmpDim == 5L) {
                    return AbstractInverter.FULL_5X5;
                }
                return (InverterTask)LU.PRIMITIVE.make(template);
            }
            if (template.isTall()) {
                return (InverterTask)QR.PRIMITIVE.make(template);
            }
            return (InverterTask)SingularValue.PRIMITIVE.make(template);
        }
    };

    default public MatrixStore<N> invert(Access2D<?> original) throws TaskException {
        return this.invert(original, this.preallocate(original));
    }

    public MatrixStore<N> invert(Access2D<?> var1, PhysicalStore<N> var2) throws TaskException;

    public PhysicalStore<N> preallocate(Structure2D var1);

    public static abstract class Factory<N extends Number> {
        public final InverterTask<N> make(MatrixStore<N> template) {
            return this.make(template, MatrixUtils.isHermitian(template), false);
        }

        public abstract InverterTask<N> make(MatrixStore<N> var1, boolean var2, boolean var3);
    }
}

