/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.access.Access1D;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.concurrent.DivideAndConquer;
import org.ojalgo.constant.BigMath;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.store.BigDenseStore;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.PrimitiveDenseStore;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class MultiplyRight
extends MatrixOperation {
    public static final MultiplyRight SETUP = new MultiplyRight();
    public static int THRESHOLD = 32;
    static final BigDenseStore.BigMultiplyRight BIG = (product, left, complexity, right) -> MultiplyRight.invoke(product, 0, (int)(right.count() / (long)complexity), left, complexity, right);
    static final BigDenseStore.BigMultiplyRight BIG_MT = (product, left, complexity, right) -> {
        DivideAndConquer tmpConquerer = new DivideAndConquer(){

            @Override
            public void conquer(int first, int limit) {
                MultiplyRight.invoke(product, first, limit, left, complexity, right);
            }
        };
        tmpConquerer.invoke(0, (int)(right.count() / (long)complexity), THRESHOLD);
    };
    static final ComplexDenseStore.ComplexMultiplyRight COMPLEX = (product, left, complexity, right) -> MultiplyRight.invoke(product, 0, (int)(right.count() / (long)complexity), left, complexity, right);
    static final ComplexDenseStore.ComplexMultiplyRight COMPLEX_MT = (product, left, complexity, right) -> {
        DivideAndConquer tmpConquerer = new DivideAndConquer(){

            @Override
            public void conquer(int first, int limit) {
                MultiplyRight.invoke(product, first, limit, left, complexity, right);
            }
        };
        tmpConquerer.invoke(0, (int)(right.count() / (long)complexity), THRESHOLD);
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE = (product, left, complexity, right) -> MultiplyRight.invoke(product, 0, (int)(right.count() / (long)complexity), left, complexity, right);
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_0XN = (product, left, complexity, right) -> {
        int tmpRowDim = 10;
        int tmpColDim = product.length / 10;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            double tmp9J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
                tmp6J += left[tmpIndex++] * tmpRightCJ;
                tmp7J += left[tmpIndex++] * tmpRightCJ;
                tmp8J += left[tmpIndex++] * tmpRightCJ;
                tmp9J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * 10;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
            product[++tmpIndex] = tmp7J;
            product[++tmpIndex] = tmp8J;
            product[++tmpIndex] = tmp9J;
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_1X1 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        int tmpLeftStruct = left.length / complexity;
        for (int c = 0; c < complexity; ++c) {
            tmp00 += left[c * tmpLeftStruct] * right.doubleValue(c);
        }
        product[0] = tmp00;
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_1XN = (product, left, complexity, right) -> {
        int tmpColDim = product.length;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                tmp0J += left[tmpIndex++] * right.doubleValue(c + j * complexity);
            }
            product[j] = tmp0J;
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_2X2 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 2;
            double tmpLeft0 = left[tmpIndex];
            double tmpLeft1 = left[++tmpIndex];
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp01;
        product[3] = tmp11;
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_3X3 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 3;
            double tmpLeft0 = left[tmpIndex];
            double tmpLeft1 = left[++tmpIndex];
            double tmpLeft2 = left[++tmpIndex];
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp20;
        product[3] = tmp01;
        product[4] = tmp11;
        product[5] = tmp21;
        product[6] = tmp02;
        product[7] = tmp12;
        product[8] = tmp22;
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_4X4 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 4;
            double tmpLeft0 = left[tmpIndex];
            double tmpLeft1 = left[++tmpIndex];
            double tmpLeft2 = left[++tmpIndex];
            double tmpLeft3 = left[++tmpIndex];
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += complexity);
            double tmpRight3 = right.doubleValue(tmpIndex += complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp20;
        product[3] = tmp30;
        product[4] = tmp01;
        product[5] = tmp11;
        product[6] = tmp21;
        product[7] = tmp31;
        product[8] = tmp02;
        product[9] = tmp12;
        product[10] = tmp22;
        product[11] = tmp32;
        product[12] = tmp03;
        product[13] = tmp13;
        product[14] = tmp23;
        product[15] = tmp33;
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_5X5 = (product, left, complexity, right) -> {
        double tmp00 = PrimitiveMath.ZERO;
        double tmp10 = PrimitiveMath.ZERO;
        double tmp20 = PrimitiveMath.ZERO;
        double tmp30 = PrimitiveMath.ZERO;
        double tmp40 = PrimitiveMath.ZERO;
        double tmp01 = PrimitiveMath.ZERO;
        double tmp11 = PrimitiveMath.ZERO;
        double tmp21 = PrimitiveMath.ZERO;
        double tmp31 = PrimitiveMath.ZERO;
        double tmp41 = PrimitiveMath.ZERO;
        double tmp02 = PrimitiveMath.ZERO;
        double tmp12 = PrimitiveMath.ZERO;
        double tmp22 = PrimitiveMath.ZERO;
        double tmp32 = PrimitiveMath.ZERO;
        double tmp42 = PrimitiveMath.ZERO;
        double tmp03 = PrimitiveMath.ZERO;
        double tmp13 = PrimitiveMath.ZERO;
        double tmp23 = PrimitiveMath.ZERO;
        double tmp33 = PrimitiveMath.ZERO;
        double tmp43 = PrimitiveMath.ZERO;
        double tmp04 = PrimitiveMath.ZERO;
        double tmp14 = PrimitiveMath.ZERO;
        double tmp24 = PrimitiveMath.ZERO;
        double tmp34 = PrimitiveMath.ZERO;
        double tmp44 = PrimitiveMath.ZERO;
        for (int c = 0; c < complexity; ++c) {
            int tmpIndex = c * 5;
            double tmpLeft0 = left[tmpIndex];
            double tmpLeft1 = left[++tmpIndex];
            double tmpLeft2 = left[++tmpIndex];
            double tmpLeft3 = left[++tmpIndex];
            double tmpLeft4 = left[++tmpIndex];
            tmpIndex = c;
            double tmpRight0 = right.doubleValue(tmpIndex);
            double tmpRight1 = right.doubleValue(tmpIndex += complexity);
            double tmpRight2 = right.doubleValue(tmpIndex += complexity);
            double tmpRight3 = right.doubleValue(tmpIndex += complexity);
            double tmpRight4 = right.doubleValue(tmpIndex += complexity);
            tmp00 += tmpLeft0 * tmpRight0;
            tmp10 += tmpLeft1 * tmpRight0;
            tmp20 += tmpLeft2 * tmpRight0;
            tmp30 += tmpLeft3 * tmpRight0;
            tmp40 += tmpLeft4 * tmpRight0;
            tmp01 += tmpLeft0 * tmpRight1;
            tmp11 += tmpLeft1 * tmpRight1;
            tmp21 += tmpLeft2 * tmpRight1;
            tmp31 += tmpLeft3 * tmpRight1;
            tmp41 += tmpLeft4 * tmpRight1;
            tmp02 += tmpLeft0 * tmpRight2;
            tmp12 += tmpLeft1 * tmpRight2;
            tmp22 += tmpLeft2 * tmpRight2;
            tmp32 += tmpLeft3 * tmpRight2;
            tmp42 += tmpLeft4 * tmpRight2;
            tmp03 += tmpLeft0 * tmpRight3;
            tmp13 += tmpLeft1 * tmpRight3;
            tmp23 += tmpLeft2 * tmpRight3;
            tmp33 += tmpLeft3 * tmpRight3;
            tmp43 += tmpLeft4 * tmpRight3;
            tmp04 += tmpLeft0 * tmpRight4;
            tmp14 += tmpLeft1 * tmpRight4;
            tmp24 += tmpLeft2 * tmpRight4;
            tmp34 += tmpLeft3 * tmpRight4;
            tmp44 += tmpLeft4 * tmpRight4;
        }
        product[0] = tmp00;
        product[1] = tmp10;
        product[2] = tmp20;
        product[3] = tmp30;
        product[4] = tmp40;
        product[5] = tmp01;
        product[6] = tmp11;
        product[7] = tmp21;
        product[8] = tmp31;
        product[9] = tmp41;
        product[10] = tmp02;
        product[11] = tmp12;
        product[12] = tmp22;
        product[13] = tmp32;
        product[14] = tmp42;
        product[15] = tmp03;
        product[16] = tmp13;
        product[17] = tmp23;
        product[18] = tmp33;
        product[19] = tmp43;
        product[20] = tmp04;
        product[21] = tmp14;
        product[22] = tmp24;
        product[23] = tmp34;
        product[24] = tmp44;
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_6XN = (product, left, complexity, right) -> {
        int tmpRowDim = 6;
        int tmpColDim = product.length / 6;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * 6;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_7XN = (product, left, complexity, right) -> {
        int tmpRowDim = 7;
        int tmpColDim = product.length / 7;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
                tmp6J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * 7;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_8XN = (product, left, complexity, right) -> {
        int tmpRowDim = 8;
        int tmpColDim = product.length / 8;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
                tmp6J += left[tmpIndex++] * tmpRightCJ;
                tmp7J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * 8;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
            product[++tmpIndex] = tmp7J;
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_9XN = (product, left, complexity, right) -> {
        int tmpRowDim = 9;
        int tmpColDim = product.length / 9;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmp0J = PrimitiveMath.ZERO;
            double tmp1J = PrimitiveMath.ZERO;
            double tmp2J = PrimitiveMath.ZERO;
            double tmp3J = PrimitiveMath.ZERO;
            double tmp4J = PrimitiveMath.ZERO;
            double tmp5J = PrimitiveMath.ZERO;
            double tmp6J = PrimitiveMath.ZERO;
            double tmp7J = PrimitiveMath.ZERO;
            double tmp8J = PrimitiveMath.ZERO;
            int tmpIndex = 0;
            for (int c = 0; c < complexity; ++c) {
                double tmpRightCJ = right.doubleValue(c + j * complexity);
                tmp0J += left[tmpIndex++] * tmpRightCJ;
                tmp1J += left[tmpIndex++] * tmpRightCJ;
                tmp2J += left[tmpIndex++] * tmpRightCJ;
                tmp3J += left[tmpIndex++] * tmpRightCJ;
                tmp4J += left[tmpIndex++] * tmpRightCJ;
                tmp5J += left[tmpIndex++] * tmpRightCJ;
                tmp6J += left[tmpIndex++] * tmpRightCJ;
                tmp7J += left[tmpIndex++] * tmpRightCJ;
                tmp8J += left[tmpIndex++] * tmpRightCJ;
            }
            tmpIndex = j * 9;
            product[tmpIndex] = tmp0J;
            product[++tmpIndex] = tmp1J;
            product[++tmpIndex] = tmp2J;
            product[++tmpIndex] = tmp3J;
            product[++tmpIndex] = tmp4J;
            product[++tmpIndex] = tmp5J;
            product[++tmpIndex] = tmp6J;
            product[++tmpIndex] = tmp7J;
            product[++tmpIndex] = tmp8J;
        }
    };
    static final PrimitiveDenseStore.PrimitiveMultiplyRight PRIMITIVE_MT = (product, left, complexity, right) -> {
        DivideAndConquer tmpConquerer = new DivideAndConquer(){

            @Override
            public void conquer(int first, int limit) {
                MultiplyRight.invoke(product, first, limit, left, complexity, right);
            }
        };
        tmpConquerer.invoke(0, (int)(right.count() / (long)complexity), THRESHOLD);
    };

    public static BigDenseStore.BigMultiplyRight getBig(long rows, long columns) {
        if (columns > (long)THRESHOLD) {
            return BIG_MT;
        }
        return BIG;
    }

    public static ComplexDenseStore.ComplexMultiplyRight getComplex(long rows, long columns) {
        if (columns > (long)THRESHOLD) {
            return COMPLEX_MT;
        }
        return COMPLEX;
    }

    public static PrimitiveDenseStore.PrimitiveMultiplyRight getPrimitive(long rows, long columns) {
        if (columns > (long)THRESHOLD) {
            return PRIMITIVE_MT;
        }
        if (rows == 10L) {
            return PRIMITIVE_0XN;
        }
        if (rows == 9L) {
            return PRIMITIVE_9XN;
        }
        if (rows == 8L) {
            return PRIMITIVE_8XN;
        }
        if (rows == 7L) {
            return PRIMITIVE_7XN;
        }
        if (rows == 6L) {
            return PRIMITIVE_6XN;
        }
        if (rows == 5L && columns == 5L) {
            return PRIMITIVE_5X5;
        }
        if (rows == 4L && columns == 4L) {
            return PRIMITIVE_4X4;
        }
        if (rows == 3L && columns == 3L) {
            return PRIMITIVE_3X3;
        }
        if (rows == 2L && columns == 2L) {
            return PRIMITIVE_2X2;
        }
        if (rows == 1L) {
            return PRIMITIVE_1XN;
        }
        return PRIMITIVE;
    }

    static void experiment(double[] product, double[] left, int complexity, double[] right) {
        int c;
        int tmpRowDim = left.length / complexity;
        int tmpColDim = right.length / complexity;
        for (int j = 0; j < tmpColDim; ++j) {
            double tmpProduct0J = PrimitiveMath.ZERO;
            double tmpProduct1J = PrimitiveMath.ZERO;
            double tmpProduct2J = PrimitiveMath.ZERO;
            for (c = 0; c < complexity; ++c) {
                double tmpRightCJ = right[c + j * complexity];
                tmpProduct0J += left[0 + c * tmpRowDim] * tmpRightCJ;
                tmpProduct1J += left[1 + c * tmpRowDim] * tmpRightCJ;
                tmpProduct2J += left[2 + c * tmpRowDim] * tmpRightCJ;
            }
            product[0 + j * tmpRowDim] = tmpProduct0J;
            product[1 + j * tmpRowDim] = tmpProduct1J;
            product[2 + j * tmpRowDim] = tmpProduct2J;
        }
        for (int i = 0; i < tmpRowDim; ++i) {
            double tmpProductI0 = PrimitiveMath.ZERO;
            double tmpProductI1 = PrimitiveMath.ZERO;
            double tmpProductI2 = PrimitiveMath.ZERO;
            for (c = 0; c < complexity; ++c) {
                double tmpLeftIC = left[i + c * tmpRowDim];
                tmpProductI0 += tmpLeftIC * right[c + 0 * complexity];
                tmpProductI1 += tmpLeftIC * right[c + 1 * complexity];
                tmpProductI2 += tmpLeftIC * right[c + 2 * complexity];
            }
            product[i + 0 * tmpRowDim] = tmpProductI0;
            product[i + 1 * tmpRowDim] = tmpProductI1;
            product[i + 2 * tmpRowDim] = tmpProductI2;
        }
    }

    static void invoke(BigDecimal[] product, int firstColumn, int columnLimit, BigDecimal[] left, int complexity, Access1D<BigDecimal> right) {
        int tmpRowDim = left.length / complexity;
        int tmpIndexLimit = tmpRowDim * columnLimit;
        for (int tmpIndex = tmpRowDim * firstColumn; tmpIndex < tmpIndexLimit; ++tmpIndex) {
            product[tmpIndex] = BigMath.ZERO;
        }
        for (int j = firstColumn; j < columnLimit; ++j) {
            for (int c = 0; c < complexity; ++c) {
                AXPY.invoke(product, j * tmpRowDim, 1, right.get(c + j * complexity), left, c * tmpRowDim, 1, 0, tmpRowDim);
            }
        }
    }

    static void invoke(ComplexNumber[] product, int firstColumn, int columnLimit, ComplexNumber[] left, int complexity, Access1D<ComplexNumber> right) {
        int tmpRowDim = left.length / complexity;
        int tmpIndexLimit = tmpRowDim * columnLimit;
        for (int tmpIndex = tmpRowDim * firstColumn; tmpIndex < tmpIndexLimit; ++tmpIndex) {
            product[tmpIndex] = ComplexNumber.ZERO;
        }
        for (int j = firstColumn; j < columnLimit; ++j) {
            for (int c = 0; c < complexity; ++c) {
                AXPY.invoke((Number[])product, (int)(j * tmpRowDim), (int)1, (Number)right.get(c + j * complexity), (Number[])left, (int)(c * tmpRowDim), (int)1, (int)0, (int)tmpRowDim);
            }
        }
    }

    static void invoke(double[] product, int firstColumn, int columnLimit, double[] left, int complexity, Access1D<?> right) {
        int tmpRowDim = left.length / complexity;
        int tmpIndexLimit = tmpRowDim * columnLimit;
        for (int tmpIndex = tmpRowDim * firstColumn; tmpIndex < tmpIndexLimit; ++tmpIndex) {
            product[tmpIndex] = PrimitiveMath.ZERO;
        }
        for (int j = firstColumn; j < columnLimit; ++j) {
            int tmpFirstInColumn = MatrixUtils.firstInColumn(right, j, 0);
            int tmpLimitOfColumn = MatrixUtils.limitOfColumn(right, j, complexity);
            for (int c = tmpFirstInColumn; c < tmpLimitOfColumn; ++c) {
                AXPY.invoke(product, j * tmpRowDim, 1, right.doubleValue(c + j * complexity), left, c * tmpRowDim, 1, 0, tmpRowDim);
            }
        }
    }

    private MultiplyRight() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

