/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.finance.FinanceUtils;
import org.ojalgo.finance.portfolio.FinancePortfolio;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.PrimitiveMatrix;

public class PortfolioContext
implements FinancePortfolio.Context {
    private final PrimitiveMatrix myAssetReturns;
    private PrimitiveMatrix myAssetVolatilities = null;
    private PrimitiveMatrix myCorrelations = null;
    private PrimitiveMatrix myCovariances = null;

    public PortfolioContext(Access1D<?> assetReturns, Access1D<?> assetVolatilities, Access2D<?> correlations) {
        this.myAssetReturns = (PrimitiveMatrix)FinancePortfolio.MATRIX_FACTORY.columns(assetReturns);
        this.myAssetVolatilities = (PrimitiveMatrix)FinancePortfolio.MATRIX_FACTORY.columns(assetVolatilities);
        this.myCorrelations = (PrimitiveMatrix)FinancePortfolio.MATRIX_FACTORY.copy(correlations);
    }

    public PortfolioContext(Access1D<?> assetReturns, Access2D<?> covariances) {
        this.myAssetReturns = (PrimitiveMatrix)FinancePortfolio.MATRIX_FACTORY.columns(assetReturns);
        this.myCovariances = (PrimitiveMatrix)FinancePortfolio.MATRIX_FACTORY.copy(covariances);
    }

    private PortfolioContext() {
        this.myAssetReturns = null;
    }

    @Override
    public double calculatePortfolioReturn(FinancePortfolio weightsPortfolio) {
        return ((PrimitiveMatrix)((PrimitiveMatrix)FinancePortfolio.MATRIX_FACTORY.rows(weightsPortfolio.getWeights())).multiply(this.getAssetReturns())).doubleValue(0L);
    }

    @Override
    public double calculatePortfolioVariance(FinancePortfolio weightsPortfolio) {
        PrimitiveMatrix tmpWeights = (PrimitiveMatrix)FinancePortfolio.MATRIX_FACTORY.columns(weightsPortfolio.getWeights());
        return ((PrimitiveMatrix)((PrimitiveMatrix)tmpWeights.transpose()).multiply((BasicMatrix)this.getCovariances().multiply(tmpWeights))).doubleValue(0L);
    }

    @Override
    public PrimitiveMatrix getAssetReturns() {
        return this.myAssetReturns;
    }

    @Override
    public PrimitiveMatrix getAssetVolatilities() {
        if (this.myAssetVolatilities == null) {
            this.myAssetVolatilities = FinanceUtils.toVolatilities(this.myCovariances);
        }
        return this.myAssetVolatilities;
    }

    @Override
    public PrimitiveMatrix getCorrelations() {
        if (this.myCorrelations == null) {
            this.myCorrelations = FinanceUtils.toCorrelations(this.myCovariances, false);
        }
        return this.myCorrelations;
    }

    @Override
    public PrimitiveMatrix getCovariances() {
        if (this.myCovariances == null) {
            this.myCovariances = FinanceUtils.toCovariances(this.myAssetVolatilities, this.myCorrelations);
        }
        return this.myCovariances;
    }

    @Override
    public int size() {
        return (int)this.myAssetReturns.count();
    }
}

