/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task;

import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LinuxContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTask;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTaskType;

public class DockerContainerDeletionTask
extends DeletionTask
implements Runnable {
    private String containerId;

    public DockerContainerDeletionTask(DeletionService deletionService, String user, String containerId) {
        this(-1, deletionService, user, containerId);
    }

    public DockerContainerDeletionTask(int taskId, DeletionService deletionService, String user, String containerId) {
        super(taskId, deletionService, user, DeletionTaskType.DOCKER_CONTAINER);
        this.containerId = containerId;
    }

    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void run() {
        if (LOG.isDebugEnabled()) {
            String msg = String.format("Running DeletionTask : %s", this.toString());
            LOG.debug(msg);
        }
        LinuxContainerExecutor exec = (LinuxContainerExecutor)this.getDeletionService().getContainerExecutor();
        exec.removeDockerContainer(this.containerId);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("DockerContainerDeletionTask : ");
        sb.append("  id : ").append(this.getTaskId());
        sb.append("  containerId : ").append(this.containerId);
        return sb.toString().trim();
    }

    @Override
    public YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto convertDeletionTaskToProto() {
        YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto.Builder builder = this.getBaseDeletionTaskProtoBuilder();
        builder.setTaskType(DeletionTaskType.DOCKER_CONTAINER.name());
        if (this.getContainerId() != null) {
            builder.setDockerContainerId(this.getContainerId());
        }
        return builder.build();
    }
}

