/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.util.MBeans;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.service.CompositeService;
import org.apache.hadoop.service.Service;
import org.apache.hadoop.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.util.ExitUtil;
import org.apache.hadoop.util.GenericOptionsParser;
import org.apache.hadoop.util.JvmPauseMonitor;
import org.apache.hadoop.util.NodeHealthScriptRunner;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnUncaughtExceptionHandler;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.event.AsyncDispatcher;
import org.apache.hadoop.yarn.event.Dispatcher;
import org.apache.hadoop.yarn.event.EventHandler;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.factory.providers.RecordFactoryProvider;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.api.records.NodeHealthStatus;
import org.apache.hadoop.yarn.server.nodemanager.ContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.ContainerManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.ContainerStateTransitionListener;
import org.apache.hadoop.yarn.server.nodemanager.Context;
import org.apache.hadoop.yarn.server.nodemanager.DefaultContainerExecutor;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.LocalDirsHandlerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeHealthCheckerService;
import org.apache.hadoop.yarn.server.nodemanager.NodeManagerEvent;
import org.apache.hadoop.yarn.server.nodemanager.NodeManagerEventType;
import org.apache.hadoop.yarn.server.nodemanager.NodeManagerMXBean;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitor;
import org.apache.hadoop.yarn.server.nodemanager.NodeResourceMonitorImpl;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdater;
import org.apache.hadoop.yarn.server.nodemanager.NodeStatusUpdaterImpl;
import org.apache.hadoop.yarn.server.nodemanager.ResourceView;
import org.apache.hadoop.yarn.server.nodemanager.collectormanager.NMCollectorService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManager;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.ContainerManagerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.Application;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.application.ApplicationState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.Container;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerEvent;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerImpl;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.container.ContainerState;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.resourceplugin.ResourcePluginManager;
import org.apache.hadoop.yarn.server.nodemanager.logaggregation.tracker.NMLogAggregationStatusTracker;
import org.apache.hadoop.yarn.server.nodemanager.metrics.NodeManagerMetrics;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.ConfigurationNodeAttributesProvider;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.ConfigurationNodeLabelsProvider;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeAttributesProvider;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.NodeLabelsProvider;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.ScriptBasedNodeAttributesProvider;
import org.apache.hadoop.yarn.server.nodemanager.nodelabels.ScriptBasedNodeLabelsProvider;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMLeveldbStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMNullStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.recovery.NMStateStoreService;
import org.apache.hadoop.yarn.server.nodemanager.security.NMContainerTokenSecretManager;
import org.apache.hadoop.yarn.server.nodemanager.security.NMTokenSecretManagerInNM;
import org.apache.hadoop.yarn.server.nodemanager.timelineservice.NMTimelinePublisher;
import org.apache.hadoop.yarn.server.nodemanager.webapp.WebServer;
import org.apache.hadoop.yarn.server.scheduler.OpportunisticContainerAllocator;
import org.apache.hadoop.yarn.server.security.ApplicationACLsManager;
import org.apache.hadoop.yarn.state.MultiStateTransitionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeManager
extends CompositeService
implements EventHandler<NodeManagerEvent>,
NodeManagerMXBean {
    public static final int SHUTDOWN_HOOK_PRIORITY = 30;
    private static final Logger LOG = LoggerFactory.getLogger(NodeManager.class);
    private static long nmStartupTime = System.currentTimeMillis();
    protected final NodeManagerMetrics metrics = NodeManagerMetrics.create();
    private JvmPauseMonitor pauseMonitor;
    private ApplicationACLsManager aclsManager;
    private NodeHealthCheckerService nodeHealthChecker;
    private NodeLabelsProvider nodeLabelsProvider;
    private NodeAttributesProvider nodeAttributesProvider;
    private LocalDirsHandlerService dirsHandler;
    private Context context;
    private AsyncDispatcher dispatcher;
    private ContainerManagerImpl containerManager;
    private NMCollectorService nmCollectorService;
    private NodeStatusUpdater nodeStatusUpdater;
    private AtomicBoolean resyncingWithRM = new AtomicBoolean(false);
    private NodeResourceMonitor nodeResourceMonitor;
    private static CompositeService.CompositeServiceShutdownHook nodeManagerShutdownHook;
    private NMStateStoreService nmStore = null;
    private AtomicBoolean isStopping = new AtomicBoolean(false);
    private boolean rmWorkPreservingRestartEnabled;
    private boolean shouldExitOnShutdownEvent = false;
    private NMLogAggregationStatusTracker nmLogAggregationStatusTracker;

    public NodeManager() {
        super(NodeManager.class.getName());
    }

    public static long getNMStartupTime() {
        return nmStartupTime;
    }

    protected NodeStatusUpdater createNodeStatusUpdater(Context context, Dispatcher dispatcher, NodeHealthCheckerService healthChecker) {
        return new NodeStatusUpdaterImpl(context, dispatcher, healthChecker, this.metrics);
    }

    protected NodeAttributesProvider createNodeAttributesProvider(Configuration conf) throws IOException {
        NodeAttributesProvider attributesProvider = null;
        String providerString = conf.get("yarn.nodemanager.node-attributes.provider", null);
        if (providerString == null || providerString.trim().length() == 0) {
            return attributesProvider;
        }
        switch (providerString.trim().toLowerCase()) {
            case "config": {
                attributesProvider = new ConfigurationNodeAttributesProvider();
                break;
            }
            case "script": {
                attributesProvider = new ScriptBasedNodeAttributesProvider();
                break;
            }
            default: {
                try {
                    Class labelsProviderClass = conf.getClass("yarn.nodemanager.node-attributes.provider", null, NodeAttributesProvider.class);
                    attributesProvider = (NodeAttributesProvider)labelsProviderClass.newInstance();
                    break;
                }
                catch (IllegalAccessException | InstantiationException | RuntimeException e) {
                    LOG.error("Failed to create NodeAttributesProvider based on Configuration", (Throwable)e);
                    throw new IOException("Failed to create NodeAttributesProvider : " + e.getMessage(), e);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Distributed Node Attributes is enabled with provider class as : " + attributesProvider.getClass().toString());
        }
        return attributesProvider;
    }

    protected NodeLabelsProvider createNodeLabelsProvider(Configuration conf) throws IOException {
        NodeLabelsProvider provider = null;
        String providerString = conf.get("yarn.nodemanager.node-labels.provider", null);
        if (providerString == null || providerString.trim().length() == 0) {
            return provider;
        }
        switch (providerString.trim().toLowerCase()) {
            case "config": {
                provider = new ConfigurationNodeLabelsProvider();
                break;
            }
            case "script": {
                provider = new ScriptBasedNodeLabelsProvider();
                break;
            }
            default: {
                try {
                    Class labelsProviderClass = conf.getClass("yarn.nodemanager.node-labels.provider", null, NodeLabelsProvider.class);
                    provider = (NodeLabelsProvider)labelsProviderClass.newInstance();
                    break;
                }
                catch (IllegalAccessException | InstantiationException | RuntimeException e) {
                    LOG.error("Failed to create NodeLabelsProvider based on Configuration", (Throwable)e);
                    throw new IOException("Failed to create NodeLabelsProvider : " + e.getMessage(), e);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Distributed Node Labels is enabled with provider class as : " + provider.getClass().toString());
        }
        return provider;
    }

    protected NodeResourceMonitor createNodeResourceMonitor() {
        return new NodeResourceMonitorImpl(this.context);
    }

    protected ContainerManagerImpl createContainerManager(Context context, ContainerExecutor exec, DeletionService del, NodeStatusUpdater nodeStatusUpdater, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new ContainerManagerImpl(context, exec, del, nodeStatusUpdater, this.metrics, dirsHandler);
    }

    protected NMCollectorService createNMCollectorService(Context ctxt) {
        return new NMCollectorService(ctxt);
    }

    protected WebServer createWebServer(Context nmContext, ResourceView resourceView, ApplicationACLsManager aclsManager, LocalDirsHandlerService dirsHandler) {
        return new WebServer(nmContext, resourceView, aclsManager, dirsHandler);
    }

    protected DeletionService createDeletionService(ContainerExecutor exec) {
        return new DeletionService(exec, this.nmStore);
    }

    protected NMContext createNMContext(NMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInNM nmTokenSecretManager, NMStateStoreService stateStore, boolean isDistSchedulerEnabled, Configuration conf) {
        List listeners = conf.getInstances("yarn.nodemanager.container-state-transition-listener.classes", ContainerStateTransitionListener.class);
        NMContext nmContext = new NMContext(containerTokenSecretManager, nmTokenSecretManager, this.dirsHandler, this.aclsManager, stateStore, isDistSchedulerEnabled, conf);
        nmContext.setNodeManagerMetrics(this.metrics);
        DefaultContainerStateListener defaultListener = new DefaultContainerStateListener();
        nmContext.setContainerStateTransitionListener(defaultListener);
        defaultListener.init(nmContext);
        for (ContainerStateTransitionListener listener : listeners) {
            listener.init(nmContext);
            defaultListener.addListener(listener);
        }
        return nmContext;
    }

    protected void doSecureLogin() throws IOException {
        SecurityUtil.login((Configuration)this.getConfig(), (String)"yarn.nodemanager.keytab", (String)"yarn.nodemanager.principal");
    }

    private void initAndStartRecoveryStore(Configuration conf) throws IOException {
        boolean recoveryEnabled = conf.getBoolean("yarn.nodemanager.recovery.enabled", false);
        if (recoveryEnabled) {
            LocalFileSystem recoveryFs = FileSystem.getLocal((Configuration)conf);
            String recoveryDirName = conf.get("yarn.nodemanager.recovery.dir");
            if (recoveryDirName == null) {
                throw new IllegalArgumentException("Recovery is enabled but yarn.nodemanager.recovery.dir is not set.");
            }
            Path recoveryRoot = new Path(recoveryDirName);
            recoveryFs.mkdirs(recoveryRoot, new FsPermission(448));
            this.nmStore = new NMLeveldbStateStoreService();
        } else {
            this.nmStore = new NMNullStateStoreService();
        }
        this.nmStore.init(conf);
        this.nmStore.start();
    }

    private void stopRecoveryStore() throws IOException {
        if (null != this.nmStore) {
            this.nmStore.stop();
            if (null != this.context && this.context.getDecommissioned() && this.nmStore.canRecover()) {
                LOG.info("Removing state store due to decommission");
                Configuration conf = this.getConfig();
                Path recoveryRoot = new Path(conf.get("yarn.nodemanager.recovery.dir"));
                LOG.info("Removing state store at " + recoveryRoot + " due to decommission");
                LocalFileSystem recoveryFs = FileSystem.getLocal((Configuration)conf);
                if (!recoveryFs.delete(recoveryRoot, true)) {
                    LOG.warn("Unable to delete " + recoveryRoot);
                }
            }
        }
    }

    private void recoverTokens(NMTokenSecretManagerInNM nmTokenSecretManager, NMContainerTokenSecretManager containerTokenSecretManager) throws IOException {
        if (this.nmStore.canRecover()) {
            nmTokenSecretManager.recover();
            containerTokenSecretManager.recover();
        }
    }

    public static NodeHealthScriptRunner getNodeHealthScriptRunner(Configuration conf) {
        String nodeHealthScript = conf.get("yarn.nodemanager.health-checker.script.path");
        if (!NodeHealthScriptRunner.shouldRun((String)nodeHealthScript)) {
            LOG.info("Node Manager health check script is not available or doesn't have execute permission, so not starting the node health script runner.");
            return null;
        }
        long nmCheckintervalTime = conf.getLong("yarn.nodemanager.health-checker.interval-ms", 600000L);
        long scriptTimeout = conf.getLong("yarn.nodemanager.health-checker.script.timeout-ms", 1200000L);
        String[] scriptArgs = conf.getStrings("yarn.nodemanager.health-checker.script.opts", new String[0]);
        boolean runBeforeStartup = conf.getBoolean("yarn.nodemanager.health-checker.run-before-startup", false);
        return new NodeHealthScriptRunner(nodeHealthScript, nmCheckintervalTime, scriptTimeout, scriptArgs, runBeforeStartup);
    }

    @VisibleForTesting
    protected ResourcePluginManager createResourcePluginManager() {
        return new ResourcePluginManager();
    }

    @VisibleForTesting
    protected ContainerExecutor createContainerExecutor(Configuration conf) {
        return (ContainerExecutor)ReflectionUtils.newInstance((Class)conf.getClass("yarn.nodemanager.container-executor.class", DefaultContainerExecutor.class, ContainerExecutor.class), (Configuration)conf);
    }

    protected void serviceInit(Configuration conf) throws Exception {
        UserGroupInformation.setConfiguration((Configuration)conf);
        this.rmWorkPreservingRestartEnabled = conf.getBoolean("yarn.resourcemanager.work-preserving-recovery.enabled", true);
        try {
            this.initAndStartRecoveryStore(conf);
        }
        catch (IOException e) {
            String recoveryDirName = conf.get("yarn.nodemanager.recovery.dir");
            throw new YarnRuntimeException("Unable to initialize recovery directory at " + recoveryDirName, (Throwable)e);
        }
        NMContainerTokenSecretManager containerTokenSecretManager = new NMContainerTokenSecretManager(conf, this.nmStore);
        NMTokenSecretManagerInNM nmTokenSecretManager = new NMTokenSecretManagerInNM(this.nmStore);
        this.recoverTokens(nmTokenSecretManager, containerTokenSecretManager);
        this.aclsManager = new ApplicationACLsManager(conf);
        this.dirsHandler = new LocalDirsHandlerService(this.metrics);
        boolean isDistSchedulingEnabled = conf.getBoolean("yarn.nodemanager.distributed-scheduling.enabled", false);
        this.context = this.createNMContext(containerTokenSecretManager, nmTokenSecretManager, this.nmStore, isDistSchedulingEnabled, conf);
        ResourcePluginManager pluginManager = this.createResourcePluginManager();
        pluginManager.initialize(this.context);
        ((NMContext)this.context).setResourcePluginManager(pluginManager);
        ContainerExecutor exec = this.createContainerExecutor(conf);
        try {
            exec.init(this.context);
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed to initialize container executor", (Throwable)e);
        }
        DeletionService del = this.createDeletionService(exec);
        this.addService((Service)del);
        this.dispatcher = this.createNMDispatcher();
        this.nodeHealthChecker = new NodeHealthCheckerService(NodeManager.getNodeHealthScriptRunner(conf), this.dirsHandler);
        this.addService((Service)this.nodeHealthChecker);
        ((NMContext)this.context).setContainerExecutor(exec);
        ((NMContext)this.context).setDeletionService(del);
        this.nodeStatusUpdater = this.createNodeStatusUpdater(this.context, (Dispatcher)this.dispatcher, this.nodeHealthChecker);
        this.nodeLabelsProvider = this.createNodeLabelsProvider(conf);
        if (this.nodeLabelsProvider != null) {
            this.addIfService(this.nodeLabelsProvider);
            this.nodeStatusUpdater.setNodeLabelsProvider(this.nodeLabelsProvider);
        }
        this.nodeAttributesProvider = this.createNodeAttributesProvider(conf);
        if (this.nodeAttributesProvider != null) {
            this.addIfService(this.nodeAttributesProvider);
            this.nodeStatusUpdater.setNodeAttributesProvider(this.nodeAttributesProvider);
        }
        this.nodeResourceMonitor = this.createNodeResourceMonitor();
        this.addService(this.nodeResourceMonitor);
        ((NMContext)this.context).setNodeResourceMonitor(this.nodeResourceMonitor);
        this.containerManager = this.createContainerManager(this.context, exec, del, this.nodeStatusUpdater, this.aclsManager, this.dirsHandler);
        this.addService((Service)this.containerManager);
        ((NMContext)this.context).setContainerManager(this.containerManager);
        this.nmLogAggregationStatusTracker = this.createNMLogAggregationStatusTracker(this.context);
        this.addService((Service)this.nmLogAggregationStatusTracker);
        ((NMContext)this.context).setNMLogAggregationStatusTracker(this.nmLogAggregationStatusTracker);
        WebServer webServer = this.createWebServer(this.context, this.containerManager.getContainersMonitor(), this.aclsManager, this.dirsHandler);
        this.addService((Service)webServer);
        ((NMContext)this.context).setWebServer(webServer);
        ((NMContext)this.context).setQueueableContainerAllocator(new OpportunisticContainerAllocator(this.context.getContainerTokenSecretManager()));
        this.dispatcher.register(ContainerManagerEventType.class, (EventHandler)this.containerManager);
        this.dispatcher.register(NodeManagerEventType.class, (EventHandler)this);
        this.addService((Service)this.dispatcher);
        this.pauseMonitor = new JvmPauseMonitor();
        this.addService((Service)this.pauseMonitor);
        this.metrics.getJvmMetrics().setPauseMonitor(this.pauseMonitor);
        DefaultMetricsSystem.initialize((String)"NodeManager");
        if (YarnConfiguration.timelineServiceV2Enabled((Configuration)conf)) {
            this.nmCollectorService = this.createNMCollectorService(this.context);
            this.addService((Service)this.nmCollectorService);
        }
        this.addService(this.nodeStatusUpdater);
        ((NMContext)this.context).setNodeStatusUpdater(this.nodeStatusUpdater);
        this.nmStore.setNodeStatusUpdater(this.nodeStatusUpdater);
        try {
            this.doSecureLogin();
        }
        catch (IOException e) {
            throw new YarnRuntimeException("Failed NodeManager login", (Throwable)e);
        }
        this.registerMXBean();
        super.serviceInit(conf);
    }

    protected void serviceStop() throws Exception {
        if (this.isStopping.getAndSet(true)) {
            return;
        }
        try {
            ResourcePluginManager rpm;
            super.serviceStop();
            DefaultMetricsSystem.shutdown();
            if (null != this.context && (rpm = this.context.getResourcePluginManager()) != null) {
                rpm.cleanup();
            }
        }
        finally {
            this.stopRecoveryStore();
        }
    }

    public String getName() {
        return "NodeManager";
    }

    protected void shutDown(final int exitCode) {
        new Thread(){

            @Override
            public void run() {
                try {
                    NodeManager.this.stop();
                }
                catch (Throwable t) {
                    LOG.error("Error while shutting down NodeManager", t);
                }
                finally {
                    if (NodeManager.this.shouldExitOnShutdownEvent && !ShutdownHookManager.get().isShutdownInProgress()) {
                        ExitUtil.terminate((int)exitCode);
                    }
                }
            }
        }.start();
    }

    protected void resyncWithRM() {
        if (!this.resyncingWithRM.getAndSet(true)) {
            new Thread(){

                @Override
                public void run() {
                    try {
                        if (!NodeManager.this.rmWorkPreservingRestartEnabled) {
                            LOG.info("Cleaning up running containers on resync");
                            NodeManager.this.containerManager.cleanupContainersOnNMResync();
                            if (NodeManager.this.context.getKnownCollectors() != null) {
                                NodeManager.this.context.getKnownCollectors().clear();
                            }
                        } else {
                            LOG.info("Preserving containers on resync");
                            NodeManager.this.reregisterCollectors();
                        }
                        ((NodeStatusUpdaterImpl)NodeManager.this.nodeStatusUpdater).rebootNodeStatusUpdaterAndRegisterWithRM();
                    }
                    catch (YarnRuntimeException e) {
                        LOG.error("Error while rebooting NodeStatusUpdater.", (Throwable)e);
                        NodeManager.this.shutDown(NodeManagerStatus.EXCEPTION.getExitCode());
                    }
                    finally {
                        NodeManager.this.resyncingWithRM.set(false);
                    }
                }
            }.start();
        }
    }

    protected void reregisterCollectors() {
        ConcurrentMap<ApplicationId, AppCollectorData> knownCollectors = this.context.getKnownCollectors();
        if (knownCollectors == null) {
            return;
        }
        ConcurrentMap<ApplicationId, AppCollectorData> registeringCollectors = this.context.getRegisteringCollectors();
        for (Map.Entry entry : knownCollectors.entrySet()) {
            Application app = (Application)this.context.getApplications().get(entry.getKey());
            if (app != null && !ApplicationState.FINISHED.equals((Object)app.getApplicationState())) {
                registeringCollectors.putIfAbsent((ApplicationId)entry.getKey(), (AppCollectorData)entry.getValue());
                AppCollectorData data = (AppCollectorData)entry.getValue();
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(entry.getKey() + " : " + data.getCollectorAddr() + "@<" + data.getRMIdentifier() + ", " + data.getVersion() + ">");
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Remove collector data for done app " + entry.getKey());
        }
        knownCollectors.clear();
    }

    public NodeHealthCheckerService getNodeHealthChecker() {
        return this.nodeHealthChecker;
    }

    private void initAndStartNodeManager(Configuration conf, boolean hasToReboot) {
        try {
            if (!Shell.WINDOWS && !Shell.checkIsBashSupported()) {
                String message = "Failing NodeManager start since we're on a Unix-based system but bash doesn't seem to be available.";
                LOG.error(message);
                throw new YarnRuntimeException(message);
            }
            if (hasToReboot && null != nodeManagerShutdownHook) {
                ShutdownHookManager.get().removeShutdownHook((Runnable)nodeManagerShutdownHook);
            }
            nodeManagerShutdownHook = new CompositeService.CompositeServiceShutdownHook((CompositeService)this);
            ShutdownHookManager.get().addShutdownHook((Runnable)nodeManagerShutdownHook, 30);
            this.shouldExitOnShutdownEvent = true;
            this.init(conf);
            this.start();
        }
        catch (Throwable t) {
            LOG.error("Error starting NodeManager", t);
            System.exit(-1);
        }
    }

    public void handle(NodeManagerEvent event) {
        switch ((NodeManagerEventType)event.getType()) {
            case SHUTDOWN: {
                this.shutDown(NodeManagerStatus.NO_ERROR.getExitCode());
                break;
            }
            case RESYNC: {
                this.resyncWithRM();
                break;
            }
            default: {
                LOG.warn("Invalid shutdown event " + event.getType() + ". Ignoring.");
            }
        }
    }

    private void registerMXBean() {
        MBeans.register((String)"NodeManager", (String)"NodeManager", (Object)this);
    }

    @Override
    public boolean isSecurityEnabled() {
        return UserGroupInformation.isSecurityEnabled();
    }

    NodeManager createNewNodeManager() {
        return new NodeManager();
    }

    ContainerManagerImpl getContainerManager() {
        return this.containerManager;
    }

    protected AsyncDispatcher createNMDispatcher() {
        return new AsyncDispatcher("NM Event dispatcher");
    }

    Dispatcher getNMDispatcher() {
        return this.dispatcher;
    }

    @VisibleForTesting
    public Context getNMContext() {
        return this.context;
    }

    @VisibleForTesting
    NMCollectorService getNMCollectorService() {
        return this.nmCollectorService;
    }

    public static void main(String[] args) throws IOException {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new YarnUncaughtExceptionHandler());
        StringUtils.startupShutdownMessage(NodeManager.class, (String[])args, (Logger)LOG);
        NodeManager nodeManager = new NodeManager();
        YarnConfiguration conf = new YarnConfiguration();
        new GenericOptionsParser((Configuration)conf, args);
        nodeManager.initAndStartNodeManager((Configuration)conf, false);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    public NodeStatusUpdater getNodeStatusUpdater() {
        return this.nodeStatusUpdater;
    }

    private NMLogAggregationStatusTracker createNMLogAggregationStatusTracker(Context ctxt) {
        return new NMLogAggregationStatusTracker(ctxt);
    }

    public static class NMContext
    implements Context {
        private NodeId nodeId = null;
        private Configuration conf = null;
        private NodeManagerMetrics metrics = null;
        protected final ConcurrentMap<ApplicationId, Application> applications = new ConcurrentHashMap<ApplicationId, Application>();
        private volatile Map<ApplicationId, Credentials> systemCredentials = new HashMap<ApplicationId, Credentials>();
        protected final ConcurrentMap<ContainerId, Container> containers = new ConcurrentSkipListMap<ContainerId, Container>();
        private ConcurrentMap<ApplicationId, AppCollectorData> registeringCollectors;
        private ConcurrentMap<ApplicationId, AppCollectorData> knownCollectors;
        protected final ConcurrentMap<ContainerId, org.apache.hadoop.yarn.api.records.Container> increasedContainers = new ConcurrentHashMap<ContainerId, org.apache.hadoop.yarn.api.records.Container>();
        private final NMContainerTokenSecretManager containerTokenSecretManager;
        private final NMTokenSecretManagerInNM nmTokenSecretManager;
        private ContainerManager containerManager;
        private NodeResourceMonitor nodeResourceMonitor;
        private final LocalDirsHandlerService dirsHandler;
        private final ApplicationACLsManager aclsManager;
        private WebServer webServer;
        private final NodeHealthStatus nodeHealthStatus = (NodeHealthStatus)RecordFactoryProvider.getRecordFactory(null).newRecordInstance(NodeHealthStatus.class);
        private final NMStateStoreService stateStore;
        private boolean isDecommissioned = false;
        private final ConcurrentLinkedQueue<LogAggregationReport> logAggregationReportForApps;
        private NodeStatusUpdater nodeStatusUpdater;
        private final boolean isDistSchedulingEnabled;
        private DeletionService deletionService;
        private OpportunisticContainerAllocator containerAllocator;
        private ContainerExecutor executor;
        private NMTimelinePublisher nmTimelinePublisher;
        private ContainerStateTransitionListener containerStateTransitionListener;
        private ResourcePluginManager resourcePluginManager;
        private NMLogAggregationStatusTracker nmLogAggregationStatusTracker;

        public NMContext(NMContainerTokenSecretManager containerTokenSecretManager, NMTokenSecretManagerInNM nmTokenSecretManager, LocalDirsHandlerService dirsHandler, ApplicationACLsManager aclsManager, NMStateStoreService stateStore, boolean isDistSchedulingEnabled, Configuration conf) {
            if (YarnConfiguration.timelineServiceV2Enabled((Configuration)conf)) {
                this.registeringCollectors = new ConcurrentHashMap<ApplicationId, AppCollectorData>();
                this.knownCollectors = new ConcurrentHashMap<ApplicationId, AppCollectorData>();
            }
            this.containerTokenSecretManager = containerTokenSecretManager;
            this.nmTokenSecretManager = nmTokenSecretManager;
            this.dirsHandler = dirsHandler;
            this.aclsManager = aclsManager;
            this.nodeHealthStatus.setIsNodeHealthy(true);
            this.nodeHealthStatus.setHealthReport("Healthy");
            this.nodeHealthStatus.setLastHealthReportTime(System.currentTimeMillis());
            this.stateStore = stateStore;
            this.logAggregationReportForApps = new ConcurrentLinkedQueue();
            this.isDistSchedulingEnabled = isDistSchedulingEnabled;
            this.conf = conf;
        }

        @Override
        public NodeId getNodeId() {
            return this.nodeId;
        }

        @Override
        public int getHttpPort() {
            return this.webServer.getPort();
        }

        @Override
        public ConcurrentMap<ApplicationId, Application> getApplications() {
            return this.applications;
        }

        @Override
        public Configuration getConf() {
            return this.conf;
        }

        @Override
        public ConcurrentMap<ContainerId, Container> getContainers() {
            return this.containers;
        }

        @Override
        public ConcurrentMap<ContainerId, org.apache.hadoop.yarn.api.records.Container> getIncreasedContainers() {
            return this.increasedContainers;
        }

        @Override
        public NMContainerTokenSecretManager getContainerTokenSecretManager() {
            return this.containerTokenSecretManager;
        }

        @Override
        public NMTokenSecretManagerInNM getNMTokenSecretManager() {
            return this.nmTokenSecretManager;
        }

        @Override
        public NodeHealthStatus getNodeHealthStatus() {
            return this.nodeHealthStatus;
        }

        @Override
        public NodeResourceMonitor getNodeResourceMonitor() {
            return this.nodeResourceMonitor;
        }

        public void setNodeResourceMonitor(NodeResourceMonitor nodeResourceMonitor) {
            this.nodeResourceMonitor = nodeResourceMonitor;
        }

        @Override
        public ContainerManager getContainerManager() {
            return this.containerManager;
        }

        public void setContainerManager(ContainerManager containerManager) {
            this.containerManager = containerManager;
        }

        public void setWebServer(WebServer webServer) {
            this.webServer = webServer;
        }

        public void setNodeId(NodeId nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public LocalDirsHandlerService getLocalDirsHandler() {
            return this.dirsHandler;
        }

        @Override
        public ApplicationACLsManager getApplicationACLsManager() {
            return this.aclsManager;
        }

        @Override
        public NMStateStoreService getNMStateStore() {
            return this.stateStore;
        }

        @Override
        public boolean getDecommissioned() {
            return this.isDecommissioned;
        }

        @Override
        public void setDecommissioned(boolean isDecommissioned) {
            this.isDecommissioned = isDecommissioned;
        }

        @Override
        public Map<ApplicationId, Credentials> getSystemCredentialsForApps() {
            return this.systemCredentials;
        }

        public void setSystemCrendentialsForApps(Map<ApplicationId, Credentials> systemCredentials) {
            this.systemCredentials = systemCredentials;
        }

        @Override
        public ConcurrentLinkedQueue<LogAggregationReport> getLogAggregationStatusForApps() {
            return this.logAggregationReportForApps;
        }

        @Override
        public NodeStatusUpdater getNodeStatusUpdater() {
            return this.nodeStatusUpdater;
        }

        public void setNodeStatusUpdater(NodeStatusUpdater nodeStatusUpdater) {
            this.nodeStatusUpdater = nodeStatusUpdater;
        }

        @Override
        public boolean isDistributedSchedulingEnabled() {
            return this.isDistSchedulingEnabled;
        }

        public void setQueueableContainerAllocator(OpportunisticContainerAllocator containerAllocator) {
            this.containerAllocator = containerAllocator;
        }

        @Override
        public OpportunisticContainerAllocator getContainerAllocator() {
            return this.containerAllocator;
        }

        @Override
        public ConcurrentMap<ApplicationId, AppCollectorData> getRegisteringCollectors() {
            return this.registeringCollectors;
        }

        @Override
        public ConcurrentMap<ApplicationId, AppCollectorData> getKnownCollectors() {
            return this.knownCollectors;
        }

        @Override
        public void setNMTimelinePublisher(NMTimelinePublisher nmMetricsPublisher) {
            this.nmTimelinePublisher = nmMetricsPublisher;
        }

        @Override
        public NMTimelinePublisher getNMTimelinePublisher() {
            return this.nmTimelinePublisher;
        }

        @Override
        public ContainerExecutor getContainerExecutor() {
            return this.executor;
        }

        public void setContainerExecutor(ContainerExecutor executor) {
            this.executor = executor;
        }

        @Override
        public ContainerStateTransitionListener getContainerStateTransitionListener() {
            return this.containerStateTransitionListener;
        }

        public void setContainerStateTransitionListener(ContainerStateTransitionListener transitionListener) {
            this.containerStateTransitionListener = transitionListener;
        }

        @Override
        public ResourcePluginManager getResourcePluginManager() {
            return this.resourcePluginManager;
        }

        @Override
        public NodeManagerMetrics getNodeManagerMetrics() {
            return this.metrics;
        }

        public void setNodeManagerMetrics(NodeManagerMetrics nmMetrics) {
            this.metrics = nmMetrics;
        }

        public void setResourcePluginManager(ResourcePluginManager resourcePluginManager) {
            this.resourcePluginManager = resourcePluginManager;
        }

        @Override
        public DeletionService getDeletionService() {
            return this.deletionService;
        }

        public void setDeletionService(DeletionService deletionService) {
            this.deletionService = deletionService;
        }

        public void setNMLogAggregationStatusTracker(NMLogAggregationStatusTracker nmLogAggregationStatusTracker) {
            this.nmLogAggregationStatusTracker = nmLogAggregationStatusTracker;
        }

        @Override
        public NMLogAggregationStatusTracker getNMLogAggregationStatusTracker() {
            return this.nmLogAggregationStatusTracker;
        }
    }

    public static class DefaultContainerStateListener
    extends MultiStateTransitionListener<ContainerImpl, ContainerEvent, ContainerState>
    implements ContainerStateTransitionListener {
        @Override
        public void init(Context context) {
        }
    }

    public static enum NodeManagerStatus {
        NO_ERROR(0),
        EXCEPTION(1);

        private int exitCode;

        private NodeManagerStatus(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

