/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.federation.store.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.google.protobuf.MessageOrBuilder;
import org.apache.hadoop.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.impl.pb.ApplicationIdPBImpl;
import org.apache.hadoop.yarn.federation.proto.YarnServerFederationProtos;
import org.apache.hadoop.yarn.proto.YarnProtos;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.impl.pb.SubClusterIdPBImpl;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationHomeSubClusterPBImpl
extends ApplicationHomeSubCluster {
    private YarnServerFederationProtos.ApplicationHomeSubClusterProto proto = YarnServerFederationProtos.ApplicationHomeSubClusterProto.getDefaultInstance();
    private YarnServerFederationProtos.ApplicationHomeSubClusterProto.Builder builder = null;
    private boolean viaProto = false;
    private ApplicationId applicationId = null;
    private SubClusterId homeSubCluster = null;

    public ApplicationHomeSubClusterPBImpl() {
        this.builder = YarnServerFederationProtos.ApplicationHomeSubClusterProto.newBuilder();
    }

    public ApplicationHomeSubClusterPBImpl(YarnServerFederationProtos.ApplicationHomeSubClusterProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public YarnServerFederationProtos.ApplicationHomeSubClusterProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnServerFederationProtos.ApplicationHomeSubClusterProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    private void mergeLocalToBuilder() {
        if (this.applicationId != null) {
            this.builder.setApplicationId(this.convertToProtoFormat(this.applicationId));
        }
        if (this.homeSubCluster != null) {
            this.builder.setHomeSubCluster(this.convertToProtoFormat(this.homeSubCluster));
        }
    }

    @Override
    public int hashCode() {
        return this.getProto().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ApplicationHomeSubClusterPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    @Override
    public String toString() {
        return TextFormat.shortDebugString((MessageOrBuilder)this.getProto());
    }

    @Override
    public ApplicationId getApplicationId() {
        YarnServerFederationProtos.ApplicationHomeSubClusterProtoOrBuilder p;
        YarnServerFederationProtos.ApplicationHomeSubClusterProtoOrBuilder applicationHomeSubClusterProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (!p.hasApplicationId()) {
            return null;
        }
        this.applicationId = this.convertFromProtoFormat(p.getApplicationId());
        return this.applicationId;
    }

    @Override
    public void setApplicationId(ApplicationId applicationId) {
        this.maybeInitBuilder();
        if (applicationId == null) {
            this.builder.clearApplicationId();
            return;
        }
        this.applicationId = applicationId;
    }

    @Override
    public SubClusterId getHomeSubCluster() {
        YarnServerFederationProtos.ApplicationHomeSubClusterProtoOrBuilder p;
        YarnServerFederationProtos.ApplicationHomeSubClusterProtoOrBuilder applicationHomeSubClusterProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.homeSubCluster != null) {
            return this.homeSubCluster;
        }
        if (!p.hasHomeSubCluster()) {
            return null;
        }
        this.homeSubCluster = this.convertFromProtoFormat(p.getHomeSubCluster());
        return this.homeSubCluster;
    }

    @Override
    public void setHomeSubCluster(SubClusterId homeSubCluster) {
        this.maybeInitBuilder();
        if (homeSubCluster == null) {
            this.builder.clearHomeSubCluster();
        }
        this.homeSubCluster = homeSubCluster;
    }

    private SubClusterId convertFromProtoFormat(YarnServerFederationProtos.SubClusterIdProto subClusterId) {
        return new SubClusterIdPBImpl(subClusterId);
    }

    private YarnServerFederationProtos.SubClusterIdProto convertToProtoFormat(SubClusterId subClusterId) {
        return ((SubClusterIdPBImpl)subClusterId).getProto();
    }

    private ApplicationId convertFromProtoFormat(YarnProtos.ApplicationIdProto appId) {
        return new ApplicationIdPBImpl(appId);
    }

    private YarnProtos.ApplicationIdProto convertToProtoFormat(ApplicationId appId) {
        return ((ApplicationIdPBImpl)appId).getProto();
    }
}

