/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.terracotta.offheapstore;

import java.nio.ByteBuffer;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.MetadataTuple;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.OffHeapHashMap;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.Segment;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.jdk8.BiFunction;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.jdk8.Function;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.paging.PageSource;
import org.apache.hadoop.shaded.org.terracotta.offheapstore.storage.StorageEngine;

public abstract class AbstractLockedOffHeapHashMap<K, V>
extends OffHeapHashMap<K, V>
implements Segment<K, V> {
    private Set<Map.Entry<K, V>> entrySet;
    private Set<K> keySet;
    private Collection<V> values;

    public AbstractLockedOffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine) {
        super(source, storageEngine);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine) {
        super(source, tableAllocationsSteal, storageEngine);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, boolean bootstrap) {
        super(source, storageEngine, bootstrap);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        super(source, storageEngine, tableSize);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, boolean tableAllocationsSteal, StorageEngine<? super K, ? super V> storageEngine, int tableSize) {
        super(source, tableAllocationsSteal, storageEngine, tableSize);
    }

    public AbstractLockedOffHeapHashMap(PageSource source, StorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap) {
        super(source, false, storageEngine, tableSize, bootstrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Lock l = this.readLock();
        l.lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsKey(Object key) {
        Lock l = this.readLock();
        l.lock();
        try {
            boolean bl = super.containsKey(key);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        Lock l = this.readLock();
        l.lock();
        try {
            Object v = super.get(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getEncodingForHashAndBinary(int hash, ByteBuffer binaryKey) {
        Lock l = this.readLock();
        l.lock();
        try {
            Long l2 = super.getEncodingForHashAndBinary(hash, binaryKey);
            return l2;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long installMappingForHashAndEncoding(int pojoHash, ByteBuffer offheapBinaryKey, ByteBuffer offheapBinaryValue, int metadata) {
        Lock l = this.writeLock();
        l.lock();
        try {
            long l2 = super.installMappingForHashAndEncoding(pojoHash, offheapBinaryKey, offheapBinaryValue, metadata);
            return l2;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        Lock l = this.writeLock();
        l.lock();
        try {
            V v = super.put(key, value);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value, int metadata) {
        Lock l = this.writeLock();
        l.lock();
        try {
            V v = super.put(key, value, metadata);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V fill(K key, V value) {
        Lock l = this.writeLock();
        l.lock();
        try {
            V v = super.fill(key, value);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V fill(K key, V value, int metadata) {
        Lock l = this.writeLock();
        l.lock();
        try {
            V v = super.fill(key, value, metadata);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V remove(Object key) {
        Lock l = this.writeLock();
        l.lock();
        try {
            Object v = super.remove(key);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeNoReturn(Object key) {
        Lock l = this.writeLock();
        l.lock();
        try {
            boolean bl = super.removeNoReturn(key);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Lock l = this.writeLock();
        l.lock();
        try {
            super.clear();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V putIfAbsent(K key, V value) {
        Lock l = this.writeLock();
        l.lock();
        try {
            if (key == null || value == null) {
                throw new NullPointerException();
            }
            V existing = this.get(key);
            if (existing == null) {
                this.put(key, value);
            }
            V v = existing;
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object key, Object value) {
        Lock l = this.writeLock();
        l.lock();
        try {
            if (key == null) {
                throw new NullPointerException();
            }
            if (value == null) {
                boolean bl = false;
                return bl;
            }
            V existing = this.get(key);
            if (value.equals(existing)) {
                this.remove(key);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        Lock l = this.writeLock();
        l.lock();
        try {
            V existing = this.get(key);
            if (oldValue.equals(existing)) {
                this.put(key, newValue);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V replace(K key, V value) {
        Lock l = this.writeLock();
        l.lock();
        try {
            if (value == null || key == null) {
                throw new NullPointerException();
            }
            V existing = this.get(key);
            if (existing != null) {
                this.put(key, value);
            }
            V v = existing;
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getMetadata(Object key, int mask) {
        Lock l = this.readLock();
        l.lock();
        try {
            Integer n = super.getMetadata(key, mask);
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer getAndSetMetadata(Object key, int mask, int values) {
        Lock l = this.writeLock();
        l.lock();
        try {
            Integer n = super.getAndSetMetadata(key, mask, values);
            return n;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V getValueAndSetMetadata(Object key, int mask, int values) {
        Lock l = this.writeLock();
        l.lock();
        try {
            Object v = super.getValueAndSetMetadata(key, mask, values);
            return v;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean removeMapping(Object o) {
        Lock l = this.writeLock();
        l.lock();
        try {
            boolean bl = super.removeMapping(o);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evict(int index, boolean shrink) {
        Lock l = this.writeLock();
        l.lock();
        try {
            boolean bl = super.evict(index, shrink);
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LockedEntrySet es = this.entrySet;
        return es == null ? (this.entrySet = new LockedEntrySet()) : es;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new LockedKeySet();
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private final Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = AbstractLockedOffHeapHashMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return AbstractLockedOffHeapHashMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractLockedOffHeapHashMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    AbstractLockedOffHeapHashMap.this.clear();
                }

                @Override
                public boolean contains(Object v) {
                    return AbstractLockedOffHeapHashMap.this.containsValue(v);
                }
            };
        }
        return this.values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        Lock l = this.writeLock();
        l.lock();
        try {
            super.destroy();
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shrink() {
        Lock l = this.writeLock();
        l.lock();
        try {
            boolean bl = this.storageEngine.shrink();
            return bl;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public abstract Lock readLock();

    @Override
    public abstract Lock writeLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataTuple<V> computeWithMetadata(K key, BiFunction<? super K, ? super MetadataTuple<V>, ? extends MetadataTuple<V>> remappingFunction) {
        Lock l = this.writeLock();
        l.lock();
        try {
            MetadataTuple metadataTuple = super.computeWithMetadata(key, remappingFunction);
            return metadataTuple;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataTuple<V> computeIfAbsentWithMetadata(K key, Function<? super K, ? extends MetadataTuple<V>> mappingFunction) {
        Lock l = this.writeLock();
        l.lock();
        try {
            MetadataTuple metadataTuple = super.computeIfAbsentWithMetadata(key, mappingFunction);
            return metadataTuple;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataTuple<V> computeIfPresentWithMetadata(K key, BiFunction<? super K, ? super MetadataTuple<V>, ? extends MetadataTuple<V>> remappingFunction) {
        Lock l = this.writeLock();
        l.lock();
        try {
            MetadataTuple metadataTuple = super.computeIfPresentWithMetadata(key, remappingFunction);
            return metadataTuple;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<K, V> removeAllWithHash(int hash) {
        Lock l = this.writeLock();
        l.lock();
        try {
            Map map = super.removeAllWithHash(hash);
            return map;
        }
        finally {
            l.unlock();
        }
    }

    class LockedKeyIterator
    extends OffHeapHashMap.KeyIterator {
        LockedKeyIterator() {
            super(AbstractLockedOffHeapHashMap.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K next() {
            Lock l = AbstractLockedOffHeapHashMap.this.readLock();
            l.lock();
            try {
                Object t = super.next();
                return t;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Lock l = AbstractLockedOffHeapHashMap.this.writeLock();
            l.lock();
            try {
                super.remove();
            }
            finally {
                l.unlock();
            }
        }

        @Override
        protected void checkForConcurrentModification() {
        }
    }

    class LockedKeySet
    extends AbstractSet<K> {
        LockedKeySet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<K> iterator() {
            Lock l = AbstractLockedOffHeapHashMap.this.readLock();
            l.lock();
            try {
                LockedKeyIterator lockedKeyIterator = new LockedKeyIterator();
                return lockedKeyIterator;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public boolean contains(Object o) {
            return AbstractLockedOffHeapHashMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLockedOffHeapHashMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return AbstractLockedOffHeapHashMap.this.size();
        }

        @Override
        public void clear() {
            AbstractLockedOffHeapHashMap.this.clear();
        }
    }

    class LockedEntryIterator
    extends OffHeapHashMap.EntryIterator {
        LockedEntryIterator() {
            super(AbstractLockedOffHeapHashMap.this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Map.Entry<K, V> next() {
            Lock l = AbstractLockedOffHeapHashMap.this.readLock();
            l.lock();
            try {
                Map.Entry entry = (Map.Entry)super.next();
                return entry;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove() {
            Lock l = AbstractLockedOffHeapHashMap.this.writeLock();
            l.lock();
            try {
                super.remove();
            }
            finally {
                l.unlock();
            }
        }

        @Override
        protected void checkForConcurrentModification() {
        }
    }

    class LockedEntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        LockedEntrySet() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            Lock l = AbstractLockedOffHeapHashMap.this.readLock();
            l.lock();
            try {
                LockedEntryIterator lockedEntryIterator = new LockedEntryIterator();
                return lockedEntryIterator;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Lock l = AbstractLockedOffHeapHashMap.this.readLock();
            l.lock();
            try {
                Object value = AbstractLockedOffHeapHashMap.this.get(e.getKey());
                boolean bl = value != null && value.equals(e.getValue());
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        @Override
        public boolean remove(Object o) {
            return AbstractLockedOffHeapHashMap.this.removeMapping(o);
        }

        @Override
        public int size() {
            return AbstractLockedOffHeapHashMap.this.size();
        }

        @Override
        public void clear() {
            AbstractLockedOffHeapHashMap.this.clear();
        }
    }
}

