/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.s3guard;

import java.util.LinkedHashMap;
import java.util.Map;

public class LruHashMap<K, V>
extends LinkedHashMap<K, V> {
    private final int maxSize;

    public LruHashMap(int initialCapacity, int maxSize) {
        super(initialCapacity);
        this.maxSize = maxSize;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maxSize;
    }

    public V mruGet(K key) {
        Object val = this.remove(key);
        if (val != null) {
            this.put(key, val);
        }
        return val;
    }
}

