/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.mockito.internal.util.concurrent;

import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.shaded.org.mockito.internal.util.concurrent.WeakConcurrentMap;

public class WeakConcurrentSet<V>
implements Runnable,
Iterable<V> {
    final WeakConcurrentMap<V, Boolean> target;

    public WeakConcurrentSet(Cleaner cleaner) {
        switch (cleaner) {
            case INLINE: {
                this.target = new WeakConcurrentMap.WithInlinedExpunction<V, Boolean>();
                break;
            }
            case THREAD: 
            case MANUAL: {
                this.target = new WeakConcurrentMap(cleaner == Cleaner.THREAD);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    public boolean add(V value) {
        return this.target.put((Boolean)value, Boolean.TRUE) == null;
    }

    public boolean contains(V value) {
        return this.target.containsKey(value);
    }

    public boolean remove(V value) {
        return this.target.remove(value);
    }

    public void clear() {
        this.target.clear();
    }

    public int approximateSize() {
        return this.target.approximateSize();
    }

    @Override
    public void run() {
        this.target.run();
    }

    public void expungeStaleEntries() {
        this.target.expungeStaleEntries();
    }

    public Thread getCleanerThread() {
        return this.target.getCleanerThread();
    }

    @Override
    public Iterator<V> iterator() {
        return new ReducingIterator(this.target.iterator());
    }

    private static class ReducingIterator<V>
    implements Iterator<V> {
        private final Iterator<Map.Entry<V, Boolean>> iterator;

        private ReducingIterator(Iterator<Map.Entry<V, Boolean>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        @Override
        public V next() {
            return this.iterator.next().getKey();
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }
    }

    public static enum Cleaner {
        THREAD,
        INLINE,
        MANUAL;

    }
}

