/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.IOException;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DFSOutputStream;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;

public class DFSClientAdapter {
    public static DFSClient getDFSClient(DistributedFileSystem dfs) {
        return dfs.dfs;
    }

    public static void setDFSClient(DistributedFileSystem dfs, DFSClient client) {
        dfs.dfs = client;
    }

    public static void stopLeaseRenewer(DistributedFileSystem dfs) throws IOException {
        try {
            dfs.dfs.getLeaseRenewer().interruptAndJoin();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static LocatedBlocks callGetBlockLocations(ClientProtocol namenode, String src, long start, long length) throws IOException {
        return DFSClient.callGetBlockLocations((ClientProtocol)namenode, (String)src, (long)start, (long)length);
    }

    public static ClientProtocol getNamenode(DFSClient client) throws IOException {
        return client.namenode;
    }

    public static DFSClient getClient(DistributedFileSystem dfs) throws IOException {
        return dfs.dfs;
    }

    public static ExtendedBlock getPreviousBlock(DFSClient client, String renewLeaseKey) {
        return client.getPreviousBlock(renewLeaseKey);
    }

    public static long getFileId(DFSOutputStream out) {
        return out.getFileId();
    }
}

