/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.xbill.DNS.dnssec;

import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPublicKey;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.apache.hadoop.shaded.org.xbill.DNS.DClass;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSKEYRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.DNSSEC;
import org.apache.hadoop.shaded.org.xbill.DNS.DSRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Message;
import org.apache.hadoop.shaded.org.xbill.DNS.NSECRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.Name;
import org.apache.hadoop.shaded.org.xbill.DNS.NameTooLongException;
import org.apache.hadoop.shaded.org.xbill.DNS.RRSIGRecord;
import org.apache.hadoop.shaded.org.xbill.DNS.RRset;
import org.apache.hadoop.shaded.org.xbill.DNS.Record;
import org.apache.hadoop.shaded.org.xbill.DNS.Type;
import org.apache.hadoop.shaded.org.xbill.DNS.dnssec.AlgorithmRequirements;
import org.apache.hadoop.shaded.org.xbill.DNS.dnssec.DnsSecVerifier;
import org.apache.hadoop.shaded.org.xbill.DNS.dnssec.JustifiedSecStatus;
import org.apache.hadoop.shaded.org.xbill.DNS.dnssec.KeyEntry;
import org.apache.hadoop.shaded.org.xbill.DNS.dnssec.R;
import org.apache.hadoop.shaded.org.xbill.DNS.dnssec.ResponseClassification;
import org.apache.hadoop.shaded.org.xbill.DNS.dnssec.SMessage;
import org.apache.hadoop.shaded.org.xbill.DNS.dnssec.SRRset;
import org.apache.hadoop.shaded.org.xbill.DNS.dnssec.SecurityStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ValUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ValUtils.class);
    public static final String DIGEST_PREFERENCE = "dnsjava.dnssec.digest_preference";
    public static final String DIGEST_ENABLED = "dnsjava.dnssec.digest";
    public static final String DIGEST_HARDEN_DOWNGRADE = "dnsjava.dnssec.harden_algo_downgrade";
    public static final String ALGORITHM_ENABLED = "dnsjava.dnssec.algorithm";
    public static final String ALGORITHM_RSA_MIN_KEY_SIZE = "dnsjava.dnssec.algorithm_rsa_min_key_size";
    public static final String MAX_DS_MATCH_FAILURES_PROPERTY = "dnsjava.dnssec.max_ds_match_failures";
    private static final Name WILDCARD = Name.fromConstantString("*");
    private final DnsSecVerifier verifier;
    private int[] digestPreference = null;
    private Properties config = null;
    private boolean digestHardenDowngrade = true;
    private int minRsaKeySize = 1024;
    private boolean hasGost = Security.getProviders("MessageDigest.GOST3411") != null;
    private boolean hasEd25519 = Security.getProviders("KeyFactory.Ed25519") != null;
    private boolean hasEd448 = Security.getProviders("KeyFactory.Ed448") != null;
    private int maxDsMatchFailures = 4;

    public ValUtils() {
        this.verifier = new DnsSecVerifier(this);
    }

    public static void setCanonicalNsecOwner(SRRset set, RRSIGRecord sig) {
        if (set.getType() != 47) {
            return;
        }
        Record nsec = set.first();
        int fqdnLabelCount = nsec.getName().labels() - 1;
        if (nsec.getName().isWild()) {
            --fqdnLabelCount;
        }
        if (sig.getLabels() == fqdnLabelCount) {
            set.setName(nsec.getName());
        } else if (sig.getLabels() < fqdnLabelCount) {
            set.setName(nsec.getName().wild(sig.getSigner().labels() - sig.getLabels()));
        } else {
            throw new IllegalArgumentException("invalid nsec record");
        }
    }

    public void init(Properties config) {
        this.hasGost = Security.getProviders("MessageDigest.GOST3411") != null;
        this.hasEd25519 = Security.getProviders("KeyFactory.Ed25519") != null;
        this.hasEd448 = Security.getProviders("KeyFactory.Ed448") != null;
        this.config = config;
        String dp = config.getProperty(DIGEST_PREFERENCE);
        if (dp != null) {
            String[] dpdata = dp.split(",");
            this.digestPreference = new int[dpdata.length];
            for (int i = 0; i < dpdata.length; ++i) {
                this.digestPreference[i] = Integer.parseInt(dpdata[i]);
                if (this.isDigestSupported(this.digestPreference[i])) continue;
                throw new IllegalArgumentException("Unsupported or disabled digest ID in digest preferences");
            }
        }
        this.digestHardenDowngrade = Boolean.parseBoolean(config.getProperty(DIGEST_HARDEN_DOWNGRADE, Boolean.TRUE.toString()));
        this.minRsaKeySize = Integer.parseInt(config.getProperty(ALGORITHM_RSA_MIN_KEY_SIZE, Integer.toString(this.minRsaKeySize)));
        this.maxDsMatchFailures = Integer.parseInt(config.getProperty(MAX_DS_MATCH_FAILURES_PROPERTY, Integer.toString(this.maxDsMatchFailures)));
        this.verifier.init(config);
    }

    public static ResponseClassification classifyResponse(Message request, SMessage m4) {
        if (m4.getRcode() == 3 && m4.getCount(1) == 0) {
            return ResponseClassification.NAMEERROR;
        }
        if (!request.getHeader().getFlag(7) && m4.getCount(1) == 0 && m4.getRcode() != 0) {
            boolean sawNs = false;
            for (RRset rRset : m4.getSectionRRsets(2)) {
                if (rRset.getType() == 6) {
                    return ResponseClassification.NODATA;
                }
                if (rRset.getType() == 43) {
                    return ResponseClassification.REFERRAL;
                }
                if (rRset.getType() != 2) continue;
                sawNs = true;
            }
            return sawNs ? ResponseClassification.REFERRAL : ResponseClassification.NODATA;
        }
        if (m4.getSectionRRsets(2).isEmpty() && m4.getSectionRRsets(1).size() == 1 && m4.getRcode() == 0 && m4.getSectionRRsets(1).get(0).getType() == 2 && !m4.getSectionRRsets(1).get(0).getName().equals(request.getQuestion().getName())) {
            return ResponseClassification.REFERRAL;
        }
        if (m4.getRcode() != 0 && m4.getRcode() != 3) {
            return ResponseClassification.UNKNOWN;
        }
        if (m4.getRcode() == 0 && m4.getCount(1) == 0) {
            return ResponseClassification.NODATA;
        }
        int qtype = m4.getQuestion().getType();
        if (qtype == 255) {
            return ResponseClassification.ANY;
        }
        boolean hadCname = false;
        for (RRset rRset : m4.getSectionRRsets(1)) {
            if (rRset.getType() == qtype) {
                return ResponseClassification.POSITIVE;
            }
            if (rRset.getType() != 5 && rRset.getType() != 39) continue;
            hadCname = true;
            if (qtype != 43) continue;
            return ResponseClassification.CNAME;
        }
        if (hadCname) {
            if (m4.getRcode() == 3) {
                return ResponseClassification.CNAME_NAMEERROR;
            }
            return ResponseClassification.CNAME_NODATA;
        }
        log.warn("Failed to classify response message:\n{}", (Object)m4);
        return ResponseClassification.UNKNOWN;
    }

    public KeyEntry verifyNewDNSKEYs(SRRset dnskeyRrset, SRRset dsRrset, long badKeyTTL, Instant date) {
        int alg;
        KeyEntry ke;
        int favoriteDigestID;
        if (!dnskeyRrset.getName().equals(dsRrset.getName())) {
            KeyEntry ke2 = KeyEntry.newBadKeyEntry(dsRrset.getName(), dsRrset.getDClass(), badKeyTTL);
            ke2.setBadReason(6, R.get("dnskey.no_name_match", new Object[0]));
            return ke2;
        }
        AlgorithmRequirements needs = null;
        List<Integer> sigalg = null;
        if (this.digestHardenDowngrade) {
            favoriteDigestID = this.favoriteDSDigestID(dsRrset);
            needs = new AlgorithmRequirements(this);
            sigalg = needs.initDs(dsRrset, favoriteDigestID);
            log.trace("Favorite DigestID for rrset {}/DNSKEY is {} ({})", new Object[]{dnskeyRrset.getName(), favoriteDigestID, DNSSEC.Digest.string(favoriteDigestID)});
        } else {
            favoriteDigestID = -1;
        }
        boolean hasAlgoRefusal = false;
        boolean hasCheckedDs = false;
        boolean hasUsefulDs = false;
        JustifiedSecStatus lastVerificationResult = null;
        AtomicInteger numDsChecked = new AtomicInteger(0);
        for (Record dsr : dsRrset.rrs(false)) {
            DSRecord ds = (DSRecord)dsr;
            if (!this.isDigestSupported(ds.getDigestID())) {
                log.debug("Digest ID {} ({}) is not supported", (Object)ds.getDigestID(), (Object)DNSSEC.Digest.string(ds.getDigestID()));
                continue;
            }
            if (!this.isAlgorithmSupported(ds.getAlgorithm())) {
                log.debug("Algorithm {} ({}) is not supported", (Object)ds.getAlgorithm(), (Object)DNSSEC.Algorithm.string(ds.getAlgorithm()));
                continue;
            }
            if (needs != null && ds.getDigestID() != favoriteDigestID) {
                log.debug("Downgrade protection prevents using digest ID {} ({})", (Object)ds.getDigestID(), (Object)DNSSEC.Digest.string(ds.getDigestID()));
                continue;
            }
            lastVerificationResult = this.verifyDnskeysWithDs(dnskeyRrset, ds, date, numDsChecked);
            if (lastVerificationResult.status == SecurityStatus.INSECURE) {
                log.debug("Algorithm {} ({}) refused", (Object)ds.getAlgorithm(), (Object)DNSSEC.Algorithm.string(ds.getAlgorithm()));
                hasAlgoRefusal = true;
                continue;
            }
            if (numDsChecked.get() > 0) {
                log.debug("Checked #{} DS", (Object)numDsChecked.get());
                hasCheckedDs = true;
            }
            hasUsefulDs = true;
            if (lastVerificationResult.status == SecurityStatus.SECURE) {
                if (needs != null && !needs.setSecure(ds.getAlgorithm())) continue;
                if (!this.isKeySizeSupported(dnskeyRrset)) {
                    log.debug("DS {} (footprint={}, id={}, alg={}) works, but DNSKEY set contains keys that are unsupported, treat as insecure", new Object[]{ds.getName(), ds.getFootprint(), ds.getDigestID(), ds.getAlgorithm()});
                    return KeyEntry.newNullKeyEntry(dsRrset.getName(), dsRrset.getDClass(), badKeyTTL);
                }
                dnskeyRrset.setSecurityStatus(SecurityStatus.SECURE);
                return KeyEntry.newKeyEntry(dnskeyRrset, sigalg);
            }
            if (needs == null || lastVerificationResult.status != SecurityStatus.BOGUS) continue;
            needs.setBogus(ds.getAlgorithm());
        }
        if (hasAlgoRefusal && !hasCheckedDs) {
            log.debug("No supported DS records were found -- treating as insecure");
            ke = KeyEntry.newNullKeyEntry(dsRrset.getName(), dsRrset.getDClass(), badKeyTTL);
            ke.setBadReason(2, R.get("failed.ds.nodigest", dsRrset.getName()));
            return ke;
        }
        if (!hasUsefulDs) {
            log.debug("No usable DS records were found -- treating as insecure");
            ke = KeyEntry.newNullKeyEntry(dsRrset.getName(), dsRrset.getDClass(), badKeyTTL);
            ke.setBadReason(2, R.get("failed.ds.no_usable_digest", dsRrset.getName()));
            return ke;
        }
        log.debug("Failed to match any usable DS to a DNSKEY");
        if (needs != null && (alg = needs.missing()) != 0) {
            log.debug("Missing verification of DNSKEY signature with algorithm {} ({})", (Object)alg, (Object)DNSSEC.Algorithm.string(alg));
        }
        ke = KeyEntry.newBadKeyEntry(dsRrset.getName(), dsRrset.getDClass(), badKeyTTL);
        ke.setBadReason(lastVerificationResult.edeReason, lastVerificationResult.reason);
        return ke;
    }

    private JustifiedSecStatus verifyDnskeysWithDs(SRRset dnskeyRrset, DSRecord ds, Instant date, AtomicInteger numDsChecked) {
        int numDsOk = 0;
        int numDsSizeUnsupported = 0;
        for (Record dsnkeyr : dnskeyRrset.rrs(false)) {
            DNSKEYRecord dnskey = (DNSKEYRecord)dsnkeyr;
            log.trace("Validating DNSKEY {} (footprint={}, alg={}) against DS {} (footprint={}, digest={}, alg={})", new Object[]{dnskey.getName(), dnskey.getFootprint(), dnskey.getAlgorithm(), ds.getName(), ds.getFootprint(), ds.getDigestID(), ds.getAlgorithm()});
            if (ds.getFootprint() != dnskey.getFootprint() || ds.getAlgorithm() != dnskey.getAlgorithm()) {
                log.trace("Footprint or algorithm mismatch, ignoring");
                continue;
            }
            numDsChecked.getAndIncrement();
            if (!this.dsDigestMatchesDnskey(ds, dnskey)) {
                log.debug("DS did not match DNSKEY, ignoring");
                if (numDsChecked.get() <= numDsOk + this.maxDsMatchFailures) continue;
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("dnskey.ds_max_match", new Object[0]));
            }
            ++numDsOk;
            if (!this.isKeySizeSupported(dnskey)) {
                log.debug("DS okay but that DNSKEY size is not supported");
                ++numDsSizeUnsupported;
                continue;
            }
            JustifiedSecStatus sec = this.verifier.verify((RRset)dnskeyRrset, dnskey, date);
            if (sec.status != SecurityStatus.SECURE) continue;
            return sec;
        }
        if (numDsSizeUnsupported > 0) {
            return new JustifiedSecStatus(SecurityStatus.INSECURE, -1, null);
        }
        if (numDsChecked.get() == 0) {
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 9, R.get("dnskey.no_ds_alg_match", dnskeyRrset.getName(), DNSSEC.Algorithm.string(ds.getAlgorithm())));
        }
        if (numDsOk == 0) {
            return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("dnskey.no_ds_match", new Object[0]));
        }
        return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("dnskey.ds_match_mismatch", new Object[0]));
    }

    private boolean dsDigestMatchesDnskey(DSRecord ds, DNSKEYRecord dnskey) {
        byte[] keyHash;
        byte[] dsHash = ds.getDigest();
        try {
            DSRecord keyDigest = new DSRecord(Name.root, ds.getDClass(), 0L, ds.getDigestID(), dnskey);
            keyHash = keyDigest.getDigest();
        }
        catch (IllegalArgumentException iae) {
            log.debug("Digest generation failed", (Throwable)iae);
            return false;
        }
        if (!Arrays.equals(keyHash, dsHash)) {
            log.debug("Hash mismatch: key {} != ds {}", (Object)keyHash, (Object)dsHash);
            return false;
        }
        return true;
    }

    int favoriteDSDigestID(SRRset dsset) {
        if (this.digestPreference == null) {
            int max = 0;
            for (Record r : dsset.rrs(false)) {
                DSRecord ds = (DSRecord)r;
                if (ds.getDigestID() <= max || !this.isDigestSupported(ds.getDigestID()) || !this.isAlgorithmSupported(ds.getAlgorithm())) continue;
                max = ds.getDigestID();
            }
            return max;
        }
        for (int preference : this.digestPreference) {
            for (Record r : dsset.rrs(false)) {
                DSRecord ds = (DSRecord)r;
                if (ds.getDigestID() != preference) continue;
                return ds.getDigestID();
            }
        }
        return 0;
    }

    public JustifiedSecStatus verifySRRset(SRRset rrset, KeyEntry keyRrset, Instant date) {
        if (rrset.getSecurityStatus() == SecurityStatus.SECURE) {
            log.trace("RRset <{}/{}/{}> previously found to be SECURE", new Object[]{rrset.getName(), Type.string(rrset.getType()), DClass.string(rrset.getDClass())});
            return new JustifiedSecStatus(SecurityStatus.SECURE, -1, null);
        }
        JustifiedSecStatus res = this.verifier.verify(rrset, keyRrset, date);
        rrset.setSecurityStatus(res.status);
        return res;
    }

    public static Name rrsetWildcard(RRset rrset) {
        int labelDiff;
        List<RRSIGRecord> sigs = rrset.sigs();
        RRSIGRecord firstSig = sigs.get(0);
        for (int i = 1; i < sigs.size(); ++i) {
            if (sigs.get(i).getLabels() == firstSig.getLabels()) continue;
            throw new IllegalArgumentException("failed.wildcard.label_count_mismatch");
        }
        Name wn = rrset.getName();
        if (rrset.getName().isWild()) {
            wn = new Name(wn, 1);
        }
        if ((labelDiff = wn.labels() - 1 - firstSig.getLabels()) > 0) {
            return wn.wild(labelDiff);
        }
        return null;
    }

    public static Name longestCommonName(Name domain1, Name domain2) {
        int l = Math.min(domain1.labels(), domain2.labels());
        domain1 = new Name(domain1, domain1.labels() - l);
        domain2 = new Name(domain2, domain2.labels() - l);
        for (int i = 0; i < l - 1; ++i) {
            Name ns1 = new Name(domain1, i);
            if (!ns1.equals(new Name(domain2, i))) continue;
            return ns1;
        }
        return Name.root;
    }

    public static boolean strictSubdomain(Name domain1, Name domain2) {
        if (domain1.labels() <= domain2.labels()) {
            return false;
        }
        return new Name(domain1, domain1.labels() - domain2.labels()).equals(domain2);
    }

    public static Name closestEncloser(Name domain, Name owner, Name next) {
        Name n1 = ValUtils.longestCommonName(domain, owner);
        Name n2 = ValUtils.longestCommonName(domain, next);
        return n1.labels() > n2.labels() ? n1 : n2;
    }

    public static Name nsecWildcard(Name domain, SRRset set, NSECRecord nsec) throws NameTooLongException {
        Name origin = ValUtils.closestEncloser(domain, set.getName(), nsec.getNext());
        return Name.concatenate(WILDCARD, origin);
    }

    public static boolean nsecProvesNameError(SRRset set, NSECRecord nsec, Name qname) {
        Name owner = set.getName();
        Name next = nsec.getNext();
        if (qname.equals(owner)) {
            return false;
        }
        if (!next.subdomain(set.getSignerName())) {
            return false;
        }
        if (qname.subdomain(owner)) {
            if (nsec.hasType(39)) {
                return false;
            }
            if (nsec.hasType(2) && !nsec.hasType(6)) {
                return false;
            }
        }
        if (owner.equals(next)) {
            return ValUtils.strictSubdomain(qname, next);
        }
        if (owner.compareTo(next) > 0) {
            return owner.compareTo(qname) < 0 && ValUtils.strictSubdomain(qname, next);
        }
        return owner.compareTo(qname) < 0 && qname.compareTo(next) < 0;
    }

    public static boolean nsecProvesNoWC(SRRset set, NSECRecord nsec, Name qname) {
        Name ce = ValUtils.closestEncloser(qname, set.getName(), nsec.getNext());
        int labelsToStrip = qname.labels() - ce.labels();
        if (labelsToStrip > 0) {
            Name wcName = qname.wild(labelsToStrip);
            return ValUtils.nsecProvesNameError(set, nsec, wcName);
        }
        return false;
    }

    public static NsecProvesNodataResponse nsecProvesNodata(SRRset set, NSECRecord nsec, Name qname, int qtype) {
        NsecProvesNodataResponse result = new NsecProvesNodataResponse();
        if (!set.getName().equals(qname)) {
            if (ValUtils.strictSubdomain(nsec.getNext(), qname) && set.getName().compareTo(qname) < 0) {
                result.result = true;
                return result;
            }
            if (set.getName().isWild()) {
                Name ce = new Name(set.getName(), 1);
                if (ValUtils.strictSubdomain(qname, ce)) {
                    if (nsec.hasType(5)) {
                        log.debug("NSEC proofed wildcard CNAME");
                        result.result = false;
                        return result;
                    }
                    if (nsec.hasType(2) && !nsec.hasType(6)) {
                        log.debug("Wrong parent (wildcard) NSEC used");
                        result.result = false;
                        return result;
                    }
                    if (nsec.hasType(qtype)) {
                        log.debug("NSEC proofed that {} exists", (Object)Type.string(qtype));
                        result.result = false;
                        return result;
                    }
                }
                result.wc = ce;
                result.result = true;
                return result;
            }
            result.result = false;
            return result;
        }
        if (nsec.hasType(qtype)) {
            log.debug("NSEC proofed that {} exists", (Object)Type.string(qtype));
            result.result = false;
            return result;
        }
        if (nsec.hasType(5)) {
            log.debug("NSEC proofed CNAME");
            result.result = false;
            return result;
        }
        if (qtype != 43 && nsec.hasType(2) && !nsec.hasType(6)) {
            log.debug("NSEC proofed missing referral");
            result.result = false;
            return result;
        }
        if (qtype == 43 && nsec.hasType(6) && !Name.root.equals(qname)) {
            log.debug("NSEC from wrong zone");
            result.result = false;
            return result;
        }
        result.result = true;
        return result;
    }

    public JustifiedSecStatus nsecProvesNodataDsReply(Message request, SMessage response, KeyEntry keyRrset, Instant date) {
        int qclass;
        Name qname = request.getQuestion().getName();
        SRRset nsecRrset = response.findRRset(qname, 47, qclass = request.getQuestion().getDClass(), 2);
        if (nsecRrset != null) {
            JustifiedSecStatus res = this.verifySRRset(nsecRrset, keyRrset, date);
            if (res.status != SecurityStatus.SECURE) {
                return new JustifiedSecStatus(SecurityStatus.BOGUS, 6, R.get("failed.ds.nsec", res.reason));
            }
            NSECRecord nsec = (NSECRecord)nsecRrset.first();
            SecurityStatus status = ValUtils.nsecProvesNoDS(nsec, qname);
            switch (status) {
                case INSECURE: {
                    return new JustifiedSecStatus(status, -1, R.get("failed.ds.nodelegation", new Object[0]));
                }
                case SECURE: {
                    return new JustifiedSecStatus(status, -1, R.get("insecure.ds.nsec", new Object[0]));
                }
            }
            return new JustifiedSecStatus(status, 6, R.get("failed.ds.nsec.hasdata", new Object[0]));
        }
        NsecProvesNodataResponse ndp = new NsecProvesNodataResponse();
        Name ce = null;
        boolean hasValidNSEC = false;
        NSECRecord wcNsec = null;
        for (SRRset set : response.getSectionRRsets(2, 47)) {
            JustifiedSecStatus res = this.verifySRRset(set, keyRrset, date);
            if (res.status != SecurityStatus.SECURE) {
                return new JustifiedSecStatus(res.status, res.edeReason, R.get("failed.ds.nsec.ent", new Object[0]));
            }
            NSECRecord nsec = (NSECRecord)set.rrs(false).get(0);
            ndp = ValUtils.nsecProvesNodata(set, nsec, qname, 43);
            if (ndp.result) {
                hasValidNSEC = true;
                if (ndp.wc != null && nsec.getName().isWild()) {
                    wcNsec = nsec;
                }
            }
            if (!ValUtils.nsecProvesNameError(set, nsec, qname)) continue;
            ce = ValUtils.closestEncloser(qname, set.getName(), nsec.getNext());
        }
        if (!(ndp.wc == null || ce != null && ce.equals(ndp.wc))) {
            hasValidNSEC = false;
        }
        if (hasValidNSEC) {
            if (ndp.wc != null) {
                SecurityStatus status = ValUtils.nsecProvesNoDS(wcNsec, qname);
                return new JustifiedSecStatus(status, 12, R.get("failed.ds.nowildcardproof", new Object[0]));
            }
            return new JustifiedSecStatus(SecurityStatus.INSECURE, -1, R.get("insecure.ds.nsec.ent", new Object[0]));
        }
        return new JustifiedSecStatus(SecurityStatus.UNCHECKED, 5, R.get("failed.ds.nonconclusive", new Object[0]));
    }

    public boolean hasSignedNsecs(SMessage message) {
        for (SRRset set : message.getSectionRRsets(2)) {
            if (set.getType() != 47 && set.getType() != 50 || set.sigs().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static SecurityStatus nsecProvesNoDS(NSECRecord nsec, Name qname) {
        if (nsec.hasType(6) && !Name.root.equals(qname) || nsec.hasType(43)) {
            return SecurityStatus.BOGUS;
        }
        if (!nsec.hasType(2)) {
            return SecurityStatus.INSECURE;
        }
        return SecurityStatus.SECURE;
    }

    boolean atLeastOneSupportedAlgorithm(RRset dsRRset) {
        for (Record r : dsRRset.rrs(false)) {
            if (!this.isAlgorithmSupported(((DSRecord)r).getAlgorithm())) continue;
            return true;
        }
        return false;
    }

    boolean isAlgorithmSupported(int alg) {
        String configKey = "dnsjava.dnssec.algorithm." + alg;
        switch (alg) {
            case 1: {
                return false;
            }
            case 3: 
            case 6: {
                if (this.config == null) {
                    return false;
                }
                return Boolean.parseBoolean(this.config.getProperty(configKey, Boolean.FALSE.toString()));
            }
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: {
                return this.propertyOrTrueWithPrecondition(configKey, true);
            }
            case 12: {
                return this.propertyOrTrueWithPrecondition(configKey, this.hasGost);
            }
            case 15: {
                return this.propertyOrTrueWithPrecondition(configKey, this.hasEd25519);
            }
            case 16: {
                return this.propertyOrTrueWithPrecondition(configKey, this.hasEd448);
            }
        }
        return false;
    }

    private boolean isKeySizeSupported(RRset dnskeyRrset) {
        for (Record r : dnskeyRrset.rrs(false)) {
            if (this.isKeySizeSupported((DNSKEYRecord)r)) continue;
            return false;
        }
        return true;
    }

    private boolean isKeySizeSupported(DNSKEYRecord dnskey) {
        try {
            PublicKey publicKey = dnskey.getPublicKey();
            switch (dnskey.getAlgorithm()) {
                case 1: 
                case 5: 
                case 7: 
                case 8: 
                case 10: {
                    boolean valid;
                    int bitLength = ((RSAPublicKey)publicKey).getModulus().bitLength();
                    boolean bl = valid = bitLength >= this.minRsaKeySize;
                    if (!valid) {
                        log.debug("Key size {} for DNSKEY <{}/{}>, alg={}, id={} is less than minimum of {}", new Object[]{bitLength, dnskey.getName(), DClass.string(dnskey.getDClass()), DNSSEC.Algorithm.string(dnskey.getAlgorithm()), dnskey.getFootprint(), this.minRsaKeySize});
                    }
                    return valid;
                }
            }
            return true;
        }
        catch (DNSSEC.DNSSECException e) {
            return false;
        }
    }

    boolean atLeastOneSupportedDigest(RRset dsRRset) {
        for (Record r : dsRRset.rrs(false)) {
            if (!this.isDigestSupported(((DSRecord)r).getDigestID())) continue;
            return true;
        }
        return false;
    }

    boolean isDigestSupported(int digestID) {
        String configKey = "dnsjava.dnssec.digest." + digestID;
        switch (digestID) {
            case 1: 
            case 2: 
            case 4: {
                if (this.config == null) {
                    return true;
                }
                return Boolean.parseBoolean(this.config.getProperty(configKey, Boolean.TRUE.toString()));
            }
            case 3: {
                return this.propertyOrTrueWithPrecondition(configKey, this.hasGost);
            }
        }
        return false;
    }

    private boolean propertyOrTrueWithPrecondition(String configKey, boolean precondition) {
        if (!precondition) {
            return false;
        }
        if (this.config == null) {
            return true;
        }
        return Boolean.parseBoolean(this.config.getProperty(configKey, Boolean.TRUE.toString()));
    }

    public static class NsecProvesNodataResponse {
        boolean result;
        Name wc;
    }
}

