/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.message.impl;

import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.jaxws.message.Block;
import org.apache.axis2.jaxws.message.Protocol;
import org.apache.axis2.jaxws.message.util.StackableReader;
import org.apache.axis2.jaxws.message.util.XMLStreamReaderFilter;

public class XMLStreamReaderForXMLSpine
extends XMLStreamReaderFilter {
    OMElement root;
    private List<Block> headerBlocks = null;
    private List<Block> bodyBlocks = null;
    private List<Block> detailBlocks = null;
    private boolean consume = false;
    Protocol protocol = null;
    private static final String BODY = "Body";
    private static final String HEADER = "Header";
    private static final String FAULT = "Fault";
    private static final String DETAIL11 = "detail";
    private static final String DETAIL12 = "Detail";
    boolean inFault = false;
    private List<Block> insertBlocks = null;

    public XMLStreamReaderForXMLSpine(OMElement root, Protocol protocol, List<Block> headerBlocks, List<Block> bodyBlocks, List<Block> detailBlocks, boolean consume) {
        super(new StackableReader(root.getXMLStreamReader()));
        this.root = root;
        this.protocol = protocol;
        this.headerBlocks = headerBlocks;
        this.bodyBlocks = bodyBlocks;
        this.detailBlocks = detailBlocks;
        this.consume = consume;
    }

    @Override
    public int next() throws XMLStreamException {
        if (this.insertBlocks != null) {
            this.pushBlocks(this.insertBlocks, this.consume);
            this.insertBlocks = null;
        }
        int event = super.next();
        if (this.isStartElement()) {
            QName qName = super.getName();
            if (qName.getLocalPart().equals(BODY) && qName.getNamespaceURI().equals(this.root.getNamespace().getNamespaceURI())) {
                if (this.bodyBlocks != null) {
                    this.insertBlocks = this.bodyBlocks;
                    this.bodyBlocks = null;
                }
            } else if (qName.getLocalPart().equals(HEADER) && qName.getNamespaceURI().equals(this.root.getNamespace().getNamespaceURI())) {
                if (this.headerBlocks != null) {
                    this.insertBlocks = this.headerBlocks;
                    this.headerBlocks = null;
                }
            } else if (qName.getLocalPart().equals(FAULT) && qName.getNamespaceURI().equals(this.root.getNamespace().getNamespaceURI())) {
                this.inFault = true;
            } else if (this.inFault && (qName.getLocalPart().equals(DETAIL11) && this.protocol.equals((Object)Protocol.soap11) || qName.getLocalPart().equals(DETAIL12) && this.protocol.equals((Object)Protocol.soap12)) && this.detailBlocks != null) {
                this.insertBlocks = this.detailBlocks;
                this.detailBlocks = null;
            }
        }
        return event;
    }

    private void pushBlocks(List<Block> blocks, boolean consume) throws XMLStreamException {
        try {
            StackableReader sr = (StackableReader)this.delegate;
            for (int i = blocks.size() - 1; i >= 0; --i) {
                Block block = blocks.get(i);
                if (block == null) continue;
                sr.push(block.getXMLStreamReader(consume));
            }
        }
        catch (WebServiceException me) {
            throw new XMLStreamException(me);
        }
    }
}

