/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.blob;

import org.apache.axiom.blob.MemoryBlobChunk;
import org.apache.axiom.blob.MemoryBlobInputStream;

final class MemoryBlobInputStreamImpl
extends MemoryBlobInputStream {
    private MemoryBlobChunk chunk;
    private int index;
    private MemoryBlobChunk markChunk;
    private int markIndex;

    MemoryBlobInputStreamImpl(MemoryBlobChunk firstChunk) {
        this.markChunk = this.chunk = firstChunk;
    }

    private void updateChunk() {
        while (this.chunk != null && this.index == this.chunk.size) {
            this.chunk = this.chunk.nextChunk;
            this.index = 0;
        }
    }

    @Override
    public int read(byte[] buffer, int off, int len) {
        int read = 0;
        while (len > 0) {
            this.updateChunk();
            if (this.chunk == null) {
                if (read != 0) break;
                return -1;
            }
            int c = Math.min(len, this.chunk.size - this.index);
            System.arraycopy(this.chunk.buffer, this.index, buffer, off, c);
            this.index += c;
            off += c;
            len -= c;
            read += c;
        }
        return read;
    }

    @Override
    public int read(byte[] buffer) {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public int read() {
        this.updateChunk();
        if (this.chunk == null) {
            return -1;
        }
        return this.chunk.buffer[this.index++] & 0xFF;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.markChunk = this.chunk;
        this.markIndex = this.index;
    }

    @Override
    public synchronized void reset() {
        this.chunk = this.markChunk;
        this.index = this.markIndex;
    }

    @Override
    public long skip(long n) {
        long skipped = 0L;
        while (n > 0L) {
            this.updateChunk();
            if (this.chunk == null) break;
            int c = (int)Math.min(n, (long)(this.chunk.size - this.index));
            this.index += c;
            skipped += (long)c;
            n -= (long)c;
        }
        return skipped;
    }

    @Override
    public int available() {
        if (this.chunk == null) {
            return 0;
        }
        long available = this.chunk.size - this.index;
        MemoryBlobChunk chunk = this.chunk.nextChunk;
        while (chunk != null) {
            if ((available += (long)chunk.size) > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            chunk = chunk.nextChunk;
        }
        return (int)available;
    }

    @Override
    public void close() {
        this.chunk = null;
    }
}

