/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import org.apache.axiom.mime.Header;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.OMMultipartWriter;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.MessageFormatter;
import org.apache.axis2.transport.http.util.URLTemplatingUtil;

public class MultipartFormDataFormatter
implements MessageFormatter {
    public static final String DEFAULT_CONTENT_TYPE = "text/plain; charset=US-ASCII";
    public static final String DISPOSITION_TYPE = "form-data";

    @Override
    public String getContentType(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        String contentType = "multipart/form-data";
        String encoding = format.getCharSetEncoding();
        if (encoding != null) {
            contentType = contentType + "; charset=" + encoding;
        }
        contentType = contentType + "; boundary=" + format.getMimeBoundary();
        return contentType;
    }

    @Override
    public URL getTargetAddress(MessageContext messageContext, OMOutputFormat format, URL targetURL) throws AxisFault {
        targetURL = URLTemplatingUtil.getTemplatedURL(targetURL, messageContext, false);
        return targetURL;
    }

    @Override
    public String formatSOAPAction(MessageContext messageContext, OMOutputFormat format, String soapAction) {
        return soapAction;
    }

    @Override
    public void writeTo(MessageContext messageContext, OMOutputFormat format, OutputStream outputStream, boolean preserve) throws AxisFault {
        OMElement dataOut = messageContext.getEnvelope().getBody().getFirstElement();
        if (dataOut != null) {
            try {
                Iterator iter1 = dataOut.getChildElements();
                OMFactory omFactory = OMAbstractFactory.getOMFactory();
                OMMultipartWriter writer = new OMMultipartWriter(outputStream, format);
                while (iter1.hasNext()) {
                    OMElement ele = (OMElement)iter1.next();
                    Iterator iter2 = ele.getChildElements();
                    if (iter2.hasNext()) {
                        OMElement omElement = omFactory.createOMElement(ele.getQName().getLocalPart(), null);
                        omElement.addChild((OMNode)this.processComplexType(omElement, ele.getChildElements(), omFactory));
                        OutputStream partOutputStream = writer.writePart(DEFAULT_CONTENT_TYPE, null, Collections.singletonList(new Header("Content-Disposition", "form-data; name=\"" + omElement.getLocalName() + "\"")));
                        partOutputStream.write(omElement.toString().getBytes());
                        partOutputStream.close();
                        continue;
                    }
                    OutputStream partOutputStream = writer.writePart(DEFAULT_CONTENT_TYPE, null, Collections.singletonList(new Header("Content-Disposition", "form-data; name=\"" + ele.getLocalName() + "\"")));
                    partOutputStream.write(ele.getText().getBytes());
                    partOutputStream.close();
                }
                writer.complete();
            }
            catch (IOException ex) {
                throw AxisFault.makeFault(ex);
            }
        }
    }

    private OMElement processComplexType(OMElement parent, Iterator iter, OMFactory omFactory) {
        OMElement omElement = null;
        while (iter.hasNext()) {
            OMElement ele = (OMElement)iter.next();
            omElement = omFactory.createOMElement(ele.getQName().getLocalPart(), null);
            Iterator iter2 = ele.getChildElements();
            if (iter2.hasNext()) {
                parent.addChild((OMNode)this.processComplexType(omElement, ele.getChildElements(), omFactory));
                continue;
            }
            omElement = omFactory.createOMElement(ele.getQName().getLocalPart(), null);
            omElement.setText(ele.getText());
            parent.addChild((OMNode)omElement);
        }
        return omElement;
    }
}

