.TH TEXTOOL 1
.SH NAME
textool \- TeX previewer for suntools
.SH SYNOPSIS
.B textool
[
.B \-p
] [
.B \-P
] [
.B \-b
] [
.B \-m
.I <mag>
] [ \+n ] [dvifile[.dvi]]
.SH DESCRIPTION
.LP
The
.I textool
program displays a TeX DVI file in a SunView window.
It is an enhanced version of the old "dvisun" command.
It can be driven either by keyboard commands typed into its window
or by using the mouse and various menus.
The label along the top of the window gives the current working directory,
the current filename and the current page number.
If invoked with no filename argument it will just display an empty
window.
If given a file it will read the preamble, postamble and page backpointers
so that it can go straight to a given page.
This means that it will only display files, it will not read stdin.
After each page of the
output is displayed the program will wait for a response from the user.
.SH OPTIONS
.TP
.B \-p
Pre-load all the font descriptions for fonts mentioned in the DVI file.
Normally only the information from the DVI postamble is loaded and the
various PK files are opened on demand.
This option loads all the character information except the actual character
bitmaps before displaying the first page.
.TP
.B \-P
A stronger version of the above.
In this case the character bitmaps are pre-loaded as well.
If this option is used no PK files will need to be accessed after the first
page is displayed.
The penalty is extra memory used for characters that may not be printed.
.TP
.BI \-m mag
This option gives a magnification factor (in the TeX form with
1000 for a magnification of 1) which will over-ride any magnification factor
specified in the DVI file.
The program may be compiled with this option disabled as it is uncommon
to have a set of PK files at several different magnifications.
.TP
.B \-b
This turns off SunView batching.
This slows page display down by a factor of about three but you get the
top lines of the screen displayed more quickly.
.TP
.BI \+ number
Skip
.I number
pages before displaying anything.
.LP
As well as those options described above
.I textool
will also consume the standard suntools options of the form \-W*,
for example the command "textool -Wi &" will start an instance
of
.I textool
in its iconic state in the background.
This can be used as a tool as and when required.
.SH "KEYBOARD COMMANDS"
.LP
Keyboard commands are provided to go forward and backwards 1 or n pages in
the file and to provide basic scrolling.
They are:
.TP
.B return
Go to next page in file.
.TP
.B space
Same as return.
.TP
.B b
Go to previous page in file.
.TP
.B p
Same as b.
.TP
.BI \+ nn
Skip forward
.I nn
pages.
The number is terminated with return.
.TP
.BI \- nn
Go back
.I nn
pages.
The number is again terminated with return.
.TP
.B h
Scroll over to the left edge of the page.
.TP
.B j
Scroll to bottom of page.
.TP
.B k
Scroll to top of page.
.TP
.B l
Scroll over to right edge of page.
.TP
.B c
Scroll to initial position, which is one inch down from the top and
half an inch in from the left edge.
.SH "MOUSE COMMANDS"
.LP
Both horizontal and vertical scrollbars are provided and these work in the
standard Sun fashion.
In particular the middle mouse button in either of the vertical bar's
page bottons will go to the next page and a shifted middle button will
go back a page.
.LP
Pressing the left mouse button changes the cursor to a set of cross-hairs
so alignment can be checked.
The arrow cursor is restored by releasing the button.
.LP
A menu is provided, popped up with the right mouse button, to do more
complex things.
Selections from this menu which require user text input will pop up a
text input panel with an appropriate prompt.
This panel is also used for error messages.
An error message can be removed by clicking on the panel with the left
mouse button.
Operations are interlocked to prevent impossible or inadvisable choices;
for example if there is no current file you cannot select the
"restart dvi file" or "go to page" choices.
.LP
The various selections are described below:
.TP
.B "restart dvi file"
This is a complete restart with the current file.
The DVI file is closed, font storage is freed and all PK files closed.
The file is then reopened and processed from scratch.
.TP
.B "go to page"
This allows direct access to any page in the file.
For documents of 10 pages or less a pullright menu is provided to select
the actual page.
For longer documents you must enter the page number into the pop up
panel.
.TP
.B "new file"
This closes the current file, as in the restart case, and then prompts for
a new file to process.
A leading ~ on the file name is interpreted in the same way as
.IR csh .
.TP
.B "change directory"
This prompts for a directory to replace the current working directory.
Leading ~ is allowed as in the "new file" case.
.TP
.B "run tex"
This creates a new window and runs tex on the .tex file with the same
basename as the current DVI file.
Only one extra window is allowed so all the other selections which
would require one are dimmed while the tex window is open.
As the DVI file is assumed to be changing the restart and page choices are
also dimmed.
To remove the window select "done" from its frame menu.
.TP
.B "run latex"
This is the same as the "run tex" case but runs latex instead.
.TP
.B "edit .tex file"
This runs an editor on the .tex file.
The EDITOR from the environment is used if there is one, otherwise
/usr/ucb/vi is used.
.TP
.B shell
This creates a window running whatever shell SunView finds for you.
.SH ENVIRONMENT
.LP
The following things are taken from the environment:
.TP
.B PKPATH
A comma separated list of directories to search for the font PK files
in place of the default described below.
.TP
.B HOME
Used for expanding tilde expressions of the form ~/dir.
.TP
.B EDITOR
The editor to use for the "edit .tex file" menu choice.
.SH FILES
.TP 2.5i
*.dvi
TeX DeVice Independent output file
.TP
/usr/local/lib/tex/fonts/pk/*.*pk
TeX default font rasters
.TP
/etc/passwd
Used for expanding tilde expressions of the form ~name/dir.
.SH "SEE ALSO"
dvitype(1),
dvisun(1),
tex(1)
.SH BUGS
When using fonts with decent resolution only part of a page appears
on the screen.
.SH AUTHORS
Mark Senn wrote the early versions of this program for the BBN BitGraph.
Stephan Bechtolsheim, Bob Brown, Richard Furuta, James Schaad
and Robert Wells improved it.
Norm Hutchinson ported the program to the Sun, becoming dvisun.
Yves Ledru did the initial suntools port, making texview.
Peter Ilieve re-did the suntools part,
tidied up and changed the font cacheing in the DVI part
and changed it to use PK files for fonts.

