/*
 * The various defines needed by TeXtool.
 */

typedef short Boolean;

char *calloc();
#define NEW(count, type) ((type *) calloc(count, sizeof(type)))

#define DEBUG				/* for massive printing of input */
							/* trace information; select with -d */
							/* or -x for pxl font stuff */

#define BINARYOPEN fopen	/* byte-oriented host version */

#define USEGLOBALMAG		/* when defined, the dvi global
							 * magnification is applied
							 * and user specified magnifications
							 * are also allowed
							 */
/*
 * This is problematical. It would allow better resolution to be obtained
 * by expanding the page but the code only allocates a fixed size canvas
 * for drawing on, big enough for a normal page. If magnification is used
 * the right and bottom of the page will not fall on the canvas and will
 * never be visible. Scrolling only moves the canvas under the frame and
 * will not redraw anything.
 * It is rare to have a complete set of fonts at any other mag anyway.
 */

#define KEYBOARDSCROLL			/* allows h,j,k,l,c scrolling */
					/*
					 * NOTE: this will expose bugs in the
					 * scrolling code in V3.0. Do not use
					 * with 3.0
					 */

#define  FALSE			0
#define  TRUE			1
#define  NOTCACHED		-1
#define  SETCMD			1
#define  PUTCMD			0
#define  DVIFORMAT		2
#define  FIRSTPXLCHAR	0
#define  LASTPXLCHAR	255
#define  NPXLCHARS		256
#define  PXLID			1001
#ifndef  PXLFONTAREA
#define  PXLFONTAREA	"/u/tex/pxlfiles"
#endif
#ifndef  PKFONTAREA
#define  PKFONTAREA		"/u/tex/pk118"
#endif
#define  MAXOPEN		9	/* limit of number of PXL files open */
							/*
							 * Not very many as SunView needs a lot
							 * You need two spare after allowing 3 for
							 * stdin, stout & stderr, 12 for SunView and
							 * 1 for the .dvi file. So MAXOPEN should
							 * be a max. of NOFILE-18.
							 */
#define  RESOLUTION		118	/* is really about 81 (11in raster, 900 dots */
#define  STACKSIZE		100
#define  STRSIZE		256

/* these are defined as macros for speed */
#define MoveDown(a) v += (a);
#define MoveOver(b) h += (b);
#define PixRound(x, conv) ((int)(((x) + ((conv) >> 1)) / (conv)));

/* status bits for main_state */
#define SB_INITIAL 01			/* for case where called as textool <file> */
#define SB_NOFILE 02			/* set after error or for no file name */
#define SB_NEWFILE 04			/* we have a new dvi name to open */
#define SB_NODVIFILE 010		/* we can't access(2) the dvi file */
#define SB_NOTEXFILE 020		/* we can't access(2) the tex file */
#define SB_INTERPRET 040		/* safe to process dvi file */
#define SB_PLUSNUMBER 0100		/* accumulating a positive number */
#define SB_MINUSNUMBER 0200		/* accumulating a negative number */
#define SB_TEXING 0400			/* subwindow currently running tex or latex */
#define SB_EDITING 01000		/* subwindow currently running vi */
#define SB_SHELL 02000			/* subwindow currently running shell */

