/* This file is part of dvi2bitmap; see README for copyrights and licence */

#ifndef UTIL_HEADER_READ
#define UTIL_HEADER_READ 1

#include <config.h>

//#include <vector>
#include <list>
#include <string>

#include "DviError.h"
#include "Bitmap.h"
#include "verbosity.h"

typedef STD::list<string> string_list;

namespace Util
{
    string_list& tokenise_string (string str);
    char** string_list_to_array(string_list& l);
    void delete_string_array(char** sl);
    bool parseRGB (Bitmap::BitmapColour&, const char*);

    void verbosity (const verbosities level);
}

#endif /* UTIL_HEADER_READ */
